/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *	  this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *	  this list of conditions and the following disclaimer in the documentation
 *	  and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.action;

import jp.morpho.webapp.servlet.http.HttpActionRequest;
import jp.morpho.webapp.servlet.http.HttpActionResponse;

/**
 * <P>
 * ActionHandlerChain ́AANVnht\[Xv̌Ăяo`F[J҂舵悤ɂ邽߂ɁAt[[NɂĒ񋟂IuWFNgłB
 * ActionHandler ́AActionHandlerChain gpāA`F[̎̃ANVnhĂяo܂B
 * ĂяõANVnh`F[̍Ō̃ANVnhłꍇ́AANVr[ɃCN[h܂B
 * </P>
 * @author Kenichi Fukuda
 */
public interface ActionHandlerChain
{

	/**
	 * <P>
	 * `F[̎̃ANVnhĂяo܂B
	 * ĂяõANVnh`F[̍Ō̃ANVnhłꍇ́AANVr[ɃCN[h܂B
	 * </P>
	 * @param request `F[ɉēnv
	 * @param response `F[ɉēn
	 * @exception ActionHandlerException ANVnh̒ʏ̏WOꍇ
	 */
	public void doActionHandler(
		HttpActionRequest request,
		HttpActionResponse response)
		throws ActionHandlerException;

	public void cancelActionHandlers();

	public void skipActionHandlers(int skip);

	public void cancelActionView();

}
