/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.util;


/**
 * <P>
 * StringTokenizer NXgpƁAAvP[Vŕg[Nɕł܂B
 * g[Ñ\bh́AStreamTokenizer NXŎgpĂ郁\bhɊȒPłB
 * StreamTokenizer \bhł́AʎqAAp͋ʂ܂B
 * ܂ARgFăXLbv邱Ƃ܂B
 * </P>
 * <P>
 * ؂蕶 (g[N𕪂镶) ́ANX̍쐬A܂̓g[N𓾂邽тɎwł܂B
 * </P>
 * <P>
 * StringTokenizer ̃CX^X́A쐬 returnDelims tO̒l true  false ɂāA삪قȂ܂B
 * </P>
 * <P>
 * <UL>
 * <LI>
 * tO false ̏ꍇ́A؂蕶̓g[N𕪂邾̂̂ƌȂB
 * g[N͋؂蕶łȂ 1 ȏAĂ镔ł
 * </LI>
 * <LI>
 * tO true ̏ꍇ́A؂蕶͂ꎩ̂g[NƌȂB
 * g[ŃA1 ̋؂蕶A؂蕶łȂ 1 ȏAĂ镔ł
 * </LI>
 * </UL>
 * </P>
 * <P>
 * StringTokenizer IuWFNg͓IɁAg[N镶݂̌̈ʒuǗ܂B
 * ̃Iy[V́Ǎ݂̈ʒuꂽ̐ɐi߂̂܂B
 * </P>
 * <P>
 * g[ŃAStringTokenizer IuWFNg쐬̂Ɏgpꂽ̕擾邱ƂɂĕԂ܂B
 * </P>
 * @author Kenichi Fukuda
 */
public class StringTokenizer extends java.util.StringTokenizer
{

	/**
	 * <P>
	 * w肳ꂽɑ΂ StringTokenizer 쐬܂B
	 * delim ׂ̂Ắ̕Ag[N؂邽߂̋؂蕶łB
	 * </P>
	 * <P>
	 * returnDelims tO true ̏ꍇ́A؂蕶g[NƂĕԂ܂B
	 * e؂蕶͒ 1 ̕ƂĕԂ܂B
	 * tO false ̏ꍇ́A؂蕶̓XLbvAg[N𕪂邾̂̂ƌȂ܂B
	 * </P>
	 * @param str ͂镶
	 * @param delim ؂蕶
	 * @param returnDelims ؂蕶g[NɊ܂߂邩ǂtO
	 */
	public StringTokenizer(
		String str,
		String delim,
		boolean returnDelims)
	{
		super(str, delim, returnDelims);
	}

	/**
	 * <P>
	 * w肳ꂽɑ΂ StringTokenizer 쐬܂B
	 * delim ́̕Ag[N𕪂؂蕶łB
	 * ؂蕶̂̂g[NƂĈ邱Ƃ͂܂B
	 * </P>
	 * @param str ͂镶
	 * @param delim ؂蕶
	 */
	public StringTokenizer(String str, String delim)
	{
		super(str, delim);
	}

	/**
	 * <P>
	 * w肳ꂽɑ΂ StringTokenizer 쐬܂B
	 * g[NiCU̓ftHg̋؂蕶Zbgg܂B
	 * ̃Zbg " \t\n\r\f" ŁA󔒕A^uAsAAsAїp蕶\܂B
	 * ؂蕶́Aꎩ̂g[NƂď邱Ƃ͂܂B
	 * </P>
	 * @param str ͂镶
	 */
	public StringTokenizer(String str)
	{
		super(str);
	}

	/**
	 * <P>
	 * ɎcĂ邷ׂẴg[NK؂ȏŊi[ĂzԂ܂B
	 * </P>
	 * @return ɎcĂ邷ׂẴg[NK؂ȏŊi[Ăz
	 */
	public synchronized String[] getTokens()
	{
		String[] tokens = new String[this.countTokens()];
		for (int i = 0; i < tokens.length; i++)
		{
			tokens[i] = this.nextToken();
		}
		return tokens;
	}

	/**
	 * <P>
	 * w肳ꂽg[NɕĕԂ܂B
	 * delim ׂ̂Ắ̕Ag[N؂邽߂̋؂蕶łB
	 * </P>
	 * <P>
	 * returnDelims tO true ̏ꍇ́A؂蕶g[NƂĕԂ܂B
	 * e؂蕶͒ 1 ̕ƂĕԂ܂B
	 * tO false ̏ꍇ́A؂蕶̓XLbvAg[N𕪂邾̂̂ƌȂ܂B
	 * </P>
	 * @param str ͂镶
	 * @param delim ؂蕶
	 * @param returnDelims ؂蕶g[NɊ܂߂邩ǂtO
	 * @return ׂẴg[NK؂ȏŊi[Ăz
	 */
	public synchronized static String[] tokenize(
		String str,
		String delim,
		boolean returnDelims)
	{
		return new StringTokenizer(str, delim, returnDelims).getTokens();
	}

	/**
	 * <P>
	 * w肳ꂽg[NɕĕԂ܂B
	 * delim ́̕Ag[N𕪂؂蕶łB
	 * ؂蕶̂̂g[NƂĈ邱Ƃ͂܂B
	 * </P>
	 * @param str ͂镶
	 * @param delim ؂蕶
	 * @return ׂẴg[NK؂ȏŊi[Ăz
	 */
	public synchronized static String[] tokenize(
		String str,
		String delim)
	{
		return new StringTokenizer(str, delim).getTokens();
	}

}
