/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.util;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/**
 * <P>
 * PrimitiveHolderList ̎łB
 * v~eBu^̒li[邱Ƃł܂B
 * </P>
 * @author Kumiko Hiroi
 */
public class ConversionList
	extends ListWrapper
	implements PrimitiveHolderList, Serializable
{

	/**
	 * <P>
	 * w̃Xgbv ConversionList \z܂B
	 * </P>
	 * @param list bv郊Xg
	 * @exception IllegalArgumentException Xg null ̏ꍇ
	 */
	public ConversionList(List list)
	{
		super(list);
	}

	/**
	 * <P>
	 * ConversionList \z܂B
	 * Vector bvV ConversionList \z܂B
	 * </P>
	 */
	public ConversionList()
	{
		super(new ArrayList());
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɂvf̓Xg[ƂĕԂ܂B
	 * </P>
	 * @param index Ԃvf̃CfbNX
	 * @return Xg̎w肳ꂽʒuɂvf
	 * @see jp.morpho.util.PrimitiveHolderList#getInputStream(int)
	 */
	public synchronized InputStream getInputStream(int index)
	{
		return (InputStream)get(index);
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɂvfAw肳ꂽ̓Xg[ɒu܂B
	 * </P>
	 * @param index uvf̃CfbNX
	 * @param element w肳ꂽʒuɊi[vf
	 * @see jp.morpho.util.PrimitiveHolderList#setInputStream(int, java.io.InputStream)
	 */
	public synchronized void setInputStream(int index, InputStream element)
	{
		set(index, element);
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɁAw肳ꂽ̓Xg[}܂B
	 * </P>
	 * @param index w̗vf}CfbNX
	 * @param element }vf
	 * @see jp.morpho.util.PrimitiveHolderList#addInputStream(int, java.io.InputStream)
	 */
	public synchronized void addInputStream(int index, InputStream element)
	{
		add(index, element);
	}

	/**
	 * <P>
	 * w肳ꂽ̓Xg[Xg̍Ōɒǉ܂B
	 * </P>
	 * @param element Xgɒǉvf
	 * @return ̌ĂяǒʁAXgύXꂽꍇ true
	 * @see jp.morpho.util.PrimitiveHolderList#addInputStream(java.io.InputStream)
	 */
	public synchronized boolean addInputStream(InputStream element)
	{
		return add(element);
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɂvf java.math.BigDecimal IuWFNgƂĕԂ܂B
	 * </P>
	 * @param index Ԃvf̃CfbNX
	 * @return Xg̎w肳ꂽʒuɂvf
	 * @see jp.morpho.util.PrimitiveHolderList#getBigDecimal(int)
	 */
	public synchronized BigDecimal getBigDecimal(int index)
	{
		Object obj = get(index);

		if (obj == null)
		{
			return null;
		}

		if (obj instanceof BigDecimal)
		{
			return (BigDecimal)obj;
		}
		else if (obj.toString().trim().length() > 0)
		{
			return new BigDecimal(obj.toString());
		}

		return null;
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɂvfAw肳ꂽ java.math.BigDecimal IuWFNgɒu܂B
	 * </P>
	 * @param index uvf̃CfbNX
	 * @param element w肳ꂽʒuɊi[vf
	 * @see jp.morpho.util.PrimitiveHolderList#setBigDecimal(int, java.math.BigDecimal)
	 */
	public synchronized void setBigDecimal(int index, BigDecimal element)
	{
		set(index, element);
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɁAw肳ꂽ java.math.BigDecimal IuWFNg}܂B
	 * </P>
	 * @param index w̗vf}CfbNX
	 * @param element }vf
	 * @see jp.morpho.util.PrimitiveHolderList#addBigDecimal(int, java.math.BigDecimal)
	 */
	public synchronized void addBigDecimal(int index, BigDecimal element)
	{
		add(index, element);
	}

	/**
	 * <P>
	 * w肳ꂽ java.math.BigDecimal IuWFNgXg̍Ōɒǉ܂B
	 * </P>
	 * @param element Xgɒǉvf
	 * @return ̌ĂяǒʁAXgύXꂽꍇ true
	 * @see jp.morpho.util.PrimitiveHolderList#addBigDecimal(java.math.BigDecimal)
	 */
	public synchronized boolean addBigDecimal(BigDecimal element)
	{
		return add(element);
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɂvf java.math.BigInteger IuWFNgƂĕԂ܂B
	 * </P>
	 * @param index Ԃvf̃CfbNX
	 * @return Xg̎w肳ꂽʒuɂvf
	 * @see jp.morpho.util.PrimitiveHolderList#getBigInteger(int)
	 */
	public synchronized BigInteger getBigInteger(int index)
	{
		Object obj = get(index);

		if (obj == null)
		{
			return null;
		}

		if (obj instanceof BigInteger)
		{
			return (BigInteger)obj;
		}
		else if (obj.toString().trim().length() > 0)
		{
			return new BigInteger(obj.toString());
		}

		return null;
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɂvfAw肳ꂽ java.math.BigInteger IuWFNgɒu܂B
	 * </P>
	 * @param index uvf̃CfbNX
	 * @param element w肳ꂽʒuɊi[vf
	 * @see jp.morpho.util.PrimitiveHolderList#setBigInteger(int, java.math.BigInteger)
	 */
	public synchronized void setBigInteger(int index, BigInteger element)
	{
		set(index, element);
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɁAw肳ꂽ java.math.BigInteger IuWFNg}܂B
	 * </P>
	 * @param index w̗vf}CfbNX
	 * @param element }vf
	 * @see jp.morpho.util.PrimitiveHolderList#addBigInteger(int, java.math.BigInteger)
	 */
	public synchronized void addBigInteger(int index, BigInteger element)
	{
		add(index, element);
	}

	/**
	 * <P>
	 * w肳ꂽ java.math.BigInteger IuWFNgXg̍Ōɒǉ܂B
	 * </P>
	 * @param element Xgɒǉvf
	 * @return ̌ĂяǒʁAXgύXꂽꍇ true
	 * @see jp.morpho.util.PrimitiveHolderList#addBigInteger(java.math.BigInteger)
	 */
	public synchronized boolean addBigInteger(BigInteger element)
	{
		return add(element);
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɂvf Java vO~O boolean ƂĕԂ܂B
	 * </P>
	 * @param index Ԃvf̃CfbNX
	 * @return Xg̎w肳ꂽʒuɂvf
	 * @see jp.morpho.util.PrimitiveHolderList#getBoolean(int)
	 */
	public synchronized boolean getBoolean(int index)
	{
		Object obj = get(index);

		if (obj == null)
		{
			return false;
		}

		if (obj instanceof Boolean)
		{
			return ((Boolean)obj).booleanValue();
		}
		else
		{
			return Boolean.valueOf(obj.toString()).booleanValue();
		}
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɂvfAw肳ꂽ boolean lɒu܂B
	 * </P>
	 * @param index uvf̃CfbNX
	 * @param element w肳ꂽʒuɊi[vf
	 * @see jp.morpho.util.PrimitiveHolderList#setBoolean(int, boolean)
	 */
	public synchronized void setBoolean(int index, boolean element)
	{
		set(index, new Boolean(element));
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɁAw肳ꂽ boolean l}܂B
	 * </P>
	 * @param index w̗vf}CfbNX
	 * @param element }vf
	 * @see jp.morpho.util.PrimitiveHolderList#addBoolean(int, boolean)
	 */
	public synchronized void addBoolean(int index, boolean element)
	{
		add(index, new Boolean(element));
	}

	/**
	 * <P>
	 * w肳ꂽ boolean lXg̍Ōɒǉ܂B
	 * </P>
	 * @param element Xgɒǉvf
	 * @return ̌ĂяǒʁAXgύXꂽꍇ true
	 * @see jp.morpho.util.PrimitiveHolderList#addBoolean(boolean)
	 */
	public synchronized boolean addBoolean(boolean element)
	{
		return add(new Boolean(element));
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɂvf Java vO~O byte ƂĕԂ܂B
	 * </P>
	 * @param index Ԃvf̃CfbNX
	 * @return Xg̎w肳ꂽʒuɂvf
	 * @see jp.morpho.util.PrimitiveHolderList#getByte(int)
	 */
	public synchronized byte getByte(int index)
	{
		Object obj = get(index);

		if (obj == null)
		{
			return 0;
		}

		if (obj instanceof Byte)
		{
			return ((Byte)obj).byteValue();
		}
		else if (obj.toString().trim().length() > 0)
		{
			return Byte.valueOf(obj.toString()).byteValue();
		}

		return 0;
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɂvfAw肳ꂽ byte lɒu܂B
	 * </P>
	 * @param index uvf̃CfbNX
	 * @param element w肳ꂽʒuɊi[vf
	 * @see jp.morpho.util.PrimitiveHolderList#setByte(int, byte)
	 */
	public synchronized void setByte(int index, byte element)
	{
		set(index, new Byte(element));
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɁAw肳ꂽ byte l}܂B
	 * </P>
	 * @param index w̗vf}CfbNX
	 * @param element }vf
	 * @see jp.morpho.util.PrimitiveHolderList#addByte(int, byte)
	 */
	public synchronized void addByte(int index, byte element)
	{
		add(index, new Byte(element));
	}

	/**
	 * <P>
	 * w肳ꂽ byte lXg̍Ōɒǉ܂B
	 * </P>
	 * @param element Xgɒǉvf
	 * @return ̌ĂяǒʁAXgύXꂽꍇ true
	 * @see jp.morpho.util.PrimitiveHolderList#addByte(byte)
	 */
	public synchronized boolean addByte(byte element)
	{
		return add(new Byte(element));
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɂvf Java vO~O byte zƂĕԂ܂B
	 * </P>
	 * @param index Ԃvf̃CfbNX
	 * @return Xg̎w肳ꂽʒuɂvf
	 * @see jp.morpho.util.PrimitiveHolderList#getBytes(int)
	 */
	public synchronized byte[] getBytes(int index)
	{
		return (byte[])get(index);
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɂvfAw肳ꂽ byte zɒu܂B
	 * </P>
	 * @param index uvf̃CfbNX
	 * @param element w肳ꂽʒuɊi[vf
	 * @see jp.morpho.util.PrimitiveHolderList#setBytes(int, byte[])
	 */
	public synchronized void setBytes(int index, byte[] element)
	{
		set(index, element);
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɁAw肳ꂽ byte z}܂B
	 * </P>
	 * @param index w̗vf}CfbNX
	 * @param element }vf
	 * @see jp.morpho.util.PrimitiveHolderList#addBytes(int, byte[])
	 */
	public synchronized void addBytes(int index, byte[] element)
	{
		add(index, element);
	}

	/**
	 * <P>
	 * w肳ꂽ byte zXg̍Ōɒǉ܂B
	 * </P>
	 * @param element Xgɒǉvf
	 * @return ̌ĂяǒʁAXgύXꂽꍇ true
	 * @see jp.morpho.util.PrimitiveHolderList#addBytes(byte[])
	 */
	public synchronized boolean addBytes(byte[] element)
	{
		return add(element);
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɂvf Java vO~O char ƂĕԂ܂B
	 * </P>
	 * @param index Ԃvf̃CfbNX
	 * @return Xg̎w肳ꂽʒuɂvf
	 * @see jp.morpho.util.PrimitiveHolderList#getChar(int)
	 */
	public synchronized char getChar(int index)
	{
		Object obj = get(index);

		if (obj == null)
		{
			return 0;
		}

		if (obj instanceof Character)
		{
			return ((Character)obj).charValue();
		}
		else if (obj.toString().trim().length() > 0)
		{
			return obj.toString().toCharArray()[0];
		}

		return 0;
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɂvfAw肳ꂽ char lɒu܂B
	 * </P>
	 * @param index uvf̃CfbNX
	 * @param element w肳ꂽʒuɊi[vf
	 * @see jp.morpho.util.PrimitiveHolderList#setChar(int, char)
	 */
	public synchronized void setChar(int index, char element)
	{
		set(index, new Character(element));
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɁAw肳ꂽ char l}܂B
	 * </P>
	 * @param index w̗vf}CfbNX
	 * @param element }vf
	 * @see jp.morpho.util.PrimitiveHolderList#addChar(int, char)
	 */
	public synchronized void addChar(int index, char element)
	{
		add(index, new Character(element));
	}

	/**
	 * <P>
	 * w肳ꂽ char lXg̍Ōɒǉ܂B
	 * </P>
	 * @param element Xgɒǉvf
	 * @return ̌ĂяǒʁAXgύXꂽꍇ true
	 * @see jp.morpho.util.PrimitiveHolderList#addChar(char)
	 */
	public synchronized boolean addChar(char element)
	{
		return add(new Character(element));
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɂvf java.io.Reader IuWFNgƂĕԂ܂B
	 * </P>
	 * @param index Ԃvf̃CfbNX
	 * @return Xg̎w肳ꂽʒuɂvf
	 * @see jp.morpho.util.PrimitiveHolderList#getReader(int)
	 */
	public synchronized Reader getReader(int index)
	{
		return (Reader)get(index);
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɂvfAw肳ꂽ java.io.Reader IuWFNgɒu܂B
	 * </P>
	 * @param index uvf̃CfbNX
	 * @param element w肳ꂽʒuɊi[vf
	 * @see jp.morpho.util.PrimitiveHolderList#setReader(int, java.io.Reader)
	 */
	public synchronized void setReader(int index, Reader element)
	{
		set(index, element);
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɁAw肳ꂽ java.io.Reader IuWFNg}܂B
	 * </P>
	 * @param index w̗vf}CfbNX
	 * @param element }vf
	 * @see jp.morpho.util.PrimitiveHolderList#addReader(int, java.io.Reader)
	 */
	public synchronized void addReader(int index, Reader element)
	{
		add(index, element);
	}

	/**
	 * <P>
	 * w肳ꂽ java.io.Reader IuWFNgXg̍Ōɒǉ܂B
	 * </P>
	 * @param element Xgɒǉvf
	 * @return ̌ĂяǒʁAXgύXꂽꍇ true
	 * @see jp.morpho.util.PrimitiveHolderList#addReader(java.io.Reader)
	 */
	public synchronized boolean addReader(Reader element)
	{
		return add(element);
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɂvf java.util.Date IuWFNgƂĕԂ܂B
	 * </P>
	 * @param index Ԃvf̃CfbNX
	 * @return Xg̎w肳ꂽʒuɂvf
	 * @see jp.morpho.util.PrimitiveHolderList#getDate(int)
	 */
	public synchronized Date getDate(int index)
	{
		Object obj = get(index);

		if (obj == null)
		{
			return null;
		}

		if (obj instanceof java.sql.Timestamp)
		{
			//java.sql.Timestamp IuWFNg̏ꍇ
			return new java.util.Date(((java.sql.Timestamp)obj).getTime());
		}
		else if (obj instanceof java.sql.Date)
		{
			//java.sql.Date IuWFNg̏ꍇ
			return new java.util.Date(((java.sql.Date)obj).getTime());
		}
		else if (obj instanceof java.sql.Time)
		{
			//java.sql.Time IuWFNg̏ꍇ
			return new java.util.Date(((java.sql.Time)obj).getTime());
		}
		else if (obj instanceof java.util.Date)
		{
			//java.util.Date IuWFNg̏ꍇ
			return (java.util.Date)obj;
		}
		else
		{
			//java.sql.Timestamp ̕\̏ꍇ
			try
			{
				return new java.util.Date(java.sql.Timestamp.valueOf(obj.toString()).getTime());
			}
			catch (Exception e)
			{
			}

			//java.sql.Date ̕\̏ꍇ
			try
			{
				return new java.util.Date(java.sql.Date.valueOf(obj.toString()).getTime());
			}
			catch (Exception e)
			{
			}

			//java.sql.Time ̕\̏ꍇ
			try
			{
				return new java.util.Date(java.sql.Time.valueOf(obj.toString()).getTime());
			}
			catch (Exception e)
			{
			}

			//java.util.Date ̕\̏ꍇ
			try
			{
				return new SimpleDateFormat(
					"EEE MMM dd HH:mm:ss zzz yyyy",
					Locale.US).parse(obj.toString());
			}
			catch (Exception e)
			{
			}

			//t/̕\̏ꍇ
			try
			{
				return DateFormat.getDateTimeInstance().parse(obj.toString());
			}
			catch (Exception e)
			{
			}

			//t̕\̏ꍇ
			try
			{
				return DateFormat.getDateInstance().parse(obj.toString());
			}
			catch (Exception e)
			{
			}

			//̕\̏ꍇ
			try
			{
				return DateFormat.getTimeInstance().parse(obj.toString());
			}
			catch (Exception e)
			{
			}
		}

		return null;
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɂvf̕\ pattern Ŏw肵t^p^[ŉ͂āAjava.util.Date IuWFNgƂĕԂ܂B
	 * </P>
	 * @param index Ԃvf̃CfbNX
	 * @param pattern t^p^[
	 * @return Xg̎w肳ꂽʒuɂvf
	 * @see jp.morpho.util.PrimitiveHolderList#parseDate(int, java.lang.String)
	 */
	public synchronized Date parseDate(int index, String pattern)
	{
		Object obj = get(index);

		if (obj == null)
		{
			return null;
		}

		try
		{
			return new SimpleDateFormat(pattern).parse(obj.toString());
		}
		catch (ParseException e)
		{
		}

		return null;
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɂvfAw肳ꂽ java.util.Date lɒu܂B
	 * </P>
	 * @param index uvf̃CfbNX
	 * @param element w肳ꂽʒuɊi[vf
	 * @see jp.morpho.util.PrimitiveHolderList#setDate(int, java.util.Date)
	 */
	public synchronized void setDate(int index, Date element)
	{
		set(index, element);
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɁAw肳ꂽ java.util.Date l}܂B
	 * </P>
	 * @param index w̗vf}CfbNX
	 * @param element }vf
	 * @see jp.morpho.util.PrimitiveHolderList#addDate(int, java.util.Date)
	 */
	public synchronized void addDate(int index, Date element)
	{
		add(index, element);
	}

	/**
	 * <P>
	 * w肳ꂽ java.util.Date lXg̍Ōɒǉ܂B
	 * </P>
	 * @param element Xgɒǉvf
	 * @return ̌ĂяǒʁAXgύXꂽꍇ true
	 * @see jp.morpho.util.PrimitiveHolderList#addDate(java.util.Date)
	 */
	public synchronized boolean addDate(Date element)
	{
		return add(element);
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɂvf Java vO~O double ƂĕԂ܂B
	 * </P>
	 * @param index Ԃvf̃CfbNX
	 * @return Xg̎w肳ꂽʒuɂvf
	 * @see jp.morpho.util.PrimitiveHolderList#getDouble(int)
	 */
	public synchronized double getDouble(int index)
	{
		Object obj = get(index);

		if (obj == null)
		{
			return 0;
		}

		if (obj instanceof Double)
		{
			return ((Double)obj).doubleValue();
		}
		else if (obj.toString().trim().length() > 0)
		{
			return Double.valueOf(obj.toString()).doubleValue();
		}

		return 0;
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɂvfAw肳ꂽ double lɒu܂B
	 * </P>
	 * @param index uvf̃CfbNX
	 * @param element w肳ꂽʒuɊi[vf
	 * @see jp.morpho.util.PrimitiveHolderList#setDouble(int, double)
	 */
	public synchronized void setDouble(int index, double element)
	{
		set(index, new Double(element));
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɁAw肳ꂽ double l}܂B
	 * </P>
	 * @param index w̗vf}CfbNX
	 * @param element }vf
	 * @see jp.morpho.util.PrimitiveHolderList#addDouble(int, double)
	 */
	public synchronized void addDouble(int index, double element)
	{
		add(index, new Double(element));
	}

	/**
	 * <P>
	 * w肳ꂽ double lXg̍Ōɒǉ܂B
	 * </P>
	 * @param element Xgɒǉvf
	 * @return ̌ĂяǒʁAXgύXꂽꍇ true
	 * @see jp.morpho.util.PrimitiveHolderList#addDouble(double)
	 */
	public synchronized boolean addDouble(double element)
	{
		return add(new Double(element));
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɂvf Java vO~O float ƂĕԂ܂B
	 * </P>
	 * @param index Ԃvf̃CfbNX
	 * @return Xg̎w肳ꂽʒuɂvf
	 * @see jp.morpho.util.PrimitiveHolderList#getFloat(int)
	 */
	public synchronized float getFloat(int index)
	{
		Object obj = get(index);

		if (obj == null)
		{
			return 0;
		}

		if (obj instanceof Float)
		{
			return ((Float)obj).floatValue();
		}
		else if (obj.toString().trim().length() > 0)
		{
			return Double.valueOf(obj.toString()).floatValue();
		}

		return 0;
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɂvfAw肳ꂽ float lɒu܂B
	 * </P>
	 * @param index uvf̃CfbNX
	 * @param element w肳ꂽʒuɊi[vf
	 * @see jp.morpho.util.PrimitiveHolderList#setFloat(int, float)
	 */
	public synchronized void setFloat(int index, float element)
	{
		set(index, new Float(element));
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɁAw肳ꂽ float l}܂B
	 * </P>
	 * @param index w̗vf}CfbNX
	 * @param element }vf
	 * @see jp.morpho.util.PrimitiveHolderList#addFloat(int, float)
	 */
	public synchronized void addFloat(int index, float element)
	{
		add(index, new Float(element));
	}

	/**
	 * <P>
	 * w肳ꂽ float lXg̍Ōɒǉ܂B
	 * </P>
	 * @param element Xgɒǉvf
	 * @return ̌ĂяǒʁAXgύXꂽꍇ true
	 * @see jp.morpho.util.PrimitiveHolderList#addFloat(float)
	 */
	public synchronized boolean addFloat(float element)
	{
		return add(new Float(element));
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɂvf Java vO~O int ƂĕԂ܂B
	 * </P>
	 * @param index Ԃvf̃CfbNX
	 * @return Xg̎w肳ꂽʒuɂvf
	 * @see jp.morpho.util.PrimitiveHolderList#getInt(int)
	 */
	public synchronized int getInt(int index)
	{
		Object obj = get(index);

		if (obj == null)
		{
			return 0;
		}

		if (obj instanceof Integer)
		{
			return ((Integer)obj).intValue();
		}
		else if (obj.toString().trim().length() > 0)
		{
			return Double.valueOf(obj.toString()).intValue();
		}

		return 0;
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɂvfAw肳ꂽ int lɒu܂B
	 * </P>
	 * @param index uvf̃CfbNX
	 * @param element w肳ꂽʒuɊi[vf
	 * @see jp.morpho.util.PrimitiveHolderList#setInt(int, int)
	 */
	public synchronized void setInt(int index, int element)
	{
		set(index, new Integer(element));
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɁAw肳ꂽ int l}܂B
	 * </P>
	 * @param index w̗vf}CfbNX
	 * @param element }vf
	 * @see jp.morpho.util.PrimitiveHolderList#addInt(int, int)
	 */
	public synchronized void addInt(int index, int element)
	{
		add(index, new Integer(element));
	}

	/**
	 * <P>
	 * w肳ꂽ int lXg̍Ōɒǉ܂B
	 * </P>
	 * @param element Xgɒǉvf
	 * @return ̌ĂяǒʁAXgύXꂽꍇ true
	 * @see jp.morpho.util.PrimitiveHolderList#addInt(int)
	 */
	public synchronized boolean addInt(int element)
	{
		return add(new Integer(element));
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɂvf Java vO~O long ƂĕԂ܂B
	 * </P>
	 * @param index Ԃvf̃CfbNX
	 * @return Xg̎w肳ꂽʒuɂvf
	 * @see jp.morpho.util.PrimitiveHolderList#getLong(int)
	 */
	public synchronized long getLong(int index)
	{
		Object obj = get(index);

		if (obj == null)
		{
			return 0;
		}

		if (obj instanceof Long)
		{
			return ((Long)obj).longValue();
		}
		else if (obj.toString().trim().length() > 0)
		{
			return Double.valueOf(obj.toString()).longValue();
		}

		return 0;
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɂvfAw肳ꂽ long lɒu܂B
	 * </P>
	 * @param index uvf̃CfbNX
	 * @param element w肳ꂽʒuɊi[vf
	 * @see jp.morpho.util.PrimitiveHolderList#setLong(int, long)
	 */
	public synchronized void setLong(int index, long element)
	{
		set(index, new Long(element));
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɁAw肳ꂽ long l}܂B
	 * </P>
	 * @param index w̗vf}CfbNX
	 * @param element }vf
	 * @see jp.morpho.util.PrimitiveHolderList#addLong(int, long)
	 */
	public synchronized void addLong(int index, long element)
	{
		add(index, new Long(element));
	}

	/**
	 * <P>
	 * w肳ꂽ long lXg̍Ōɒǉ܂B
	 * </P>
	 * @param element Xgɒǉvf
	 * @return ̌ĂяǒʁAXgύXꂽꍇ true
	 * @see jp.morpho.util.PrimitiveHolderList#addLong(long)
	 */
	public synchronized boolean addLong(long element)
	{
		return add(new Long(element));
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɂvf Java vO~O Object ƂĕԂ܂B
	 * </P>
	 * @param index Ԃvf̃CfbNX
	 * @return Xg̎w肳ꂽʒuɂvf
	 * @see jp.morpho.util.PrimitiveHolderList#getObject(int)
	 */
	public synchronized Object getObject(int index)
	{
		return get(index);
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɂvfAw肳ꂽ Object lɒu܂B
	 * </P>
	 * @param index uvf̃CfbNX
	 * @param element w肳ꂽʒuɊi[vf
	 * @see jp.morpho.util.PrimitiveHolderList#setObject(int, java.lang.Object)
	 */
	public synchronized void setObject(int index, Object element)
	{
		set(index, element);
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɁAw肳ꂽ Object l}܂B
	 * </P>
	 * @param index w̗vf}CfbNX
	 * @param element }vf
	 * @see jp.morpho.util.PrimitiveHolderList#addObject(int, java.lang.Object)
	 */
	public synchronized void addObject(int index, Object element)
	{
		add(index, element);
	}

	/**
	 * <P>
	 * w肳ꂽ Object lXg̍Ōɒǉ܂B
	 * </P>
	 * @param element Xgɒǉvf
	 * @return ̌ĂяǒʁAXgύXꂽꍇ true
	 * @see jp.morpho.util.PrimitiveHolderList#addObject(java.lang.Object)
	 */
	public synchronized boolean addObject(Object element)
	{
		return add(element);
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɂvf Java vO~O short ƂĕԂ܂B
	 * </P>
	 * @param index Ԃvf̃CfbNX
	 * @return Xg̎w肳ꂽʒuɂvf
	 * @see jp.morpho.util.PrimitiveHolderList#getShort(int)
	 */
	public synchronized short getShort(int index)
	{
		Object obj = get(index);

		if (obj == null)
		{
			return 0;
		}

		if (obj instanceof Short)
		{
			return ((Short)obj).shortValue();
		}
		else if (obj.toString().trim().length() > 0)
		{
			return Double.valueOf(obj.toString()).shortValue();
		}

		return 0;
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɂvfAw肳ꂽ short lɒu܂B
	 * </P>
	 * @param index uvf̃CfbNX
	 * @param element w肳ꂽʒuɊi[vf
	 * @see jp.morpho.util.PrimitiveHolderList#setShort(int, short)
	 */
	public synchronized void setShort(int index, short element)
	{
		set(index, new Short(element));
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɁAw肳ꂽ short l}܂B
	 * </P>
	 * @param index w̗vf}CfbNX
	 * @param element }vf
	 * @see jp.morpho.util.PrimitiveHolderList#addShort(int, short)
	 */
	public synchronized void addShort(int index, short element)
	{
		add(index, new Short(element));
	}

	/**
	 * <P>
	 * w肳ꂽ short lXg̍Ōɒǉ܂B
	 * </P>
	 * @param element Xgɒǉvf
	 * @return ̌ĂяǒʁAXgύXꂽꍇ true
	 * @see jp.morpho.util.PrimitiveHolderList#addShort(short)
	 */
	public synchronized boolean addShort(short element)
	{
		return add(new Short(element));
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɂvf Java vO~O String ƂĕԂ܂B
	 * </P>
	 * @param index Ԃvf̃CfbNX
	 * @return Xg̎w肳ꂽʒuɂvf
	 * @see jp.morpho.util.PrimitiveHolderList#getString(int)
	 */
	public synchronized String getString(int index)
	{
		Object obj = get(index);

		if (obj == null)
		{
			return null;
		}

		if (obj instanceof String)
		{
			return (String)obj;
		}
		else
		{
			return obj.toString();
		}
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɂvfAw肳ꂽ String lɒu܂B
	 * </P>
	 * @param index uvf̃CfbNX
	 * @param element w肳ꂽʒuɊi[vf
	 * @see jp.morpho.util.PrimitiveHolderList#setString(int, java.lang.String)
	 */
	public synchronized void setString(int index, String element)
	{
		set(index, element);
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɁAw肳ꂽ String l}܂B
	 * </P>
	 * @param index w̗vf}CfbNX
	 * @param element }vf
	 * @see jp.morpho.util.PrimitiveHolderList#addString(int, java.lang.String)
	 */
	public synchronized void addString(int index, String element)
	{
		add(index, element);
	}

	/**
	 * <P>
	 * w肳ꂽ String lXg̍Ōɒǉ܂B
	 * </P>
	 * @param element Xgɒǉvf
	 * @return ̌ĂяǒʁAXgύXꂽꍇ true
	 * @see jp.morpho.util.PrimitiveHolderList#addString(java.lang.String)
	 */
	public synchronized boolean addString(String element)
	{
		return add(element);
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɂvf java.util.List ƂĕԂ܂B
	 * </P>
	 * @param index Ԃvf̃CfbNX
	 * @return Xg̎w肳ꂽʒuɂvf
	 * @see jp.morpho.util.PrimitiveHolderList#getList(int)
	 */
	public synchronized List getList(int index)
	{
		return (List)get(index);
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɂvfAw肳ꂽ java.util.List ɒu܂B
	 * </P>
	 * @param index uvf̃CfbNX
	 * @param element w肳ꂽʒuɊi[vf
	 * @see jp.morpho.util.PrimitiveHolderList#setList(int, java.util.List)
	 */
	public synchronized void setList(int index, List element)
	{
		set(index, element);
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɁAw肳ꂽ java.util.List }܂B
	 * </P>
	 * @param index w̗vf}CfbNX
	 * @param element }vf
	 * @see jp.morpho.util.PrimitiveHolderList#addList(int, java.util.List)
	 */
	public synchronized void addList(int index, List element)
	{
		add(index, element);
	}

	/**
	 * <P>
	 * w肳ꂽ java.util.List Xg̍Ōɒǉ܂B
	 * </P>
	 * @param element Xgɒǉvf
	 * @return ̌ĂяǒʁAXgύXꂽꍇ true
	 * @see jp.morpho.util.PrimitiveHolderList#addList(java.util.List)
	 */
	public synchronized boolean addList(List element)
	{
		return add(element);
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɂvf java.util.Map ƂĕԂ܂B
	 * </P>
	 * @param index Ԃvf̃CfbNX
	 * @return Xg̎w肳ꂽʒuɂvf
	 * @see jp.morpho.util.PrimitiveHolderList#getMap(int)
	 */
	public synchronized Map getMap(int index)
	{
		return (Map)get(index);
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɂvfAw肳ꂽ java.util.Map ɒu܂B
	 * </P>
	 * @param index uvf̃CfbNX
	 * @param element w肳ꂽʒuɊi[vf
	 * @see jp.morpho.util.PrimitiveHolderList#setMap(int, java.util.Map)
	 */
	public synchronized void setMap(int index, Map element)
	{
		set(index, element);
	}

	/**
	 * <P>
	 * Xg̎w肳ꂽʒuɁAw肳ꂽ java.util.Map }܂B
	 * </P>
	 * @param index w̗vf}CfbNX
	 * @param element }vf
	 * @see jp.morpho.util.PrimitiveHolderList#addMap(int, java.util.Map)
	 */
	public synchronized void addMap(int index, Map element)
	{
		add(index, element);
	}

	/**
	 * <P>
	 * w肳ꂽ java.util.Map Xg̍Ōɒǉ܂B
	 * </P>
	 * @param element Xgɒǉvf
	 * @return ̌ĂяǒʁAXgύXꂽꍇ true
	 * @see jp.morpho.util.PrimitiveHolderList#addMap(java.util.Map)
	 */
	public synchronized boolean addMap(Map element)
	{
		return add(element);
	}

	/**
	 * <P>
	 * V ConversionList \zāAw̃Xg炷ׂĂ̗vf\zV  ConversionList ɃRs[܂B
	 * w̃}bv ConversionList ̏ꍇ́AԂ܂B
	 * </P>
	 * @param list V\z ConversionList Ɋi[郊Xg
	 * @return ConversionList
	 */
	public synchronized static ConversionList valueOf(List list)
	{
		if (list instanceof ConversionList)
		{
			return (ConversionList)list;
		}
		else
		{
			return new ConversionList(list);
		}
	}

}
