/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.io;

import java.io.File;
import java.net.URI;

/**
 * <P>
 * Abv[ht@C̃pX̒ە\łB
 * </P>
 * @author Kumiko Hiroi
 */
public class UploadFile
	extends File
{

	/** NCAgIt@C̃pX */
	private String clientPath = null;

	/** Abv[hꂽt@C̃Rec` */
	private String contentType = null;

	/**
	 * <P>
	 * w肳ꂽpX𒊏ۃpXɕϊāAV UploadFile ̃CX^X𐶐܂B
	 * w肳ꂽ񂪋̏̕ꍇAʂ͋̒ۃpXɂȂ܂B
	 * </P>
	 * @param pathname pX
	 * @exception NullPointerException pathname  null ̏ꍇ
	 */
	public UploadFile(String pathname)
	{
		super(pathname);
	}

	/**
	 * <P>
	 * epX񂨂юqpX񂩂V UploadFile ̃CX^X𐶐܂B
	 * </P>
	 * <P>
	 * parent  null ̏ꍇAV UploadFile ̃CX^X́Aw肳ꂽ child pXŒP UploadFile RXgN^Ăяo悤ɐ܂B
	 * </P>
	 * <P>
	 * łȂꍇAparent pX̓fBNgAchild pX̓fBNg܂̓t@C܂B
	 * child pX񂪐΂̏ꍇA̓VXeɈˑ@ő΃pXɕϊ܂B
	 * parent ̏̕ꍇAV UploadFile ̃CX^X́Achild 𒊏ۃpXɕϊǍʂVXeɈˑftHgfBNgɉ邱ƂŐ܂B
	 * łȂꍇAepX͒ۃpXɕϊAqۃpX͐eɉ܂B
	 * </P>
	 * @param parent epX
	 * @param child qpX
	 * @exception NullPointerException child  null ̏ꍇ
	 */
	public UploadFile(String parent, String child)
	{
		super(parent, child);
	}

	/**
	 * <P>
	 * eۃpXюqpX񂩂V UploadFile ̃CX^X𐶐܂B
	 * </P>
	 * <P>
	 * parent  null ̏ꍇAV UploadFile ̃CX^X́Aw肳ꂽ child pXŒP UploadFile RXgN^Ăяo悤ɐ܂B
	 * </P>
	 * <P>
	 * łȂꍇAparent ۃpX̓fBNgAchild pX̓fBNg܂̓t@C܂B
	 * child pX񂪐΂̏ꍇA̓VXeɈˑ@ő΃pXɕϊ܂B
	 * parent ̒ۃpX̏ꍇAV UploadFile ̃CX^X́Achild 𒊏ۃpXɕϊǍʂVXeɈˑftHgfBNgɉ邱ƂŐ܂B
	 * łȂꍇAepX͒ۃpXɕϊAqۃpX͐eɉ܂B
	 * </P>
	 * @param parent eۃpX
	 * @param child qpX
	 * @exception NullPointerException child  null ̏ꍇ
	 */
	public UploadFile(File parent, String child)
	{
		super(parent, child);
	}

	/**
	 * <P>
	 * w肳ꂽ file: URI 𒊏ۃpXɕϊāAV UploadFile ̃CX^X𐶐܂B
	 * </P>
	 * <P>
	 * file: URI ̌`̓VXeɈˑ邽߁ÃRXgN^sϊVXeɈˑ܂B
	 * </P>
	 * <P>
	 * w肳ꂽۃpX <I>f</I> ̏ꍇ́Â悤ɕϊ܂B
	 * <BLOCKQUOTE><TT>
	 * new File(<I>f</I>.toURI()).equals(<I>f</I>)
	 * </TT></BLOCKQUOTE>
	 * ̗̏ꍇA̒ۃpXAURIAѐVۃpX́A Java z}V̌̕Ăяoō쐬Kv܂B
	 * AIy[eBOVXẻz}Vō쐬 file: URI ʂ̃Iy[eBOVXẻz}V̒ۃpXɕϊꍇAʏ͂̂悤ɕϊ܂B
	 * </P>
	 * @param uri Kw^̐ URIB`́A"file"ApXAANG[AtOgBpX͕Kw肷BANG[AуtOg͒`Ȃ
	 * @exception NullPointerException uri  null ̏ꍇ
	 * @exception IllegalArgumentException L̃p[^̑OĂȂꍇ
	 */
	public UploadFile(URI uri)
	{
		super(uri);
	}

	/**
	 * <P>
	 * NCAgIt@C̃pXԂ܂B
	 * </P>
	 * @return NCAgIt@C̃pX
	 */
	public String getClientPath()
	{
		return (clientPath != null) ? clientPath : "";
	}

	/**
	 * <P>
	 * NCAgIt@C̃pXݒ肵܂B
	 * </P>
	 * @param clientPath NCAgIt@C̃pX
	 */
	public void setClientPath(String clientPath)
	{
		this.clientPath = clientPath;
	}

	/**
	 * <P>
	 * Abv[hꂽt@C̃Rec`Ԃ܂B
	 * </P>
	 * @return Abv[hꂽt@C̃Rec`
	 */
	public String getContentType()
	{
		return (contentType != null) ? contentType : "";
	}

	/**
	 * <P>
	 * Abv[hꂽt@C̃Rec`ݒ肵܂B
	 * </P>
	 * @param contentType Abv[hꂽt@C̃Rec`
	 */
	public void setContentType(String contentType)
	{
		this.contentType = contentType;
	}

}
