/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *	  this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *	  this list of conditions and the following disclaimer in the documentation
 *	  and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.config;

import java.io.InputStream;

import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/**
 * <P>
 * ̃NX́AzLqqgpăIuWFNg`܂B
 * IuWFNg`ɂ́AXML ŋLqꂽzLqq̓̓Xg[ƌ`IuWFNgnāAconfigure \bhĂяo܂B
 * </P>
 * <P>
 * ̃NX́AzLqqɋLqꂽƂɃIuWFNg̃\bhĂяoAVIuWFNg쐬邱ƂɂAconfigure \bhɓnꂽIuWFNg`܂B
 * </P>
 * @author Kumiko Hiroi
 */
public class Configuration
	extends DefaultHandler
{

	/** gbvx̃m[hAʏ configure ^Õm[h */
	private Node topNode = null;

	/** ǂݍݒ̃m[h */
	private Node currentNode = null;

	/** SAX p[T */
	private SAXParser parser;

	/**
	 * <P>
	 * Configuration IuWFNg쐬܂B
	 * </P>
	 * @param validating p[T XML hLg؂悤ɐݒ肳Ăꍇ trueAłȂꍇ false
	 */
	public Configuration(boolean validating)
	{
		try
		{
			SAXParserFactory factory = SAXParserFactory.newInstance();
			factory.setValidating(validating);
			parser = factory.newSAXParser();
		}
		catch (Exception e)
		{
			throw new Error(e.toString());
		}
	}

	/**
	 * <P>
	 * Configuration IuWFNg쐬܂B
	 * </P>
	 */
	public Configuration()
	{
		this(true);
	}

	/**
	 * <P>
	 * XML zLqqgpăIuWFNg`܂B
	 * </P>
	 * @param obj `IuWFNg
	 * @param in XML zLqq̓̓Xg[
	 * @exception ConfigureException IuWFNg`łȂꍇ
	 */
	public void configure(Object obj, InputStream in) throws ConfigureException
	{
		try
		{
			parser.parse(in, this);
//			configure(obj, topNode, 0);
			topNode.configure(obj, 0);
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ConfigureException(e);
		}
	}

	/**
	 * <P>
	 * vf̊Jnʒm󂯎܂B
	 * </P>
	 * <P>
	 * ^O̎ނɂAem[h쐬܂B
	 * </P>
	 * @param uri O URI
	 * @param localName OuCq܂܂Ȃ[JBOԏsȂꍇ͋󕶎
	 * @param qName OuCqCBCgpłȂꍇ͋󕶎
	 * @param attributes w肳ꂽ܂̓ftHg̑
	 * @exception SAXException SAX OBق̗ObvĂ\
	 */
	public void startElement(String uri, String localName, String qName, Attributes attributes)
		throws SAXException
	{
		try
		{
			String name = (uri == null || uri.equals("")) ? qName : localName;
			int tag = NodeTypes.getTag(name);
			Node node = null;
			switch (tag)
			{
				case NodeTypes.SET:
					node = new SetNode(currentNode, attributes);
					break;
				case NodeTypes.GET:
					node = new GetNode(currentNode, attributes);
					break;
				case NodeTypes.CALL:
					node = new CallNode(currentNode, attributes);
					break;
				case NodeTypes.PUT:
					node = new PutNode(currentNode, attributes);
					break;
				case NodeTypes.NEW:
					node = new NewNode(currentNode, attributes);
					break;
				case NodeTypes.ARG:
					node = new ArgNode(currentNode, attributes);
					break;
				case NodeTypes.SYSTEMPROPERTY:
					node = new SystemPropertyNode(currentNode, attributes);
					break;
				case NodeTypes.CONFIGURE:
					node = new ConfigureNode(currentNode, attributes);
					break;
				case NodeTypes.ADD:
					node = new AddNode(currentNode, attributes);
					break;
			}
			if (topNode == null)
			{
				topNode = node;
			}
			else
			{
				currentNode.add(node);
			}
			currentNode = node;
		}
		catch (Exception e)
		{
			throw new SAXException(e);
		}
	}

	/**
	 * <P>
	 * vf̏Iʒm󂯎܂B
	 * </P>
	 * @param uri O URI
	 * @param localName OuCq܂܂Ȃ[JBOԏsȂꍇ͋󕶎
	 * @param qName OuCq XML 1.0 CBCgpłȂꍇ͋󕶎
	 * @exception SAXException SAX OBق̗ObvĂ\
	 */
	public void endElement(String uri, String localName, String qName) throws SAXException
	{
		currentNode = currentNode.getParent();
	}

	/**
	 * <P>
	 * vf̕f[^̒ʒm󂯎܂B
	 * </P>
	 * <P>
	 * vf̕f[^󂯎Am[hɊi[܂B
	 * </P>
	 * @param ch 
	 * @param start z̊Jnʒu
	 * @param length z񂩂gp镶
	 * @exception SAXException SAX OBق̗ObvĂ\
	 */
	public void characters(char[] ch, int start, int length) throws SAXException
	{
		currentNode.add(new String(ch, start, length));
	}
}
