/*
 * Decompiled with CFR 0.152.
 */
package jp.morpho.webapp.validator;

import java.io.InputStream;
import java.net.URL;
import javax.servlet.ServletContext;
import jp.morpho.config.Configuration;
import jp.morpho.config.ConfigureException;
import jp.morpho.webapp.validator.Validator;
import jp.morpho.webapp.validator.ValidatorException;
import jp.morpho.webapp.validator.ValidatorFactory;
import jp.morpho.webapp.validator.ValidatorSequence;

public class ValidatorFactoryImpl
extends ValidatorFactory {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Validator generateValidator(String name) throws ValidatorException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        URL configURL = cl.getResource(name);
        InputStream in = null;
        try {
            try {
                in = configURL.openStream();
                Validator validator = this.generateValidator(in);
                Object var6_6 = null;
                try {
                    in.close();
                    return validator;
                }
                catch (Exception e) {
                    // empty catch block
                }
                return validator;
            }
            catch (Exception e) {
                throw new ValidatorException(e);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {}
            catch (Exception e) {
                throw throwable;
            }
            in.close();
            throw throwable;
        }
    }

    public Validator generateValidator(InputStream in) throws ValidatorException {
        ValidatorSequence v = null;
        v = new ValidatorSequence();
        Configuration config = new Configuration();
        try {
            config.configure(v, in);
        }
        catch (ConfigureException e) {
            throw new ValidatorException(e);
        }
        return v;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Validator generateValidator(ServletContext sc, String path) throws ValidatorException {
        InputStream in = null;
        try {
            try {
                in = sc.getResourceAsStream(path);
                Validator validator = this.generateValidator(in);
                Object var5_5 = null;
                try {
                    in.close();
                    return validator;
                }
                catch (Exception e) {
                    // empty catch block
                }
                return validator;
            }
            catch (Exception e) {
                throw new ValidatorException(e);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {}
            catch (Exception e) {
                throw throwable;
            }
            in.close();
            throw throwable;
        }
    }
}

