/*
 * Decompiled with CFR 0.152.
 */
package jp.morpho.webapp.validator;

import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import jp.morpho.util.ConversionList;
import jp.morpho.util.ConversionMap;

public class ValidationState
implements Serializable {
    protected ConversionMap fieldMap = new ConversionMap();
    protected ConversionList messageList = new ConversionList();

    protected ValidationState() {
    }

    public void addInvalidField(String fieldName, String message) {
        if (fieldName == null) {
            throw new NullPointerException();
        }
        if (!this.fieldMap.containsKey(fieldName)) {
            this.fieldMap.putObject(fieldName, new ConversionList());
        }
        if (message != null) {
            this.messageList.add(message);
            this.fieldMap.getList(fieldName).add(new Integer(this.messageList.size() - 1));
        }
    }

    public String[] getMessages(String fieldName) {
        ConversionList idxList;
        if (this.fieldMap.containsKey(fieldName) && (idxList = ConversionList.valueOf(this.fieldMap.getList(fieldName))) != null && idxList.size() > 0) {
            String[] messages = new String[idxList.size()];
            int i = 0;
            while (i < messages.length) {
                messages[i] = (String)this.messageList.get(idxList.getInt(i));
                ++i;
            }
            return messages;
        }
        return new String[0];
    }

    public String[] getMessages() {
        Object[] messages = new String[this.messageList.size()];
        return (String[])this.messageList.toArray(messages);
    }

    public int getMessageCount() {
        return this.messageList.size();
    }

    public boolean isInvalidField(String fieldName) {
        return this.fieldMap.containsKey(fieldName);
    }

    public String[] getInvalidFieldNames() {
        String[] fieldNames = new String[this.fieldMap.size()];
        return this.fieldMap.values().toArray(fieldNames);
    }

    public int getInvalidFieldCount() {
        return this.fieldMap.size();
    }

    public static synchronized ValidationState getInstance(HttpServletRequest request) {
        ValidationState vs = (ValidationState)request.getAttribute("jp.morpho.webapp.servlet.ActionRequest.validator.ValidationState");
        if (vs == null) {
            vs = new ValidationState();
            request.setAttribute("jp.morpho.webapp.servlet.ActionRequest.validator.ValidationState", (Object)vs);
        }
        return vs;
    }
}

