#!/usr/local/bin/perl
use strict;

=pod
use Time::HiRes qw/time/;
my $time = time;
END{ printf STDERR "time-cost: %.1lf s\n",time - $time }
=cut

#
# 
#
my @file = @ARGV;
if(@file < 2){
	die qq/usage: $0 file1 file2 [..fileN]\n/;
}
my $n = 0;
foreach my $file (@file){
	open(FILE, "<", $file) or die qq($file : $!);
#	printf("%d %s\n", $n, $file);
	$n++;
	close FILE;
}
my $n_max = $n - 1;

#
# őO
#
my $g_max = 0;
foreach my $file (@file){
	open(FILE, "<", $file) or die qq($file : $!);
	my $g_chk = 0;
	while(<FILE>){
		if(m/^(\d+)\t(.+)\t(\d+)$/){
			my $g = $3;
			if($g_chk and $g_chk < $g){
				die qq($file : gram field not sorted.);
			}
			$g_chk = $g;
			if($g > $g_max){
				$g_max = $g;
			}
		}else{
			chomp;
			die qq($file : invalid format line.);
		}
	}
	close FILE;
}
#printf("g_max = %d\n", $g_max);

#
# OɃ}[W
#
for(my $g = $g_max; 1 <= $g; $g--){
	#
	# 
	#
	my %freq;
	my $i = 0;
	foreach my $file (@file){
		open(FILE, "<", $file) or die qq($file : $!);
		while(<FILE>){
			if(m/^(\d+)\t(.+)\t(\d+)$/){
				last if $3 < $g;
				next if $g < $3;
				$freq{"$2"}->[$i] = $1;
			}
		}
		close FILE;
		$i++;
	}
	
	#
	# ʏo
	#
	foreach my $str (sort keys %freq){
		my @freq = @{$freq{$str}};
		my $freq_total = 0;
		my $freq_sqr_total = 0;

		foreach my $n (0 .. $n_max){
			$freq[$n] ||= 0;
			$freq_total += $freq[$n];
			$freq_sqr_total += $freq[$n] * $freq[$n];
		}

		my $a = $freq_total / @freq;
		my $V = $freq_sqr_total / @freq - $a * $a;
		my $s = sqrt($V);
		my $C = $s / $a;

		printf "%d\t%s\t%d\t<%s>\t%.3lf\n",
			$freq_total, $str, $g, join(" ", @freq), $C;
	}
}

__END__
