import os, locale, gettext

__version__ = "$Revision: 1.2 $"

def gettext_find(domain, localedir=None, languages=None):
    """Search and return a locale path for given language.
    """
    dname = '%s.mo' %(domain)
    args = []
    if localedir:
        args.append(os.path.abspath(localedir))
    for i in [languages, 'LC_MESSAGES', dname]:
        if i:
            args.append(i)
    path = apply(os.path.join, args)
    return path

def gettrans(domain, localeprefix=''):
    """Find and return translator for given domain under the prefix.
    """
    language = locale.setlocale(locale.LC_ALL, '')
    localepath = os.path.join(os.path.abspath(localeprefix), 'locale')
    gettext.textdomain(domain)
    gettext.find = gettext_find
    try:
        tr = gettext.translation(domain, localepath, language)
    except IOError:
        tr = None
    except:
        raise
    if tr:
        return tr
    else:
        return None
