package monalipse.server;

import java.util.Arrays;
import java.util.Collection;

import monalipse.editors.ThreadViewerEditor;
import monalipse.widgets.ColoredText;

public class Response
{
	public static final int FRAGMENT_NAME = 0x01;
	public static final int FRAGMENT_MAIL = 0x02;
	public static final int FRAGMENT_DATE = 0x04;
	public static final int FRAGMENT_BODY = 0x08;

	private HeaderLine header;
	private ColoredText.LineFragment[] name;
	private ColoredText.LineFragment[] mail;
	private ColoredText.LineFragment[] date;
	private ColoredText.Line[] body;
	private String delimiter;
	private String title;

	public Response(int responseNumber, ColoredText.LineFragment[] name, ColoredText.LineFragment[] mail, ColoredText.LineFragment[] date, ColoredText.Line[] body, String delimiter, String title)
	{
		this.header = new HeaderLine(responseNumber);
		this.name = name;
		this.mail = mail;
		this.date = date;
		this.body = body;
		this.delimiter = delimiter;
		this.title = title;
		
		header.addLineFragment(new ColoredText.LineFragment(responseNumber + " : ", ThreadViewerEditor.ThreadViewerAttributes.COLOR_BODY, ThreadViewerEditor.ThreadViewerAttributes.FONT_NORMAL, false));
		header.addLineFragments(name);
		header.addLineFragment(new ColoredText.LineFragment(" [", ThreadViewerEditor.ThreadViewerAttributes.COLOR_BODY, ThreadViewerEditor.ThreadViewerAttributes.FONT_NORMAL, false));
		header.addLineFragments(mail);
		header.addLineFragment(new ColoredText.LineFragment("] ", ThreadViewerEditor.ThreadViewerAttributes.COLOR_BODY, ThreadViewerEditor.ThreadViewerAttributes.FONT_NORMAL, false));
		header.addLineFragments(date);
	}
	
	public boolean equals(Object obj)
	{
		if (obj instanceof Response)
		{
			Response resp = (Response) obj;
			
			if(name.length != resp.name.length ||
				mail.length != resp.mail.length ||
				date.length != resp.date.length ||
				body.length != resp.body.length)
			{
				return false;
			}
			
			if(!header.getText().equals(resp.header.getText()))
				return false;
				
			for(int i = 0; i < body.length; i++)
			{
				if(!body[i].getText().equals(resp.body[i].getText()))
					return false;
			}
			
			return true;
		}
		
		return false;
	}
	
	public int hashCode()
	{
		if(date.length == 0)
			return 0;
		else
			return date[0].getText().hashCode();
	}

	public void getLines(Collection receiver)
	{
		receiver.add(header);
		receiver.addAll(Arrays.asList(body));
	}
	
	public ColoredText.LineFragment[] getName()
	{
		return name;
	}

	public ColoredText.LineFragment[] getMail()
	{
		return mail;
	}

	public ColoredText.LineFragment[] getDate()
	{
		return date;
	}

	public ColoredText.Line[] getBody()
	{
		return body;
	}
	
	public String getDelimiter()
	{
		return delimiter;
	}
	
	public String getTitle()
	{
		return title;
	}
	
	public boolean hasLink(int fragment, String url)
	{
		if((fragment & FRAGMENT_NAME) != 0 && hasLink(name, url))
			return true;
		if((fragment & FRAGMENT_MAIL) != 0 && hasLink(mail, url))
			return true;
		if((fragment & FRAGMENT_DATE) != 0 && hasLink(date, url))
			return true;
		if((fragment & FRAGMENT_BODY) != 0 && hasLink(body, url))
			return true;
		return false;
	}

	private static boolean hasLink(ColoredText.Line[] lines, String url)
	{
		for(int i = 0; i < lines.length; i++)
		{
			ColoredText.Line line = lines[i];
			for(int j = 0; j < line.getLineFragmentCount(); j++)
			{
				ColoredText.LineFragment fragment = line.getLineFragmentAt(j);
				if(fragment instanceof ILinkedLineFragment &&
					((ILinkedLineFragment)fragment).getURL().equals(url))
				{
					return true;
				}
			}
		}
		return false;
	}

	private static boolean hasLink(ColoredText.LineFragment[] fragments, String url)
	{
		for(int i = 0; i < fragments.length; i++)
		{
			if(fragments[i] instanceof ILinkedLineFragment &&
				((ILinkedLineFragment)fragments[i]).getURL().equals(url))
			{
				return true;
			}
		}
		return false;
	}

	public void unmarkNewResponse()
	{
		unmarkNewResponse(header);
		for(int i = 0; i < body.length; i++)
			unmarkNewResponse(body[i]);
	}

	private static void unmarkNewResponse(ColoredText.Line line)
	{
		for(int j = line.getLineFragmentCount() - 1; 0 <= j; j--)
		{
			ColoredText.LineFragment f = line.getLineFragmentAt(j);
			if(f instanceof INewResponseLineFragment)
				((INewResponseLineFragment)f).unmark();
		}
	}

	public class HeaderLine extends ColoredText.Line
	{
		private int responseNumber;
	
		public HeaderLine(int responseNumber)
		{
			super(0);
			this.responseNumber = responseNumber;
		}
		
		public int getReponseNumber()
		{
			return responseNumber;
		}
		
		public Response getResponse()
		{
			return Response.this;
		}
		
		private void addLineFragments(ColoredText.LineFragment[] fragments)
		{
			for(int i = 0; i < fragments.length; i++)
				addLineFragment(fragments[i]);
		}
	}

	public static interface INewResponseLineFragment
	{
		public void unmark();
	}
}
