package monalipse.server;

import java.net.URL;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public interface IBBSServer
{
	public String getTargetName();

	public void initialize(IFolder folder);
	public IFolder getServerFolder();
	public void createServerFolder(IProgressMonitor monitor) throws CoreException;

	public IBoardTreeNode getBoardTree();
	public IBBSBoard getBoardOf(URL url);

	public boolean boardListChanged(IResourceChangeEvent event);
	public void updateBoardList();
	public URL getURLOf(IFile file);
}
