/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.threadpool;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.threadpool.MTQueue;
import org.apache.commons.threadpool.ThreadPool;

public class DefaultThreadPool
implements Runnable,
ThreadPool {
    private Log log;
    private MTQueue queue;
    private boolean stopped;
    static /* synthetic */ Class class$0;

    public DefaultThreadPool() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.commons.threadpool.DefaultThreadPool");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = LogFactory.getLog((Class)clazz);
        this.queue = new MTQueue();
        this.stopped = false;
        this.startThread();
    }

    public DefaultThreadPool(int numberOfThreads) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.commons.threadpool.DefaultThreadPool");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = LogFactory.getLog((Class)clazz);
        this.queue = new MTQueue();
        this.stopped = false;
        int i = 0;
        while (i < numberOfThreads) {
            this.startThread();
            ++i;
        }
    }

    public DefaultThreadPool(int numberOfThreads, int threadPriority) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.commons.threadpool.DefaultThreadPool");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = LogFactory.getLog((Class)clazz);
        this.queue = new MTQueue();
        this.stopped = false;
        int i = 0;
        while (i < numberOfThreads) {
            this.startThread(threadPriority);
            ++i;
        }
    }

    public Thread startThread() {
        Thread thread = new Thread(this);
        thread.start();
        return thread;
    }

    public Thread startThread(int priority) {
        Thread thread = new Thread(this);
        thread.setPriority(priority);
        thread.start();
        return thread;
    }

    public void stop() {
        this.stopped = true;
    }

    public int getRunnableCount() {
        return this.queue.size();
    }

    public void invokeLater(Runnable task) {
        this.queue.add(task);
    }

    public void run() {
        while (!this.stopped) {
            Runnable task = (Runnable)this.queue.remove();
            if (task == null) continue;
            try {
                task.run();
            }
            catch (Throwable t) {
                this.handleException(t);
            }
        }
    }

    protected void handleException(Throwable t) {
        this.log.error((Object)("Caught: " + t), t);
    }
}

