/*
 * Decompiled with CFR 0.152.
 */
package monalipse.wizards;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import monalipse.MonalipsePlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class NewMonalipseProjectCreationWizard
extends BasicNewResourceWizard
implements IExecutableExtension {
    private static final String WINDOW_PROBLEMS_TITLE = MonalipsePlugin.getResourceString("NewProject.errorOpeningWindow");
    private static final String FINAL_PERSPECTIVE = "finalPerspective";
    private static final String PREFERRED_PERSPECTIVES = "preferredPerspectives";
    private static final String INITIAL_PROJECT_NAME = "monalipse.log";
    private IWorkbench workbench;
    private IStructuredSelection selection;
    private WizardNewProjectCreationPage mainPage;
    private IProject newProject;
    private IConfigurationElement configElement;

    public void addPages() {
        super.addPages();
        this.mainPage = new WizardNewProjectCreationPage("monalipseNewProjectPage"){

            public void setPageComplete(boolean complete) {
                boolean exists = false;
                IProject[] proj = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                int i = 0;
                while (i < proj.length) {
                    try {
                        if (proj[i].getNature("monalipse.monalipsenature") != null) {
                            exists = true;
                        }
                    }
                    catch (CoreException coreException) {}
                    ++i;
                }
                super.setPageComplete(complete && !exists);
                if (complete && exists) {
                    this.setErrorMessage(MonalipsePlugin.getResourceString("NewProject.errorAlreadyExists"));
                }
            }

            public void createControl(Composite parent) {
                super.createControl(parent);
                this.validate((Control)parent);
            }

            private void validate(Control control) {
                Text text;
                if (control instanceof Composite) {
                    Control[] children = ((Composite)control).getChildren();
                    int i = 0;
                    while (i < children.length) {
                        this.validate(children[i]);
                        ++i;
                    }
                } else if (control instanceof Text && (text = (Text)control).getText().equals(NewMonalipseProjectCreationWizard.INITIAL_PROJECT_NAME)) {
                    this.getShell().getDisplay().asyncExec(new Runnable(this, text){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ Text val$text;
                        {
                            this.this$1 = var1_1;
                            this.val$text = text;
                        }

                        public void run() {
                            this.val$text.setText("monalipse.log");
                        }
                    });
                }
            }
        };
        this.mainPage.setTitle(MonalipsePlugin.getResourceString("NewProject.title"));
        this.mainPage.setDescription(MonalipsePlugin.getResourceString("NewProject.description"));
        this.mainPage.setInitialProjectName(INITIAL_PROJECT_NAME);
        this.addPage((IWizardPage)this.mainPage);
    }

    private IProject createNewProject() {
        if (this.newProject != null) {
            return this.newProject;
        }
        final IProject newProjectHandle = this.mainPage.getProjectHandle();
        IPath newPath = null;
        if (!this.mainPage.useDefaults()) {
            newPath = this.mainPage.getLocationPath();
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProjectDescription description = workspace.newProjectDescription(newProjectHandle.getName());
        description.setLocation(newPath);
        String[] natureIDs = description.getNatureIds();
        String[] newNatureIDs = new String[natureIDs.length + 1];
        System.arraycopy(natureIDs, 0, newNatureIDs, 0, natureIDs.length);
        newNatureIDs[newNatureIDs.length - 1] = "monalipse.monalipsenature";
        description.setNatureIds(newNatureIDs);
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                NewMonalipseProjectCreationWizard.this.createProject(description, newProjectHandle, monitor);
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof CoreException) {
                if (((CoreException)t).getStatus().getCode() == 275) {
                    MessageDialog.openError((Shell)this.getShell(), (String)MonalipsePlugin.getResourceString("NewProject.errorMessage"), (String)MonalipsePlugin.formatResourceString("NewProject.caseVariantExistsError", new String[]{newProjectHandle.getName()}));
                } else {
                    ErrorDialog.openError((Shell)this.getShell(), (String)MonalipsePlugin.getResourceString("NewProject.errorMessage"), null, (IStatus)((CoreException)t).getStatus());
                }
            } else {
                Platform.getPlugin((String)"org.eclipse.ui").getLog().log((IStatus)new Status(4, "org.eclipse.ui", 0, t.toString(), t));
                MessageDialog.openError((Shell)this.getShell(), (String)MonalipsePlugin.getResourceString("NewProject.errorMessage"), (String)MonalipsePlugin.formatResourceString("NewProject.internalError", new Object[]{t.getMessage()}));
            }
            return null;
        }
        this.newProject = newProjectHandle;
        return this.newProject;
    }

    private void createProject(IProjectDescription description, IProject projectHandle, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            monitor.beginTask("", 2000);
            projectHandle.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            projectHandle.open((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            monitor.done();
            throw throwable;
        }
        Object var4_6 = null;
        monitor.done();
    }

    public boolean performFinish() {
        this.createNewProject();
        if (this.newProject == null) {
            return false;
        }
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configElement);
        BasicNewResourceWizard.selectAndReveal((IResource)this.newProject, (IWorkbenchWindow)this.getWorkbench().getActiveWorkbenchWindow());
        return true;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.configElement = config;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.initializeDefaultPageImageDescriptor();
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(MonalipsePlugin.getResourceString("NewProject.windowTitle"));
    }

    protected void initializeDefaultPageImageDescriptor() {
        String iconPath = "icons/full/";
        try {
            URL installURL = Platform.getPlugin((String)"org.eclipse.ui").getDescriptor().getInstallURL();
            URL url = new URL(installURL, String.valueOf(iconPath) + "wizban/newprj_wiz.gif");
            ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
            this.setDefaultPageImageDescriptor(desc);
        }
        catch (MalformedURLException malformedURLException) {}
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public IProject getNewProject() {
        return this.newProject;
    }
}

