package monalipse.server.nullserver;

import java.net.URL;

import monalipse.server.AbstractBBSServer;
import monalipse.server.IBBSBoard;
import monalipse.server.IBBSServer;
import monalipse.server.IBoardTreeNode;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.runtime.IProgressMonitor;

public class NullServer extends AbstractBBSServer
{
	private String target;
	private static final IBoardTreeNode[] nullChildren = new IBoardTreeNode[0];
	private IBoardTreeNode nullNode = new IBoardTreeNode()
		{
			public IBBSServer getServer()
			{
				return NullServer.this;
			}
			
			public String getName()
			{
				return "";
			}

			public boolean hasChildren()
			{
				return false;
			}

			public IBoardTreeNode[] getChildren()
			{
				return nullChildren;
			}
			
			public IBoardTreeNode getParent()
			{
				return null;
			}
		};
	
	public NullServer(String target)
	{
		this.target = target;
	}

	public void createServerFolder(IProgressMonitor monitor)
	{
	}

	public String getTargetName()
	{
		return target;
	}

	public IBoardTreeNode getBoardTree()
	{
		return nullNode;
	}

	public boolean boardListChanged(IResourceChangeEvent event)
	{
		return false;
	}

	public IBBSBoard getBoardOf(URL url)
	{
		return null;
	}
	
	public void updateBoardList()
	{
	}
	
	public URL getURLOf(IFile file)
	{
		return null;
	}

}