package monalipse.server;

import java.net.URL;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public interface IBBSBoard extends IBoardTreeNode, IBBSReference
{
	public URL getURL();
	public IFolder getLogFolder();
	public void createLogFolder(IProgressMonitor monitor) throws CoreException;

	public void ensureCacheLoaded();
	public IThreadContentProvider[] getThreadList(String constraint);
	public IThreadContentProvider getThreadOf(URL url);

	public boolean threadListChanged(IResourceChangeEvent event);
	public Object[] getChangedItems(IResourceChangeEvent event);
	public void updateThreadList();
}
