package monalipse.preferences.giko;

import java.net.MalformedURLException;
import java.net.URL;

import monalipse.MonalipseMessages;
import monalipse.MonalipsePlugin;
import monalipse.server.giko.GikoServer;

import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class GikoPreferencePage extends FieldEditorPreferencePage implements IWorkbenchPreferencePage
{
	public GikoPreferencePage()
	{
		super(GRID);
		setPreferenceStore(MonalipsePlugin.getDefault().getPreferenceStore());
		setDescription("2ch Preferences");
	}

	public void createFieldEditors()
	{
		addField(new StringFieldEditor(GikoServer.PREF_BBSMENU_URL, MonalipseMessages.getString("Preference.bbsmenuLabel"), getFieldEditorParent())
			{
				public boolean isValid()
				{
					try
					{
						new URL(getStringValue());
						GikoPreferencePage.this.setErrorMessage(null);
						return true;
					}
					catch (MalformedURLException e)
					{
						GikoPreferencePage.this.setErrorMessage(MonalipseMessages.getString("Preference.invalidURL"));
						return false;
					}
				}
			});
		addField(new StringFieldEditor(GikoServer.PREF_OYSTER_ID, MonalipseMessages.getString("Preference.oysterIDLabel"), getFieldEditorParent()));
		addField(new StringFieldEditor(GikoServer.PREF_OYSTER_PASSWORD, MonalipseMessages.getString("Preference.oysterPasswordLabel"), getFieldEditorParent()));
	}

	public void init(IWorkbench workbench)
	{
	}
	
	public void propertyChange(PropertyChangeEvent event)
	{
		super.propertyChange(event);
		checkState();
	}
}