package monalipse.preferences;

import monalipse.MonalipseMessages;
import monalipse.MonalipsePlugin;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ProgramsPreferencePage extends FieldEditorPreferencePage implements IWorkbenchPreferencePage
{
	public ProgramsPreferencePage()
	{
		super(GRID);
		setPreferenceStore(MonalipsePlugin.getDefault().getPreferenceStore());
		setDescription("Programs Preferences");
	}

	public void createFieldEditors()
	{
		addField(new BooleanFieldEditor(MonalipsePlugin.PREF_SET_WEBBROWSER, MonalipseMessages.getString("Preference.webBrowserSet"), getFieldEditorParent()));
		addField(new FileFieldEditor(MonalipsePlugin.PREF_WEBBROWSER_PATH, MonalipseMessages.getString("Preference.webBrowserPath"), true, getFieldEditorParent()));
	}

	public void init(IWorkbench workbench)
	{
	}
	
	public void propertyChange(PropertyChangeEvent event)
	{
		super.propertyChange(event);
		checkState();
	}
}