package monalipse.preferences;

import monalipse.MonalipseMessages;
import monalipse.MonalipsePlugin;
import monalipse.server.BBSServerManager;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class NetworkPreferencePage extends FieldEditorPreferencePage implements IWorkbenchPreferencePage
{
	public NetworkPreferencePage()
	{
		super(GRID);
		setPreferenceStore(MonalipsePlugin.getDefault().getPreferenceStore());
		setDescription("Network Preferences");
	}

	public void createFieldEditors()
	{
		addField(new BooleanFieldEditor(BBSServerManager.PREF_PROXY_USE, MonalipseMessages.getString("Preference.proxyUse"), getFieldEditorParent()));
		addField(new StringFieldEditor(BBSServerManager.PREF_PROXY_HOST, MonalipseMessages.getString("Preference.proxyHost"), getFieldEditorParent()));
		addField(new IntegerFieldEditor(BBSServerManager.PREF_PROXY_PORT, MonalipseMessages.getString("Preference.proxyPort"), getFieldEditorParent()));
	}

	public void init(IWorkbench workbench)
	{
	}
	
	public void propertyChange(PropertyChangeEvent event)
	{
		super.propertyChange(event);
		checkState();
	}
}