/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.protocol.Protocol;

public class SimpleHttpConnectionManager
implements HttpConnectionManager {
    private HttpConnection httpConnection;

    public HttpConnection getConnection(HostConfiguration hostConfiguration) throws MalformedURLException {
        return this.getConnection(hostConfiguration, 0L);
    }

    public HttpConnection getConnection(HostConfiguration hostConfiguration, long timeout) throws MalformedURLException {
        Protocol protocol = hostConfiguration.getProtocol();
        String host = hostConfiguration.getHost();
        int port = hostConfiguration.getPort();
        if (this.httpConnection == null) {
            this.httpConnection = hostConfiguration.isProxySet() ? new HttpConnection(hostConfiguration.getProxyHost(), hostConfiguration.getProxyPort(), host, port, protocol) : new HttpConnection(host, port, protocol);
        } else if (!hostConfiguration.hostEquals(this.httpConnection) || !hostConfiguration.proxyEquals(this.httpConnection)) {
            if (this.httpConnection.isOpen()) {
                this.httpConnection.close();
            }
            this.httpConnection.setHost(host);
            this.httpConnection.setPort(port);
            this.httpConnection.setProtocol(protocol);
            this.httpConnection.setProxyHost(hostConfiguration.getProxyHost());
            this.httpConnection.setProxyPort(hostConfiguration.getProxyPort());
        } else {
            SimpleHttpConnectionManager.finishLastResponse(this.httpConnection);
        }
        return this.httpConnection;
    }

    public void releaseConnection(HttpConnection conn) {
        if (conn != this.httpConnection) {
            throw new IllegalStateException("Unexpected close on a different connection.");
        }
        SimpleHttpConnectionManager.finishLastResponse(this.httpConnection);
    }

    static void finishLastResponse(HttpConnection conn) {
        InputStream lastResponse = conn.getLastResponseInputStream();
        if (lastResponse != null) {
            conn.setLastResponseInputStream(null);
            try {
                lastResponse.close();
            }
            catch (IOException ioe) {
                conn.close();
            }
        }
    }
}

