/*
 * Decompiled with CFR 0.152.
 */
package monalipse.views;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.StringTokenizer;
import monalipse.MonalipseMessages;
import monalipse.MonalipsePlugin;
import monalipse.editors.ThreadViewerEditor;
import monalipse.server.IThreadContentProvider;
import monalipse.utils.CancelableRunner;
import monalipse.views.ComboTextOperationTarget;
import monalipse.views.ResponseWriterView;
import monalipse.views.ViewUtils;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.DefaultUndoManager;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.part.ViewPart;

public class ResponseWriterView
extends ViewPart
implements IPropertyListener,
IPartListener,
IPropertyChangeListener {
    public static final String ID_RESPONSE_WRITER;
    private TextViewer viewer;
    private Combo nameCombo;
    private Combo mailCombo;
    private Font font;
    private IUndoManager undoManager;
    private CancelableRunner cancelable;
    private IAction abortAction;
    private IAction submitAction;
    private IAction undoAction;
    private IAction redoAction;
    private IAction cutAction;
    private IAction copyAction;
    private IAction pasteAction;
    private IAction deleteAction;
    private IAction selectAllAction;
    private ThreadViewerEditor editor;
    private FocusListener focusListener;
    private ThreadViewerEditor inputQueue;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("monalipse.views.ResponseWriterView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ID_RESPONSE_WRITER = clazz.getName();
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TextViewer(parent, 770);
        this.makeActions();
        this.contributeToActionBars();
        try {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)MonalipsePlugin.getDefault().getPreferenceStore(), (String)ThreadViewerEditor.PREF_NORMAL_FONT);
            this.font = new Font((Device)this.viewer.getTextWidget().getDisplay(), fontData);
            this.viewer.getTextWidget().setFont(this.font);
        }
        catch (RuntimeException runtimeException) {}
        this.viewer.setInput(new Object());
        this.viewer.setDocument((IDocument)new Document());
        this.undoManager = new DefaultUndoManager(1024);
        this.viewer.setUndoManager(this.undoManager);
        this.undoManager.connect((ITextViewer)this.viewer);
        this.initializeTextActions();
        this.updateSelectionDependentActions();
        this.updateUndoAction();
        this.viewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                ResponseWriterView.this.updateUndoAction();
                ResponseWriterView.this.updateSubmitAction();
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ResponseWriterView.this.updateSelectionDependentActions();
            }
        });
        this.focusListener = new FocusListener(){

            public void focusGained(FocusEvent e) {
                ResponseWriterView.this.updateUndoAction();
                ResponseWriterView.this.updateSelectionDependentActions();
            }

            public void focusLost(FocusEvent e) {
            }
        };
        this.viewer.getControl().addFocusListener(this.focusListener);
        this.getSite().getWorkbenchWindow().getPartService().addPartListener((IPartListener)this);
        MonalipsePlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(ThreadViewerEditor.PREF_NORMAL_FONT)) {
            this.font.dispose();
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)MonalipsePlugin.getDefault().getPreferenceStore(), (String)ThreadViewerEditor.PREF_NORMAL_FONT);
            this.font = new Font((Device)this.viewer.getTextWidget().getDisplay(), fontData);
            this.viewer.getTextWidget().setFont(this.font);
        }
    }

    public void partActivated(IWorkbenchPart part) {
        this.update(part);
    }

    public void partBroughtToTop(IWorkbenchPart part) {
        this.update(part);
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
        this.update(part);
    }

    private void update(final IWorkbenchPart part) {
        if (part instanceof ThreadViewerEditor && ((ThreadViewerEditor)part).getContentProvider() instanceof IThreadContentProvider) {
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    ResponseWriterView.this.selectionChanged((ThreadViewerEditor)part);
                }
            });
        }
    }

    private void selectionChanged(ThreadViewerEditor th) {
        if (this.inputQueue == null && this.editor == th) {
            return;
        }
        if (this.inputQueue != null && this.inputQueue == th) {
            return;
        }
        this.inputQueue = th;
        new Thread(new Runnable(){

            public void run() {
                ResponseWriterView.this.getSite().getShell().getDisplay().syncExec(new Runnable(this){
                    final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                    }
                });
                ThreadViewerEditor th = ResponseWriterView.this.inputQueue;
                if (th != null) {
                    th.getCancelable().runAndJoin(th, new CancelableRunner.ICancelableRunnableWithProgress(this){
                        final /* synthetic */ 5 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run(CancelableRunner.ICancelableProgressMonitor monitor) {
                        }
                    });
                    th.getCancelable().runAndJoin(th, new CancelableRunner.ICancelableRunnableWithProgress(this){
                        final /* synthetic */ 5 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run(CancelableRunner.ICancelableProgressMonitor monitor) {
                        }
                    });
                    ResponseWriterView.this.getSite().getShell().getDisplay().asyncExec(new Runnable(this){
                        final /* synthetic */ 5 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            if (ResponseWriterView.access$1(5.access$0(this.this$1)) != null) {
                                ResponseWriterView.access$2(5.access$0(this.this$1), ResponseWriterView.access$1(5.access$0(this.this$1)));
                            }
                        }
                    });
                }
            }

            static /* synthetic */ ResponseWriterView access$0(5 var0) {
                return var0.ResponseWriterView.this;
            }
        }).start();
    }

    private void setInput(ThreadViewerEditor part) {
        if (this.editor != null) {
            this.editor.removePropertyListener(this);
            this.saveState((IResource)this.editor.getContentProvider().getLogFile());
        }
        this.editor = part;
        this.editor.addPropertyListener(this);
        this.restoreState((IResource)this.editor.getContentProvider().getLogFile());
        this.updateTitle();
        this.updateUndoAction();
        this.updateSubmitAction();
    }

    private void saveState(IResource res) {
        this.saveCombo(this.nameCombo, "name", res);
        this.saveCombo(this.mailCombo, "mail", res);
        if (this.viewer != null && this.viewer.getTextWidget() != null && !this.viewer.getTextWidget().isDisposed()) {
            try {
                res.setPersistentProperty(new QualifiedName(((Object)((Object)this)).getClass().getName(), "body"), this.viewer.getTextWidget().getText());
                res.setPersistentProperty(new QualifiedName(((Object)((Object)this)).getClass().getName(), "body.caretOffset"), String.valueOf(this.viewer.getTextWidget().getCaretOffset()));
                res.setPersistentProperty(new QualifiedName(((Object)((Object)this)).getClass().getName(), "body.topIndex"), String.valueOf(this.viewer.getTextWidget().getTopIndex()));
            }
            catch (CoreException coreException) {}
        }
    }

    private void saveCombo(Combo combo, String key, IResource res) {
        if (combo != null && !combo.isDisposed()) {
            try {
                StringBuffer buf = new StringBuffer();
                String[] keys = combo.getItems();
                int i = 0;
                while (i < keys.length && i < 10) {
                    buf.append(URLEncoder.encode(keys[i], "UTF-8")).append(" ");
                    ++i;
                }
                res.setPersistentProperty(new QualifiedName(((Object)((Object)this)).getClass().getName(), key), buf.toString());
                res.setPersistentProperty(new QualifiedName(((Object)((Object)this)).getClass().getName(), String.valueOf(key) + ".selected"), combo.getText());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
            }
            catch (CoreException coreException) {}
        }
    }

    private void restoreState(IResource res) {
        this.restoreCombo(this.nameCombo, "name", res);
        this.restoreCombo(this.mailCombo, "mail", res);
        if (this.viewer != null && this.viewer.getTextWidget() != null && !this.viewer.getTextWidget().isDisposed()) {
            try {
                this.viewer.getTextWidget().setText("");
                String body = res.getPersistentProperty(new QualifiedName(((Object)((Object)this)).getClass().getName(), "body"));
                if (body == null) {
                    body = "";
                }
                this.viewer.getTextWidget().setText(body);
                try {
                    String topIndex;
                    String caretOffset = res.getPersistentProperty(new QualifiedName(((Object)((Object)this)).getClass().getName(), "body.caretOffset"));
                    if (caretOffset != null) {
                        this.viewer.getTextWidget().setCaretOffset(Integer.parseInt(caretOffset));
                    }
                    if ((topIndex = res.getPersistentProperty(new QualifiedName(((Object)((Object)this)).getClass().getName(), "body.topIndex"))) != null) {
                        this.viewer.getTextWidget().setTopIndex(Integer.parseInt(topIndex));
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            catch (CoreException coreException) {}
        }
    }

    private void restoreCombo(Combo combo, String key, IResource res) {
        if (combo != null && !combo.isDisposed()) {
            try {
                String text;
                combo.removeAll();
                combo.add("");
                String keys = res.getPersistentProperty(new QualifiedName(((Object)((Object)this)).getClass().getName(), key));
                if (keys != null) {
                    StringTokenizer tk = new StringTokenizer(keys);
                    while (tk.hasMoreTokens()) {
                        combo.add(URLDecoder.decode(tk.nextToken(), "UTF-8"));
                    }
                }
                if ((text = res.getPersistentProperty(new QualifiedName(((Object)((Object)this)).getClass().getName(), String.valueOf(key) + ".selected"))) != null) {
                    combo.setText(text);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
            }
            catch (CoreException coreException) {}
        }
    }

    public void propertyChanged(Object source, int propId) {
        if (propId == 1) {
            this.updateTitle();
        }
    }

    private void updateTitle() {
        this.setTitle("Response - " + this.editor.getTitle());
    }

    private IAction createAction(String id, final int action, String image) {
        Action act = new Action(MonalipseMessages.getString("Workbench." + id)){

            public void run() {
                ResponseWriterView.this.getTextOperationTarget().doOperation(action);
            }
        };
        if (image != null) {
            act.setImageDescriptor(WorkbenchImages.getImageDescriptor((String)image));
            act.setDisabledImageDescriptor(WorkbenchImages.getImageDescriptor((String)(String.valueOf(image) + "_DISABLED")));
            act.setHoverImageDescriptor(WorkbenchImages.getImageDescriptor((String)(String.valueOf(image) + "_HOVER")));
        }
        this.getViewSite().getActionBars().setGlobalActionHandler(id, (IAction)act);
        return act;
    }

    private void initializeTextActions() {
        this.undoAction = this.createAction("undo", 1, "IMG_CTOOL_UNDO_EDIT");
        this.redoAction = this.createAction("redo", 2, "IMG_CTOOL_REDO_EDIT");
        this.cutAction = this.createAction("cut", 3, "IMG_CTOOL_CUT_EDIT");
        this.copyAction = this.createAction("copy", 4, "IMG_CTOOL_COPY_EDIT");
        this.pasteAction = this.createAction("paste", 5, "IMG_CTOOL_PASTE_EDIT");
        this.deleteAction = this.createAction("delete", 6, "IMG_CTOOL_DELETE_EDIT");
        this.selectAllAction = this.createAction("selectAll", 7, null);
        MenuManager manager = new MenuManager(null, null);
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ResponseWriterView.this.fillContextMenu(mgr);
            }
        });
        StyledText text = this.viewer.getTextWidget();
        Menu menu = manager.createContextMenu((Control)text);
        text.setMenu(menu);
    }

    public void dispose() {
        MonalipsePlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        this.getSite().getWorkbenchWindow().getPartService().removePartListener((IPartListener)this);
        if (this.font != null) {
            this.font.dispose();
        }
        this.font = null;
    }

    private void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new GroupMarker("group.undo"));
        menu.appendToGroup("group.undo", this.undoAction);
        menu.appendToGroup("group.undo", this.redoAction);
        menu.add((IContributionItem)new Separator("group.edit"));
        menu.appendToGroup("group.edit", this.cutAction);
        menu.appendToGroup("group.edit", this.copyAction);
        menu.appendToGroup("group.edit", this.pasteAction);
        menu.add((IContributionItem)new Separator("group.managing"));
        menu.appendToGroup("group.managing", this.deleteAction);
        menu.appendToGroup("group.managing", this.selectAllAction);
    }

    private ITextOperationTarget getTextOperationTarget() {
        ITextOperationTarget target = this.nameCombo != null && this.nameCombo.isFocusControl() ? new ComboTextOperationTarget(this.nameCombo) : (this.mailCombo != null && this.mailCombo.isFocusControl() ? new ComboTextOperationTarget(this.mailCombo) : this.viewer.getTextOperationTarget());
        return target;
    }

    protected void updateSelectionDependentActions() {
        ITextOperationTarget target = this.getTextOperationTarget();
        this.cutAction.setEnabled(target.canDoOperation(3));
        this.copyAction.setEnabled(target.canDoOperation(4));
        this.pasteAction.setEnabled(target.canDoOperation(5));
        this.deleteAction.setEnabled(target.canDoOperation(6));
        this.selectAllAction.setEnabled(target.canDoOperation(7));
    }

    protected void updateUndoAction() {
        ITextOperationTarget target = this.getTextOperationTarget();
        this.undoAction.setEnabled(target.canDoOperation(1));
        this.redoAction.setEnabled(target.canDoOperation(2));
    }

    protected void updateSubmitAction() {
        this.submitAction.setEnabled(this.viewer != null && this.viewer.getDocument() != null && this.viewer.getDocument().getLength() != 0 && this.editor != null && this.editor.isWritable());
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
        this.fillLocalStatusBar(bars.getStatusLineManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add(this.abortAction);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IContributionItem)new ControlContribution(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".name"){

            protected Control createControl(Composite parent) {
                ViewUtils.ComboInfo info = ViewUtils.createCombo(parent, 2052);
                ResponseWriterView.this.nameCombo = info.combo;
                ResponseWriterView.this.nameCombo.setToolTipText("name");
                ResponseWriterView.this.nameCombo.addFocusListener(ResponseWriterView.this.focusListener);
                return info.control;
            }
        });
        manager.add((IContributionItem)new ControlContribution(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".mail"){

            protected Control createControl(Composite parent) {
                ViewUtils.ComboInfo info = ViewUtils.createCombo(parent, 2052);
                ResponseWriterView.this.mailCombo = info.combo;
                ResponseWriterView.this.mailCombo.setToolTipText("mail");
                ResponseWriterView.this.mailCombo.addFocusListener(ResponseWriterView.this.focusListener);
                return info.control;
            }
        });
        manager.add(this.submitAction);
        manager.add(this.abortAction);
    }

    private void fillLocalStatusBar(IStatusLineManager manager) {
        this.cancelable = new CancelableRunner(manager, this.getSite().getShell().getDisplay(), this.abortAction);
    }

    private void makeActions() {
        String iconPath = "icons/";
        URL installURL = Platform.getPlugin((String)"monalipse").getDescriptor().getInstallURL();
        this.abortAction = new Action(){

            public void run() {
                ResponseWriterView.this.cancelable.cancel();
            }
        };
        this.abortAction.setText("Abort");
        this.abortAction.setToolTipText("Abort downloading board list");
        this.abortAction.setEnabled(false);
        try {
            this.abortAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)new URL(installURL, String.valueOf(iconPath) + "stop_nav.gif")));
        }
        catch (MalformedURLException malformedURLException) {}
        this.submitAction = new Action(){

            public void run() {
                String name = ResponseWriterView.this.nameCombo.getText();
                String mail = ResponseWriterView.this.mailCombo.getText();
                String body = ResponseWriterView.this.viewer.getTextWidget().getText();
                ResponseWriterView.this.cancelable.run(ResponseWriterView.this.cancelable, new CancelableRunner.ICancelableRunnableWithProgress(this, name, mail, body){
                    final /* synthetic */ 15 this$1;
                    private final /* synthetic */ String val$name;
                    private final /* synthetic */ String val$mail;
                    private final /* synthetic */ String val$body;
                    {
                        this.this$1 = var1_1;
                        this.val$name = string;
                        this.val$mail = string2;
                        this.val$body = string3;
                    }

                    public void run(CancelableRunner.ICancelableProgressMonitor monitor) {
                        IThreadContentProvider thread = ResponseWriterView.access$12(15.access$1(this.this$1)).getContentProvider();
                        monitor.beginTask("submitting", 100);
                        monitor.worked(50);
                        if (thread.submitResponse(monitor, this.val$name, this.val$mail, this.val$body)) {
                            15.access$1(this.this$1).getSite().getShell().getDisplay().asyncExec(new Runnable(this){
                                final /* synthetic */ 16 this$2;
                                {
                                    this.this$2 = var1_1;
                                }

                                public void run() {
                                    15.access$0(16.access$0(this.this$2), ResponseWriterView.access$6(15.access$1(16.access$0(this.this$2))));
                                    15.access$0(16.access$0(this.this$2), ResponseWriterView.access$9(15.access$1(16.access$0(this.this$2))));
                                    ResponseWriterView.access$13(15.access$1(16.access$0(this.this$2))).reset();
                                    ResponseWriterView.access$11(15.access$1(16.access$0(this.this$2))).getTextWidget().setText("");
                                    ResponseWriterView.access$14(15.access$1(16.access$0(this.this$2)), (IResource)ResponseWriterView.access$12(15.access$1(16.access$0(this.this$2))).getContentProvider().getLogFile());
                                    ResponseWriterView.access$12(15.access$1(16.access$0(this.this$2))).updateThread(-1);
                                }
                            });
                        }
                        monitor.done();
                    }

                    static /* synthetic */ 15 access$0(16 var0) {
                        return var0.this$1;
                    }
                });
            }

            private void updateCombo(Combo combo) {
                String text = combo.getText();
                if (text.length() > 0) {
                    if (Arrays.asList(combo.getItems()).contains(text)) {
                        combo.remove(text);
                    }
                    combo.add(text, 1);
                }
                combo.setText(text);
            }

            static /* synthetic */ void access$0(15 var0, Combo combo) {
                var0.updateCombo(combo);
            }

            static /* synthetic */ ResponseWriterView access$1(15 var0) {
                return var0.ResponseWriterView.this;
            }
        };
        this.submitAction.setText("Submit");
        this.submitAction.setToolTipText("Submit");
        this.submitAction.setEnabled(false);
        try {
            this.submitAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)new URL(installURL, String.valueOf(iconPath) + "write_obj.gif")));
        }
        catch (MalformedURLException malformedURLException) {}
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    static /* synthetic */ void access$2(ResponseWriterView responseWriterView, ThreadViewerEditor threadViewerEditor) {
        responseWriterView.setInput(threadViewerEditor);
    }

    static /* synthetic */ ThreadViewerEditor access$12(ResponseWriterView responseWriterView) {
        return responseWriterView.editor;
    }

    static /* synthetic */ IUndoManager access$13(ResponseWriterView responseWriterView) {
        return responseWriterView.undoManager;
    }

    static /* synthetic */ void access$14(ResponseWriterView responseWriterView, IResource iResource) {
        responseWriterView.saveState(iResource);
    }
}

