package monalipse.server;

import java.net.URL;

import monalipse.views.IBBSReference;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IWorkbenchWindow;

public interface IBBSBoard extends IBoardTreeNode, IBBSReference
{
	public URL getURL();
	public IFolder getLogFolder();
	public void createLogFolder(IWorkbenchWindow workbenchWindow, IProgressMonitor monitor);

	public IThreadContentProvider[] getThreadList(String constraint);
	public IThreadContentProvider getThreadOf(URL url);

	public boolean threadListChanged(IResourceChangeEvent event);
	public Object[] getChangedItems(IResourceChangeEvent event);
	public void updateThreadList(IWorkbenchWindow workbenchWindow);
}
