/*
 * Decompiled with CFR 0.152.
 */
package monalipse.widgets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;

public class ColoredText
extends Canvas
implements ITextOperationTarget,
ISelectionProvider {
    private List lines = new ArrayList();
    private VisualLines visualLines = new VisualLines();
    private GC gc;
    private Attributes attributes;
    private Color selectionDark;
    private Color selectionLight;
    private Cursor handCursor;
    private Cursor ibeamCursor;
    private int width = Integer.MAX_VALUE;
    private int[] insets = new int[]{10, 10, 10, 10};
    private TextPosition selectionStart = TextPosition.INVALID;
    private TextPosition selectionEnd = TextPosition.INVALID;
    private List textTrackListeners = new ArrayList();
    private ToolTipProvider toolTipProvider;
    private Shell toolTipShell;
    private boolean toolTipLocked;
    private ColoredText toolTipSource = this;
    private List selectionChangedListeners = new ArrayList();
    private LinkProvider linkProvider;

    public ColoredText(Composite parent, int style) {
        super(parent, style | 0x40000 | 0x10000);
        this.selectionDark = new Color(null, 0, 0, 0);
        this.selectionLight = new Color(null, 143, 153, 166);
        this.handCursor = new Cursor((Device)parent.getDisplay(), 21);
        this.ibeamCursor = new Cursor((Device)parent.getDisplay(), 19);
        this.attributes = new Attributes((Device)parent.getDisplay());
        this.gc = new GC((Drawable)this);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                ColoredText.this.paintControl(e);
            }
        });
        this.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                ColoredText.this.controlResized(e);
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ColoredText.this.widgetDisposed(e);
            }
        });
        this.addKeyListener(new PageMoveKeyListener());
        MouseDragListener dsl = new MouseDragListener();
        this.addMouseListener(dsl);
        this.addMouseMoveListener(dsl);
        this.addMouseTrackListener(dsl);
        this.addTextTrackListener(new TextTrackListener(){

            public void textEnter(TextEvent e) {
                if (e.fragment instanceof LinkTarget) {
                    ColoredText.this.setCursor(ColoredText.this.handCursor);
                } else {
                    ColoredText.this.setCursor(ColoredText.this.ibeamCursor);
                }
            }

            public void textExit(TextEvent e) {
                ColoredText.this.setCursor(null);
                this.exit();
            }

            public void textHover(TextEvent e) {
                if (ColoredText.this.toolTipProvider != null && e.fragment instanceof ToolTipTarget) {
                    ColoredText.this.showHover(e.x, e.y, (ToolTipTarget)((Object)e.fragment), null);
                }
            }

            public void textSelectionEnter(TextEvent e) {
            }

            public void textSelectionExit(TextEvent e) {
                this.exit();
            }

            public void textSelectionHover(TextEvent e) {
                TextSelection sel = e.text.getTextSelection();
                if (ColoredText.this.toolTipProvider != null && !sel.isEmpty()) {
                    ColoredText.this.showHover(e.x, e.y, null, e.text.getText(sel.from, sel.to, true));
                }
            }

            private void exit() {
                if (!ColoredText.this.toolTipLocked) {
                    ColoredText.this.setCapture(false);
                    ColoredText.this.disposeToolTip();
                }
            }
        });
        this.getVerticalBar().setMinimum(0);
        this.getVerticalBar().setMaximum(0);
        this.getVerticalBar().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ColoredText.this.redraw();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private synchronized void showHover(int x, int y, ToolTipTarget fragment, String selection) {
        this.disposeToolTip();
        Point pt = this.toDisplay(new Point(x, y));
        Rectangle scr = this.getShell().getDisplay().getClientArea();
        int cursorSize = 16;
        scr.x += cursorSize;
        scr.y += cursorSize;
        scr.width -= cursorSize * 2;
        scr.height -= cursorSize * 2;
        int maxWidth = Math.max(pt.x - scr.x, scr.x + scr.width - pt.x) - 2;
        this.toolTipShell = new Shell(this.getShell(), 0);
        Composite content = new Composite((Composite)this.toolTipShell, 0);
        content.setLayout((Layout)new FillLayout(768));
        Point size = fragment != null ? this.toolTipProvider.fillToolTip(content, this.toolTipSource, maxWidth, fragment) : this.toolTipProvider.fillToolTip(content, this.toolTipSource, maxWidth, selection);
        size.x += 2;
        size.y += 2;
        pt.x = scr.x + scr.width < pt.x + size.x ? (pt.x -= size.x + cursorSize) : (pt.x += cursorSize);
        if (scr.y + scr.height < pt.y + size.y) {
            if (scr.height / 2 < pt.y - scr.y) {
                size.y = Math.min(size.y, pt.y - scr.y);
                pt.y -= size.y + cursorSize;
            } else {
                size.y = scr.y + scr.height - pt.y;
                pt.y += cursorSize;
            }
        } else {
            pt.y += cursorSize;
        }
        content.setSize(size.x - 2, size.y - 2);
        content.setLocation(0, 0);
        this.toolTipShell.setLocation(pt);
        this.toolTipShell.setSize(size.x, size.y);
        this.toolTipShell.setVisible(true);
        this.setCapture(true);
        this.toolTipProvider.toolTipActivated(this);
    }

    public void disposeToolTip() {
        this.toolTipLocked = false;
        if (this.toolTipShell != null) {
            this.toolTipProvider.toolTipDeactivated(this);
            if (!this.toolTipShell.isDisposed()) {
                this.toolTipShell.setVisible(false);
                this.toolTipShell.dispose();
            }
            this.toolTipShell = null;
        }
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public void widgetDisposed(DisposeEvent e) {
        this.disposeToolTip();
        if (this.gc != null) {
            try {
                this.gc.dispose();
            }
            catch (SWTException sWTException) {}
        }
        this.gc = null;
        if (this.attributes != null) {
            this.attributes.dispose();
        }
        this.attributes = null;
        if (this.selectionDark != null) {
            this.selectionDark.dispose();
        }
        this.selectionDark = null;
        if (this.selectionLight != null) {
            this.selectionLight.dispose();
        }
        this.selectionLight = null;
        if (this.handCursor != null) {
            this.handCursor.dispose();
        }
        this.handCursor = null;
        if (this.ibeamCursor != null) {
            this.ibeamCursor.dispose();
        }
        this.ibeamCursor = null;
    }

    public void lockToolTip() {
        if (!this.toolTipLocked && this.toolTipShell != null) {
            this.toolTipLocked = true;
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int width = 0;
        int i = 0;
        while (i < this.getLineCount()) {
            width = Math.max(width, this.getLineAt(i).getPreferredLineWidth(this.gc, this.attributes));
            ++i;
        }
        if (width == 0) {
            return super.computeSize(wHint, hHint);
        }
        return new Point(width + this.insets[1] + this.insets[3] + this.getVerticalBar().getSize().x, this.attributes.lineSkip * this.getLineCount() + this.insets[0] + this.insets[2] + 1);
    }

    private void controlResized(ControlEvent e) {
        this.wrapLines(this.getClientArea().width - this.insets[1] - this.insets[3]);
        ScrollBar vertical = this.getVerticalBar();
        int height = this.getClientArea().height;
        vertical.setIncrement(this.attributes.lineSkip);
        vertical.setPageIncrement(height * 9 / 10);
        this.updateScrollThumb();
    }

    private void paintControl(PaintEvent e) {
        int clientHeight;
        GC gc = e.gc;
        int pos = this.getVerticalBar().getSelection();
        int originX = this.insets[1];
        int originY = this.insets[0] - pos;
        int startLine = Math.max(0, (e.y - originY) / this.attributes.lineSkip);
        int endLine = Math.min(this.visualLines.getLineCount(), (e.y + e.height - originY) / this.attributes.lineSkip + 1);
        int lineWidth = this.width + this.insets[1] + this.insets[3];
        gc.setBackground(this.getBackground());
        if (originY > 0) {
            gc.fillRectangle(0, 0, lineWidth, originY);
        }
        int i = startLine;
        while (i < endLine) {
            int logicalLine = this.visualLines.getLogicalLineAt(i);
            Line line = this.getLineAt(logicalLine);
            if (this.selectionStart.row <= logicalLine && logicalLine <= this.selectionEnd.row) {
                int selStart = this.selectionStart.row < logicalLine ? 0 : this.selectionStart.column;
                int selEnd = logicalLine < this.selectionEnd.row ? line.getTextLength() : this.selectionEnd.column;
                line.paintSelected(gc, this.attributes, originX, originY + this.attributes.lineSkip * i, this.visualLines.getOffsetAt(i), this.visualLines.getLengthAt(i), lineWidth, this.attributes.lineSkip, selStart, selEnd - selStart, this.selectionDark, this.selectionLight);
            } else {
                line.paint(gc, this.attributes, originX, originY + this.attributes.lineSkip * i, this.visualLines.getOffsetAt(i), this.visualLines.getLengthAt(i), lineWidth, this.attributes.lineSkip);
            }
            ++i;
        }
        int bottom = originY + this.attributes.lineSkip * this.visualLines.getLineCount();
        if (bottom < (clientHeight = this.getClientArea().height)) {
            gc.setBackground(this.getBackground());
            gc.fillRectangle(0, bottom, lineWidth, clientHeight - bottom);
        }
    }

    public void setInsets(int top, int left, int bottom, int right) {
        this.insets[0] = top;
        this.insets[1] = left;
        this.insets[2] = bottom;
        this.insets[3] = right;
    }

    public void addLine(Line line) {
        Point bottom = this.getPointFromVisualLine(this.visualLines.getLineCount(), 0);
        line.wrapLine(this.visualLines, this.width, this.lines.size(), this.gc, this.attributes);
        this.lines.add(line);
        this.recalcScrollMaximum();
        int h = this.getClientArea().height;
        if (bottom.y < h) {
            this.redraw(this.insets[1], bottom.y, this.width, h - bottom.y, true);
        }
    }

    public void addLines(Collection colection) {
        Point bottom = this.getPointFromVisualLine(this.visualLines.getLineCount(), 0);
        Iterator i = colection.iterator();
        while (i.hasNext()) {
            Line line = (Line)i.next();
            if (this.width == Integer.MAX_VALUE) {
                this.visualLines.addLine(this.lines.size(), 0, line.getTextLength());
            } else {
                line.wrapLine(this.visualLines, this.width, this.lines.size(), this.gc, this.attributes);
            }
            this.lines.add(line);
        }
        this.recalcScrollMaximum();
        int h = this.getClientArea().height;
        if (bottom.y < h) {
            this.redraw(this.insets[1], bottom.y, this.width, h - bottom.y, true);
        }
    }

    public int getLineCount() {
        return this.lines.size();
    }

    public Line getLineAt(int index) {
        return (Line)this.lines.get(index);
    }

    public void clear() {
        this.lines.clear();
        this.visualLines.clear();
        this.getVerticalBar().setMaximum(this.insets[0] + this.insets[2]);
        this.setSelection(TextPosition.INVALID, TextPosition.INVALID, false);
        this.redraw();
    }

    public boolean canDoOperation(int operation) {
        if (operation == 4) {
            return !this.getSelection().isEmpty();
        }
        return operation == 7;
    }

    public void doOperation(int operation) {
        if (operation == 4) {
            this.copyToClipboard();
        } else if (operation == 7) {
            this.selectAll();
        }
    }

    public void copyToClipboard() {
        if (this.selectionStart.isValid() && this.selectionEnd.isValid()) {
            new Clipboard(this.getDisplay()).setContents(new Object[]{this.getText(this.selectionStart, this.selectionEnd, true)}, new Transfer[]{TextTransfer.getInstance()});
        }
    }

    public String getText(TextPosition from, TextPosition to, boolean lf) {
        if (!from.isValid() || !to.isValid()) {
            return "";
        }
        if (from.row == to.row) {
            return this.getLineAt(from.row).getText().substring(from.column, to.column);
        }
        StringBuffer buf = new StringBuffer();
        String f = this.getLineAt(from.row).getText();
        buf.append(f.substring(from.column, f.length()));
        if (lf) {
            buf.append('\n');
        }
        int i = from.row + 1;
        while (i < to.row) {
            buf.append(this.getLineAt(i).getText());
            if (lf) {
                buf.append('\n');
            }
            ++i;
        }
        buf.append(this.getLineAt(to.row).getText().substring(0, to.column));
        return buf.toString();
    }

    public TextPosition findAndSelect(TextPosition off, String findString, boolean searchForward, boolean caseSensitive, boolean wholeWord) {
        String text;
        if (!caseSensitive) {
            findString = findString.toLowerCase();
        }
        int pos = 0;
        if (searchForward) {
            text = this.getText(off, new TextPosition(this.getLineCount() - 1, this.getLineAt(this.getLineCount() - 1).getTextLength()), false);
            if (!caseSensitive) {
                text = text.toLowerCase();
            }
            if ((pos = text.indexOf(findString)) == -1) {
                return TextPosition.INVALID;
            }
            pos += this.textPositionToIntPosition(off);
        } else {
            text = this.getText(new TextPosition(0, 0), off, false);
            if (!caseSensitive) {
                text = text.toLowerCase();
            }
            if ((pos = text.lastIndexOf(findString)) == -1) {
                return TextPosition.INVALID;
            }
        }
        TextPosition start = this.intPositionToTextPosition(pos);
        TextPosition end = this.intPositionToTextPosition(pos + findString.length());
        this.setSelection(start, end, false);
        this.ensureVisible(start, end);
        return start;
    }

    public TextPosition intPositionToTextPosition(int pos) {
        if (pos < 0) {
            return TextPosition.INVALID;
        }
        int i = 0;
        while (i < this.getLineCount()) {
            int len = this.getLineAt(i).getTextLength();
            if (pos < len) {
                return new TextPosition(i, pos);
            }
            pos -= len;
            ++i;
        }
        return TextPosition.INVALID;
    }

    public int textPositionToIntPosition(TextPosition pos) {
        if (!pos.isValid()) {
            return -1;
        }
        int p = pos.column;
        int i = 0;
        while (i < pos.row) {
            p += this.getLineAt(i).getTextLength();
            ++i;
        }
        return p;
    }

    public void selectAll() {
        this.setSelection(new TextPosition(0, 0), new TextPosition(this.getLineCount() - 1, this.getLineAt(this.getLineCount() - 1).getTextLength()), true);
        this.redraw();
    }

    public void setSelection(ISelection selection) {
        if (selection instanceof TextSelection) {
            TextSelection sel = (TextSelection)selection;
            this.setSelection(sel.from, sel.to, true);
            this.redraw();
        }
    }

    public ISelection getSelection() {
        return this.getTextSelection();
    }

    public TextSelection getTextSelection() {
        return new TextSelection(this.selectionStart, this.selectionEnd);
    }

    public void setSelection(TextPosition selectionStart, TextPosition selectionEnd, boolean redraw) {
        if (selectionStart.compareTo(selectionEnd) > 0) {
            TextPosition t = selectionStart;
            selectionStart = selectionEnd;
            selectionEnd = t;
        }
        if (this.selectionStart.equals(selectionStart) && this.selectionEnd.equals(selectionEnd)) {
            redraw = false;
        }
        if (redraw) {
            this.redrawSelection();
        }
        this.selectionStart = selectionStart;
        this.selectionEnd = selectionEnd;
        if (redraw) {
            this.redrawSelection();
        }
        this.fireSelectionChangedEvent(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
    }

    public void setSelection(LineFragment fragment, boolean redraw) {
        int i = 0;
        while (i < this.getLineCount()) {
            Line line = this.getLineAt(i);
            int col = 0;
            int j = 0;
            while (j < line.getLineFragmentCount()) {
                LineFragment f = line.getLineFragmentAt(j);
                if (f == fragment) {
                    this.setSelection(new TextPosition(i, col), new TextPosition(i, col + f.getTextLength()), redraw);
                    return;
                }
                col += f.getTextLength();
                ++j;
            }
            ++i;
        }
    }

    private void redrawSelection() {
        if (this.selectionStart.isValid()) {
            Point top = this.getPointFromIndex(this.selectionStart);
            Point bottom = this.getPointFromIndex(this.selectionEnd);
            this.redraw(this.insets[1], top.y, this.width, bottom.y - top.y + this.attributes.lineSkip, true);
        }
    }

    private void setScrollSelection(int value) {
        ScrollBar vert = this.getVerticalBar();
        vert.setSelection(Math.max(Math.min(value, vert.getMaximum()), vert.getMinimum()));
    }

    private void ensureVisible(TextPosition start, TextPosition end) {
        int s = this.findVisualLineOf(start);
        int e = this.findVisualLineOf(end);
        int h = this.getVerticalBar().getThumb() / this.attributes.lineSkip;
        if (h < e - s) {
            this.setScrollSelection(this.attributes.lineSkip * s + this.insets[0]);
        } else {
            this.setScrollSelection(this.attributes.lineSkip * (s - (h - (e - s)) / 2) + this.insets[0]);
        }
        this.redraw();
    }

    public void scrollTo(TextPosition index, int side) {
        int hit = this.findVisualLineOf(index);
        if (side == 1024) {
            this.setScrollSelection(this.attributes.lineSkip * (hit + 1) + this.insets[0] - this.getVerticalBar().getThumb());
        } else {
            this.setScrollSelection(this.attributes.lineSkip * hit + this.insets[0]);
        }
        this.redraw();
    }

    public TextPosition getIndexFromPoint(Point point, boolean strict) {
        if (this.attributes.lineSkip == 0 || this.visualLines.getLineCount() == 0) {
            return TextPosition.INVALID;
        }
        int y = point.y + this.getVerticalBar().getSelection() - this.insets[0];
        int vline = y / this.attributes.lineSkip;
        if (strict && (y < 0 || vline < 0 || this.visualLines.getLineCount() <= vline)) {
            return TextPosition.INVALID;
        }
        vline = Math.min(this.visualLines.getLineCount() - 1, Math.max(0, vline));
        int line = this.visualLines.getLogicalLineAt(vline);
        int col = this.getLineAt(line).getColumnIndexOf(point.x - this.insets[1], this.visualLines.getOffsetAt(vline), this.visualLines.getLengthAt(vline), strict, this.gc, this.attributes);
        if (col == -1) {
            return TextPosition.INVALID;
        }
        return new TextPosition(line, col);
    }

    public Point getPointFromIndex(TextPosition index) {
        return this.getPointFromVisualLine(this.findVisualLineOf(index), index.column);
    }

    public LineFragment getLineFragmentFromIndex(TextPosition index) {
        if (index.row < 0 || this.getLineCount() <= index.row) {
            return null;
        }
        return this.getLineAt(index.row).getLineFragmentFromIndex(index.column);
    }

    private Point getPointFromVisualLine(int visualLineIndex, int logicalColumn) {
        if (visualLineIndex < 0 || this.visualLines.getLineCount() <= visualLineIndex) {
            return new Point(this.insets[1], this.insets[0]);
        }
        return new Point(this.insets[1] + this.getLineAt(this.visualLines.getLogicalLineAt(visualLineIndex)).getPointFromIndex(logicalColumn, this.visualLines.getOffsetAt(visualLineIndex), this.visualLines.getLengthAt(visualLineIndex), this.gc, this.attributes), this.insets[0] + this.attributes.lineSkip * visualLineIndex - this.getVerticalBar().getSelection());
    }

    private int findVisualLineOf(TextPosition index) {
        int logicalLine = index.row;
        int offset = index.column;
        int start = 0;
        int end = this.visualLines.getLineCount();
        int hit = -1;
        while (start < end) {
            int mid = start + (end - start) / 2;
            int log = this.visualLines.getLogicalLineAt(mid);
            if (log == logicalLine) {
                int off = this.visualLines.getOffsetAt(mid);
                int len = this.visualLines.getLengthAt(mid);
                if (off <= offset && offset < off + len) {
                    hit = mid;
                    break;
                }
                if (off + len < offset) {
                    start = mid + 1;
                    continue;
                }
                end = mid;
                continue;
            }
            if (log < logicalLine) {
                start = mid + 1;
                continue;
            }
            end = mid;
        }
        if (hit == -1) {
            hit = end;
        }
        return hit;
    }

    private void recalcScrollMaximum() {
        this.getVerticalBar().setMaximum(this.attributes.lineSkip * this.visualLines.getLineCount() + this.insets[0] + this.insets[2]);
        this.updateScrollThumb();
    }

    private void updateScrollThumb() {
        ScrollBar vertical = this.getVerticalBar();
        if (vertical.getMaximum() < this.getSize().y) {
            vertical.setEnabled(false);
            vertical.setThumb(this.getVerticalBar().getMaximum());
        } else {
            vertical.setEnabled(true);
            vertical.setThumb(this.getSize().y);
        }
    }

    public int setWrapWidth(int width) {
        this.wrapLines(width - this.getVerticalBar().getSize().x - this.insets[1] - this.insets[3]);
        return this.attributes.lineSkip * this.visualLines.getLineCount() + this.insets[0] + this.insets[2];
    }

    private void wrapLines(int width) {
        if (this.width != width) {
            TextPosition scroll = this.getIndexFromPoint(new Point(0, 0), false);
            this.visualLines.clear();
            this.wrapLines(width, this.lines, 0);
            this.width = width;
            this.recalcScrollMaximum();
            if (scroll.row == 0) {
                this.getVerticalBar().setSelection(0);
                this.redraw();
            } else {
                this.scrollTo(scroll, 128);
            }
        }
    }

    private void wrapLines(int width, List lines, int lineNumberOffset) {
        int lc = lines.size();
        int i = 0;
        while (i < lc) {
            ((Line)lines.get(i)).wrapLine(this.visualLines, width, lineNumberOffset + i, this.gc, this.attributes);
            ++i;
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    private void fireSelectionChangedEvent(SelectionChangedEvent e) {
        int i = 0;
        while (i < this.selectionChangedListeners.size()) {
            ISelectionChangedListener l = (ISelectionChangedListener)this.selectionChangedListeners.get(i);
            l.selectionChanged(e);
            ++i;
        }
    }

    public void addTextTrackListener(TextTrackListener listener) {
        this.textTrackListeners.add(listener);
    }

    public void removeTextTrackListener(TextTrackListener listener) {
        this.textTrackListeners.remove(listener);
    }

    public void setToolTipSource(ColoredText toolTipSource) {
        this.toolTipSource = toolTipSource;
    }

    private void fireTextEvent(TextEvent e, int event) {
        int i = 0;
        while (i < this.textTrackListeners.size()) {
            TextTrackListener l = (TextTrackListener)this.textTrackListeners.get(i);
            switch (event) {
                case 0: {
                    l.textEnter(e);
                    break;
                }
                case 1: {
                    l.textExit(e);
                    break;
                }
                case 2: {
                    l.textHover(e);
                    break;
                }
                case 3: {
                    l.textSelectionEnter(e);
                    break;
                }
                case 4: {
                    l.textSelectionExit(e);
                    break;
                }
                case 5: {
                    l.textSelectionHover(e);
                }
            }
            ++i;
        }
    }

    public void setToolTipProvider(ToolTipProvider toolTipProvider) {
        this.toolTipProvider = toolTipProvider;
    }

    public ToolTipProvider getToolTipProvider() {
        return this.toolTipProvider;
    }

    public void setLinkProvider(LinkProvider linkProvider) {
        this.linkProvider = linkProvider;
    }

    public LinkProvider getLinkProvider() {
        return this.linkProvider;
    }

    private static final class VisualLines {
        private int[] lines = new int[30000];
        private int count;

        VisualLines() {
        }

        public final void addLine(int logicalLine, int offset, int length) {
            if (this.count * 3 == this.lines.length) {
                int[] newLines = new int[this.lines.length * 2];
                System.arraycopy(this.lines, 0, newLines, 0, this.lines.length);
                this.lines = newLines;
            }
            this.lines[this.count * 3] = logicalLine;
            this.lines[this.count * 3 + 1] = offset;
            this.lines[this.count * 3 + 2] = length;
            ++this.count;
        }

        public final void clear() {
            this.count = 0;
        }

        public final int getLogicalLineAt(int visualLine) {
            return this.lines[visualLine * 3];
        }

        public final int getOffsetAt(int visualLine) {
            return this.lines[visualLine * 3 + 1];
        }

        public final int getLengthAt(int visualLine) {
            return this.lines[visualLine * 3 + 2];
        }

        public final int getLineCount() {
            return this.count;
        }
    }

    public static interface LinkTarget {
    }

    public static interface LinkProvider {
        public void linkClicked(ColoredText var1, LinkTarget var2);
    }

    public static interface ToolTipTarget {
    }

    public static interface ToolTipProvider {
        public Point fillToolTip(Composite var1, ColoredText var2, int var3, ToolTipTarget var4);

        public Point fillToolTip(Composite var1, ColoredText var2, int var3, String var4);

        public void toolTipActivated(ColoredText var1);

        public void toolTipDeactivated(ColoredText var1);
    }

    public static interface TextTrackListener
    extends EventListener {
        public void textEnter(TextEvent var1);

        public void textExit(TextEvent var1);

        public void textHover(TextEvent var1);

        public void textSelectionEnter(TextEvent var1);

        public void textSelectionExit(TextEvent var1);

        public void textSelectionHover(TextEvent var1);
    }

    public static class TextEvent
    extends TypedEvent {
        static final int EVENT_TEXT_ENTER = 0;
        static final int EVENT_TEXT_EXIT = 1;
        static final int EVENT_TEXT_HOVER = 2;
        static final int EVENT_TEXT_SELECTION_ENTER = 3;
        static final int EVENT_TEXT_SELECTION_EXIT = 4;
        static final int EVENT_TEXT_SELECTION_HOVER = 5;
        public ColoredText text;
        public LineFragment fragment;
        public int x;
        public int y;

        private TextEvent(ColoredText source, MouseEvent e, LineFragment frag) {
            super((Object)source);
            this.display = e.display;
            this.widget = source;
            this.time = e.time;
            this.text = source;
            this.fragment = frag;
            this.x = e.x;
            this.y = e.y;
        }
    }

    public static class TextSelection
    implements ISelection {
        public TextPosition from;
        public TextPosition to;

        public TextSelection(TextPosition from, TextPosition to) {
            this.from = from;
            this.to = to;
        }

        public boolean isEmpty() {
            return !this.from.isValid() || !this.to.isValid() || this.from.equals(this.to);
        }

        public boolean contains(TextPosition pos) {
            return pos.isValid() && this.from.compareTo(pos) <= 0 && pos.compareTo(this.to) <= 0;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TextSelection) {
                return ((TextSelection)obj).from.equals(this.from) && ((TextSelection)obj).to.equals(this.to);
            }
            return false;
        }
    }

    public static class TextPosition {
        public static final TextPosition INVALID = new TextPosition(-1, -1);
        public int row;
        public int column;

        public TextPosition(int row, int column) {
            this.row = row;
            this.column = column;
        }

        public boolean isValid() {
            return this != INVALID;
        }

        public int hashCode() {
            return this.row + this.column;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TextPosition) {
                return ((TextPosition)obj).row == this.row && ((TextPosition)obj).column == this.column;
            }
            return false;
        }

        public int compareTo(TextPosition pos) {
            if (this.row < pos.row) {
                return -1;
            }
            if (this.row > pos.row) {
                return 1;
            }
            if (this.column < pos.column) {
                return -1;
            }
            if (this.column > pos.column) {
                return 1;
            }
            return 0;
        }
    }

    public static class Line {
        private LineFragment fragment;
        private List fragments;
        private int charsCount;
        private int extentCache = -1;
        private int indent;

        public Line(int indent) {
            this.indent = indent;
        }

        public int getTextLength() {
            return this.charsCount;
        }

        public LineFragment getLineFragmentFromIndex(int col) {
            int fc = this.getLineFragmentCount();
            int i = 0;
            while (i < fc) {
                LineFragment f = this.getLineFragmentAt(i);
                if (f.getTextLength() <= col) {
                    col -= f.getTextLength();
                } else {
                    return f;
                }
                ++i;
            }
            return null;
        }

        public int getPointFromIndex(int index, int off, int len, GC gc, Attributes attributes) {
            if (off <= index && index < off + len) {
                len = index - off;
            }
            int x = this.indent;
            int fc = this.getLineFragmentCount();
            int i = 0;
            while (i < fc && len > 0) {
                LineFragment f = this.getLineFragmentAt(i);
                if (f.getTextLength() <= off) {
                    off -= f.getTextLength();
                } else {
                    int l = Math.min(f.getTextLength() - off, len);
                    x = off == 0 && l == f.getTextLength() ? (x += f.getExtent(gc, attributes)) : (x += TextMeasurer.getTextExtent(f.getText(), off, l, gc, f.getFont()));
                    off = 0;
                    len -= l;
                }
                ++i;
            }
            return x;
        }

        public int getColumnIndexOf(int x, int off, int len, boolean strict, GC gc, Attributes attributes) {
            if (strict && (x -= this.indent) < 0) {
                return -1;
            }
            int col = 0;
            int fc = this.getLineFragmentCount();
            int i = 0;
            while (i < fc && len > 0) {
                LineFragment f = this.getLineFragmentAt(i);
                if (f.getTextLength() <= off) {
                    off -= f.getTextLength();
                    col += f.getTextLength();
                } else {
                    int l = Math.min(f.getTextLength() - off, len);
                    int index = f.getColumnIndexOf(x, off, l, strict, gc, attributes);
                    if (index == -1) {
                        col += f.getTextLength();
                    } else {
                        return col + off + index;
                    }
                    x = off == 0 && l == f.getTextLength() ? (x -= f.getExtent(gc, attributes)) : (x -= TextMeasurer.getTextExtent(f.getText(), off, l, gc, f.getFont()));
                    off = 0;
                    len -= l;
                }
                ++i;
            }
            if (strict) {
                return -1;
            }
            return col;
        }

        public void paint(GC gc, Attributes attributes, int x, int y, int off, int len, int lineWidth, int lineHeight) {
            gc.fillRectangle(0, y, x += this.indent, lineHeight);
            int fontHeight = gc.getFontMetrics().getHeight();
            gc.fillRectangle(0, y + fontHeight, lineWidth, lineHeight - fontHeight);
            int fc = this.getLineFragmentCount();
            int i = 0;
            while (i < fc && len > 0) {
                LineFragment f = this.getLineFragmentAt(i);
                if (f.getTextLength() <= off) {
                    off -= f.getTextLength();
                } else {
                    int l = Math.min(f.getTextLength() - off, len);
                    x += f.paint(gc, attributes, x, y, off, l);
                    off = 0;
                    len -= l;
                }
                ++i;
            }
            gc.fillRectangle(x, y, lineWidth - x, lineHeight);
        }

        public void paintSelected(GC gc, Attributes attributes, int x, int y, int off, int len, int lineWidth, int lineHeight, int selectionOffset, int selectionLength, Color selectionDark, Color selectionLight) {
            if (selectionOffset < off) {
                selectionLength -= off - selectionOffset;
                selectionOffset = off;
            }
            if (off + len <= selectionOffset || selectionOffset + selectionLength <= off) {
                this.paint(gc, attributes, x, y, off, len, lineWidth, lineHeight);
                return;
            }
            gc.fillRectangle(0, y, x += this.indent, lineHeight);
            int fontHeight = gc.getFontMetrics().getHeight();
            gc.fillRectangle(0, y + fontHeight, lineWidth, lineHeight - fontHeight);
            int fc = this.getLineFragmentCount();
            int i = 0;
            while (i < fc && len > 0) {
                LineFragment f = this.getLineFragmentAt(i);
                if (f.getTextLength() <= off) {
                    off -= f.getTextLength();
                    selectionOffset -= f.getTextLength();
                } else {
                    int l = Math.min(f.getTextLength() - off, len);
                    int sl = Math.min(f.getTextLength() - selectionOffset, selectionLength);
                    x += f.paintSelected(gc, attributes, x, y, off, l, selectionOffset, sl, selectionDark, selectionLight);
                    if (selectionOffset < off + l) {
                        selectionOffset = 0;
                        selectionLength -= sl;
                    } else {
                        selectionOffset -= l;
                    }
                    off = 0;
                    len -= l;
                }
                ++i;
            }
            gc.fillRectangle(x, y, lineWidth - x, lineHeight);
        }

        public void wrapLine(VisualLines visualLines, int width, int lineNumber, GC gc, Attributes attributes) {
            int extent = this.getExtent(gc, attributes);
            if (extent < (width -= this.indent)) {
                visualLines.addLine(lineNumber, 0, this.charsCount);
            } else {
                int off = 0;
                int len = 0;
                int w = 0;
                int fc = this.getLineFragmentCount();
                int i = 0;
                while (i < fc) {
                    LineFragment f = this.getLineFragmentAt(i);
                    int ext = f.getExtent(gc, attributes);
                    if (w + ext <= width) {
                        len += f.getTextLength();
                        w += ext;
                    } else {
                        int br = 0;
                        while (br < f.getTextLength()) {
                            int next = TextMeasurer.getWrap(f.getText(), br, width - w, gc, f.getFont());
                            if (w == 0 && next == br) {
                                next = br + 1;
                            }
                            len += next - br;
                            if (next < f.getTextLength()) {
                                visualLines.addLine(lineNumber, off, len);
                                off += len;
                                len = 0;
                                w = 0;
                            } else {
                                w = TextMeasurer.getTextExtent(f.getText(), br, next - br, gc, f.getFont());
                            }
                            br = next;
                        }
                    }
                    ++i;
                }
                if (len != 0) {
                    visualLines.addLine(lineNumber, off, len);
                }
            }
        }

        public int getPreferredLineWidth(GC gc, Attributes attributes) {
            return this.indent + this.getExtent(gc, attributes);
        }

        public int getExtent(GC gc, Attributes attributes) {
            if (this.extentCache == -1) {
                this.extentCache = 0;
                int fc = this.getLineFragmentCount();
                int i = 0;
                while (i < fc) {
                    this.extentCache += this.getLineFragmentAt(i).getExtent(gc, attributes);
                    ++i;
                }
            }
            return this.extentCache;
        }

        public void addLineFragment(LineFragment lineFragment) {
            this.charsCount += lineFragment.getTextLength();
            switch (this.getLineFragmentCount()) {
                case 0: {
                    this.fragment = lineFragment;
                    break;
                }
                case 1: {
                    this.fragments = new ArrayList();
                    this.fragments.add(this.fragment);
                    this.fragments.add(lineFragment);
                    this.fragment = null;
                    break;
                }
                default: {
                    this.fragments.add(lineFragment);
                }
            }
        }

        public int getLineFragmentCount() {
            if (this.fragment != null) {
                return 1;
            }
            if (this.fragments != null) {
                return this.fragments.size();
            }
            return 0;
        }

        public LineFragment getLineFragmentAt(int index) {
            switch (this.getLineFragmentCount()) {
                case 0: {
                    throw new IndexOutOfBoundsException();
                }
                case 1: {
                    if (index == 0) {
                        return this.fragment;
                    }
                    throw new IndexOutOfBoundsException();
                }
            }
            return (LineFragment)this.fragments.get(index);
        }

        public String toString() {
            return this.getText();
        }

        public String getText() {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < this.getLineFragmentCount()) {
                buf.append(this.getLineFragmentAt(i).toString());
                ++i;
            }
            return buf.toString();
        }
    }

    public static class LineFragment {
        private String text;
        private int offset;
        private int length;
        private int color;
        private int font;
        private boolean underline;
        private int extentCache = -1;

        public LineFragment(String text, int color, int font, boolean underline) {
            this(text, 0, text.length(), color, font, underline);
        }

        public LineFragment(String text, int offset, int length, int color, int font, boolean underline) {
            this.text = text;
            this.offset = offset;
            this.length = length;
            this.color = color;
            this.font = font;
            this.underline = underline;
        }

        public int getColumnIndexOf(int x, int off, int len, boolean strict, GC gc, Attributes attributes) {
            if (this.getExtent(gc, attributes) < x) {
                return -1;
            }
            return TextMeasurer.getColumnIndexOf(x, this.text, this.offset + off, len, strict, gc, this.font);
        }

        public int paint(GC gc, Attributes attributes, int x, int y, int off, int len) {
            if (gc.getFont() != attributes.getFont(this.font)) {
                gc.setFont(attributes.getFont(this.font));
            }
            if (gc.getForeground() != attributes.getColor(this.color)) {
                gc.setForeground(attributes.getColor(this.color));
            }
            String str = this.text.substring(this.offset + off, this.offset + off + len);
            gc.drawString(str, x, y, false);
            if (this.underline) {
                int ascent = gc.getFontMetrics().getAscent();
                gc.drawLine(x, y + ascent, x + this.getExtent(gc, attributes), y + ascent);
            }
            return gc.textExtent((String)str, (int)0).x;
        }

        public int paintSelected(GC gc, Attributes attributes, int x, int y, int off, int len, int selectionOffset, int selectionLength, Color selectionDark, Color selectionLight) {
            if (off + len <= selectionOffset || selectionOffset + selectionLength <= off) {
                return this.paint(gc, attributes, x, y, off, len);
            }
            if (gc.getFont() != attributes.getFont(this.font)) {
                gc.setFont(attributes.getFont(this.font));
            }
            if (gc.getForeground() != attributes.getColor(this.color)) {
                gc.setForeground(attributes.getColor(this.color));
            }
            int ascent = this.underline ? gc.getFontMetrics().getAscent() : 0;
            int ulx = x;
            if (off < selectionOffset) {
                String f = this.text.substring(this.offset + off, this.offset + selectionOffset);
                gc.drawString(f, x, y, false);
                int ext = TextMeasurer.getTextExtent(f, 0, f.length(), gc, this.font);
                x += ext;
                if (this.underline) {
                    gc.drawLine(ulx, y + ascent, ulx + ext, y + ascent);
                    ulx += ext;
                }
            }
            int postLen = off + len - (selectionOffset + selectionLength);
            Color bg = gc.getBackground();
            Color fg = gc.getForeground();
            if (fg.getRed() + fg.getGreen() + fg.getGreen() < 256) {
                gc.setBackground(selectionDark);
                gc.setForeground(selectionLight);
            } else {
                gc.setBackground(selectionLight);
                gc.setForeground(selectionDark);
            }
            String f = this.text.substring(this.offset + selectionOffset, this.offset + selectionOffset + selectionLength);
            gc.drawString(f, x, y, false);
            if (postLen > 0) {
                int ext = TextMeasurer.getTextExtent(f, 0, f.length(), gc, this.font);
                x += ext;
                if (this.underline) {
                    gc.drawLine(ulx, y + ascent, ulx + ext, y + ascent);
                    ulx += ext;
                }
            } else if (this.underline) {
                gc.drawLine(ulx, y + ascent, x + this.getExtent(gc, attributes), y + ascent);
            }
            gc.setBackground(bg);
            gc.setForeground(fg);
            if (postLen > 0) {
                int o = selectionOffset + selectionLength;
                f = this.text.substring(this.offset + o, this.offset + o + postLen);
                gc.drawString(f, x, y, false);
                if (this.underline) {
                    gc.drawLine(ulx, y + ascent, x + this.getExtent(gc, attributes), y + ascent);
                }
            }
            return gc.textExtent((String)this.text.substring((int)(this.offset + off), (int)(this.offset + off + len)), (int)0).x;
        }

        public int getExtent(GC gc, Attributes attributes) {
            if (gc.getFont() != attributes.getFont(this.font)) {
                gc.setFont(attributes.getFont(this.font));
            }
            if (this.extentCache == -1) {
                this.extentCache = TextMeasurer.getTextExtent(this.text, this.offset, this.length, gc, this.font);
            }
            return this.extentCache;
        }

        public String toString() {
            return this.getText();
        }

        public String getText() {
            return this.text.substring(this.offset, this.offset + this.length);
        }

        public int getColor() {
            return this.color;
        }

        public void setColor(int color) {
            this.color = color;
        }

        public int getFont() {
            return this.font;
        }

        public int getTextLength() {
            return this.length;
        }

        public boolean getUnderline() {
            return this.underline;
        }
    }

    public static class Attributes {
        public static final int COLOR_BLACK = 0;
        public static final int COLOR_RED = 1;
        public static final int COLOR_BLUE = 2;
        public static final int COLOR_FORESTGREEN = 3;
        public static final int COLOR_BACKGROUND_GRAD = 4;
        public static final int FONT_NORMAL = 0;
        public static final int FONT_BOLD = 1;
        private Color black;
        private Color red;
        private Color blue;
        private Color forestgreen;
        private Color backgroundGray;
        private Color[] colors = new Color[5];
        private Font normalFont;
        private Font boldFont;
        private Font[] fonts = new Font[2];
        private int lineSkip;

        public Attributes(Device device) {
            this.colors[0] = this.black = new Color(device, 0, 0, 0);
            this.colors[1] = this.red = new Color(device, 255, 0, 0);
            this.colors[2] = this.blue = new Color(device, 0, 0, 255);
            this.colors[3] = this.forestgreen = new Color(device, 34, 139, 34);
            this.colors[4] = this.backgroundGray = new Color(device, 239, 239, 239);
            this.fonts[0] = this.normalFont = new Font(device, "MS P Gothic", 12, 0);
            this.fonts[1] = this.boldFont = new Font(device, "MS P Gothic", 12, 1);
            this.lineSkip = 18;
        }

        public Color getColor(int key) {
            if (key >= 0 && key < this.colors.length) {
                return this.colors[key];
            }
            return this.colors[0];
        }

        public Font getFont(int key) {
            if (key >= 0 && key < this.fonts.length) {
                return this.fonts[key];
            }
            return this.fonts[0];
        }

        public void dispose() {
            int i = 0;
            while (i < this.colors.length) {
                if (this.colors[i] != null) {
                    this.colors[i].dispose();
                }
                this.colors[i] = null;
                ++i;
            }
            i = 0;
            while (i < this.fonts.length) {
                if (this.fonts[i] != null) {
                    this.fonts[i].dispose();
                }
                this.fonts[i] = null;
                ++i;
            }
        }
    }

    private static class TextMeasurer {
        private static int[][] CHAR_ADVANCE_CACHE = new int[2][65536];

        TextMeasurer() {
        }

        public static int getColumnIndexOf(int x, String text, int off, int len, boolean strict, GC gc, int font) {
            int extent = 0;
            int[] cache = CHAR_ADVANCE_CACHE[font];
            int i = 0;
            while (i < len) {
                int adv = TextMeasurer.getAdvanceWidth(cache, text.charAt(off + i), gc, font);
                if (strict && x < extent + adv) {
                    return i;
                }
                if (!strict && x < extent + adv / 2) {
                    return i;
                }
                extent += adv;
                ++i;
            }
            return len;
        }

        public static int getTextExtent(String text, int off, int len, GC gc, int font) {
            int extent = 0;
            int[] cache = CHAR_ADVANCE_CACHE[font];
            int i = 0;
            while (i < len) {
                extent += TextMeasurer.getAdvanceWidth(cache, text.charAt(off + i), gc, font);
                ++i;
            }
            return extent;
        }

        private static int getAdvanceWidth(int[] cache, char ch, GC gc, int font) {
            int w = cache[ch];
            if (w == 0) {
                cache[ch] = w = gc.getAdvanceWidth(ch);
            }
            return w;
        }

        private static int getWrap(String text, int off, int width, GC gc, int font) {
            int br = off;
            int len = text.length();
            int w = 0;
            int[] cache = CHAR_ADVANCE_CACHE[font];
            int i = off;
            while (i < len) {
                int chw = TextMeasurer.getAdvanceWidth(cache, text.charAt(i), gc, font);
                if (width < w + chw) break;
                w += chw;
                ++br;
                ++i;
            }
            return br;
        }
    }

    private class PageMoveKeyListener
    implements KeyListener {
        private int keyRepeat;
        private boolean repeating;
        private long baseTime;

        PageMoveKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            if (this.keyRepeat == 0) {
                switch (e.keyCode) {
                    case 0x1000001: 
                    case 0x1000002: 
                    case 0x1000005: 
                    case 0x1000006: {
                        this.keyRepeat = e.keyCode;
                    }
                }
                if (e.character == ' ' || e.character == '\b') {
                    this.keyRepeat = e.character;
                }
                if (this.keyRepeat != 0) {
                    this.repeating = false;
                    long pressedTime = this.baseTime = System.currentTimeMillis();
                    int keyRepeat = this.keyRepeat;
                    ColoredText.this.getShell().getDisplay().timerExec(10, new Runnable(this, pressedTime, keyRepeat){
                        private static final int FIRST_MOVE = 70;
                        private final /* synthetic */ long val$pressedTime;
                        private final /* synthetic */ PageMoveKeyListener this$1;
                        private final /* synthetic */ int val$keyRepeat;
                        {
                            this.this$1 = pageMoveKeyListener;
                            this.val$pressedTime = l;
                            this.val$keyRepeat = n;
                        }

                        public void run() {
                            long curTime = System.currentTimeMillis();
                            if (curTime - this.val$pressedTime < 70L && !PageMoveKeyListener.access$0(this.this$1)) {
                                PageMoveKeyListener.access$5(this.this$1).getShell().getDisplay().timerExec(10, (Runnable)this);
                            }
                            if (!PageMoveKeyListener.access$0(this.this$1)) {
                                long firstPeriod = Math.min(this.val$pressedTime + 70L, curTime);
                                PageMoveKeyListener.access$2(this.this$1, this.val$keyRepeat, PageMoveKeyListener.access$5(this.this$1).getVerticalBar().getThumb() / 8 * (int)(firstPeriod - PageMoveKeyListener.access$1(this.this$1)) / 70);
                                PageMoveKeyListener.access$3(this.this$1, firstPeriod);
                            }
                        }
                    });
                } else if (e.keyCode == 0x1000007) {
                    ColoredText.this.getVerticalBar().setSelection(0);
                    ColoredText.this.redraw();
                } else if (e.keyCode == 0x1000008) {
                    ColoredText.this.getVerticalBar().setSelection(ColoredText.this.getVerticalBar().getMaximum());
                    ColoredText.this.redraw();
                }
            } else if (!this.repeating) {
                this.repeating = true;
                this.baseTime = System.currentTimeMillis();
                ColoredText.this.getShell().getDisplay().timerExec(10, new Runnable(this){
                    private static final int FIRST_MOVE = 100;
                    private final /* synthetic */ PageMoveKeyListener this$1;
                    {
                        this.this$1 = pageMoveKeyListener;
                    }

                    public void run() {
                        if (PageMoveKeyListener.access$0(this.this$1)) {
                            PageMoveKeyListener.access$5(this.this$1).getShell().getDisplay().timerExec(10, (Runnable)this);
                            long curTime = System.currentTimeMillis();
                            PageMoveKeyListener.access$2(this.this$1, PageMoveKeyListener.access$4(this.this$1), (int)((double)(curTime - PageMoveKeyListener.access$1(this.this$1)) * 1.5));
                            PageMoveKeyListener.access$3(this.this$1, curTime);
                        }
                    }
                });
            }
        }

        private void keyAction(int keyCode, int increment) {
            switch (keyCode) {
                case 0x1000002: {
                    break;
                }
                case 0x1000001: {
                    increment = -increment;
                    break;
                }
                case 32: 
                case 0x1000006: {
                    increment *= 7;
                    break;
                }
                case 8: 
                case 0x1000005: {
                    increment *= -7;
                }
            }
            ColoredText.this.setScrollSelection(ColoredText.this.getVerticalBar().getSelection() + increment);
            ColoredText.this.redraw();
        }

        public void keyReleased(KeyEvent e) {
            this.keyRepeat = 0;
            this.repeating = false;
        }

        static /* synthetic */ boolean access$0(PageMoveKeyListener pageMoveKeyListener) {
            return pageMoveKeyListener.repeating;
        }

        static /* synthetic */ long access$1(PageMoveKeyListener pageMoveKeyListener) {
            return pageMoveKeyListener.baseTime;
        }

        static /* synthetic */ void access$2(PageMoveKeyListener pageMoveKeyListener, int n, int n2) {
            pageMoveKeyListener.keyAction(n, n2);
        }

        static /* synthetic */ void access$3(PageMoveKeyListener pageMoveKeyListener, long l) {
            pageMoveKeyListener.baseTime = l;
        }

        static /* synthetic */ int access$4(PageMoveKeyListener pageMoveKeyListener) {
            return pageMoveKeyListener.keyRepeat;
        }

        static /* synthetic */ ColoredText access$5(PageMoveKeyListener pageMoveKeyListener) {
            return pageMoveKeyListener.ColoredText.this;
        }
    }

    private class MouseDragListener
    implements MouseListener,
    MouseMoveListener,
    MouseTrackListener {
        private TextPosition selectionStart = TextPosition.INVALID;
        private TextPosition selectionEnd = TextPosition.INVALID;
        private int increment;
        private Point lastMouseLocation;
        private TextPosition lastTextPosition = TextPosition.INVALID;
        private LineFragment lastLineFragment;
        private LineFragment lastHoverLineFragment;
        private TextSelection lastSelection;
        private TextSelection lastHoverSelection;
        private LinkTarget lastLinkTarget;

        MouseDragListener() {
        }

        public void mouseDown(MouseEvent e) {
            if (e.button == 1) {
                LineFragment f;
                TextPosition position;
                ColoredText.this.toolTipLocked = false;
                ColoredText.this.disposeToolTip();
                ColoredText.this.setCapture(true);
                this.selectionStart = ColoredText.this.getIndexFromPoint(new Point(e.x, e.y), false);
                this.selectionEnd = TextPosition.INVALID;
                ColoredText.this.setSelection(TextPosition.INVALID, this.selectionEnd, true);
                ColoredText.this.getShell().getDisplay().timerExec(10, new Runnable(this){
                    private final /* synthetic */ MouseDragListener this$1;
                    {
                        this.this$1 = mouseDragListener;
                    }

                    public void run() {
                        if (MouseDragListener.access$0(this.this$1) != 0) {
                            MouseDragListener.access$5(this.this$1).getVerticalBar().setSelection(Math.min(Math.max(MouseDragListener.access$5(this.this$1).getVerticalBar().getSelection() + MouseDragListener.access$0(this.this$1), 0), MouseDragListener.access$5(this.this$1).getVerticalBar().getMaximum()));
                            MouseDragListener.access$2(this.this$1, MouseDragListener.access$5(this.this$1).getIndexFromPoint(MouseDragListener.access$1(this.this$1), false));
                            MouseDragListener.access$5(this.this$1).setSelection(MouseDragListener.access$3(this.this$1), MouseDragListener.access$4(this.this$1), false);
                            MouseDragListener.access$5(this.this$1).redraw();
                        }
                        if (MouseDragListener.access$3(this.this$1).isValid()) {
                            MouseDragListener.access$5(this.this$1).getShell().getDisplay().timerExec(10, (Runnable)this);
                        }
                    }
                });
                if (this.selectionStart.isValid() && (position = ColoredText.this.getIndexFromPoint(new Point(e.x, e.y), true)).isValid() && (f = ColoredText.this.getLineFragmentFromIndex(position)) instanceof LinkTarget) {
                    ColoredText.this.setSelection(f, true);
                    this.lastLinkTarget = (LinkTarget)((Object)f);
                }
            }
        }

        public void mouseUp(MouseEvent e) {
            LineFragment f;
            TextPosition position;
            if (e.button == 1 && (position = ColoredText.this.getIndexFromPoint(new Point(e.x, e.y), true)).isValid() && (f = ColoredText.this.getLineFragmentFromIndex(position)) != null && f == this.lastLinkTarget && ColoredText.this.linkProvider != null) {
                ColoredText.this.disposeToolTip();
                ColoredText.this.setSelection(f, true);
                ColoredText.this.linkProvider.linkClicked(ColoredText.this, this.lastLinkTarget);
                this.lastLinkTarget = null;
            }
            ColoredText.this.setCapture(false);
            this.selectionStart = TextPosition.INVALID;
            this.selectionEnd = TextPosition.INVALID;
            this.increment = 0;
        }

        public void mouseDoubleClick(MouseEvent e) {
            TextPosition position = ColoredText.this.getIndexFromPoint(new Point(e.x, e.y), false);
            if (position.isValid()) {
                Line line = ColoredText.this.getLineAt(position.row);
                String s = line.toString();
                if (s.length() == 0) {
                    return;
                }
                if (position.column == s.length()) {
                    --position.column;
                }
                TextPosition start = new TextPosition(position.row, position.column);
                TextPosition end = new TextPosition(position.row, position.column);
                Character.UnicodeBlock block = Character.UnicodeBlock.of(s.charAt(position.column));
                while (start.column > 0 && Character.UnicodeBlock.of(s.charAt(start.column - 1)) == block) {
                    --start.column;
                }
                while (end.column < s.length() && Character.UnicodeBlock.of(s.charAt(end.column)) == block) {
                    ++end.column;
                }
                ColoredText.this.setSelection(start, end, true);
            }
        }

        public void mouseMove(MouseEvent e) {
            if (e.y < 0 || ColoredText.this.getSize().y < e.y) {
                ColoredText.this.setCapture(false);
                if (!ColoredText.this.toolTipLocked) {
                    ColoredText.this.disposeToolTip();
                }
                return;
            }
            Point mouseLocation = new Point(e.x, e.y);
            TextPosition position = ColoredText.this.getIndexFromPoint(mouseLocation, true);
            if (position.isValid()) {
                TextSelection s;
                LineFragment f = ColoredText.this.getLineFragmentFromIndex(position);
                if (this.lastLineFragment != f) {
                    if (this.lastLineFragment != null) {
                        ColoredText.this.fireTextEvent(new TextEvent(ColoredText.this, e, this.lastLineFragment), 1);
                    }
                    if (f != null) {
                        ColoredText.this.fireTextEvent(new TextEvent(ColoredText.this, e, f), 0);
                    }
                    this.lastLineFragment = f;
                    this.lastHoverLineFragment = null;
                }
                if (!(s = ColoredText.this.getTextSelection()).contains(position)) {
                    s = null;
                }
                if (s == null && this.lastSelection != null || s != null && this.lastSelection == null || s != null && s != null && !s.equals(this.lastSelection)) {
                    if (this.lastSelection != null) {
                        ColoredText.this.fireTextEvent(new TextEvent(ColoredText.this, e, f), 4);
                    }
                    if (s != null) {
                        ColoredText.this.fireTextEvent(new TextEvent(ColoredText.this, e, f), 3);
                    }
                    this.lastSelection = s;
                    this.lastHoverSelection = null;
                }
            } else {
                if (this.lastLineFragment != null) {
                    ColoredText.this.fireTextEvent(new TextEvent(ColoredText.this, e, this.lastLineFragment), 1);
                }
                this.lastLineFragment = null;
                this.lastHoverLineFragment = null;
                if (this.lastSelection != null) {
                    ColoredText.this.fireTextEvent(new TextEvent(ColoredText.this, e, null), 4);
                }
                this.lastSelection = null;
                this.lastHoverSelection = null;
            }
            if (this.selectionStart.isValid()) {
                this.lastMouseLocation = mouseLocation;
                this.selectionEnd = ColoredText.this.getIndexFromPoint(mouseLocation, false);
                ScrollBar vertical = ColoredText.this.getVerticalBar();
                this.increment = 0;
                int h = ColoredText.this.getSize().y;
                int grad = h / 16;
                int base = h / 8;
                if (e.y < 0) {
                    this.increment = -base;
                } else if (e.y < grad && grad != 0) {
                    this.increment = -base * (grad - e.y) / grad;
                } else if (h < e.y) {
                    this.increment = base;
                } else if (h - grad < e.y && grad != 0) {
                    this.increment = base * (grad - (h - e.y)) / grad;
                }
                ColoredText.this.setSelection(this.selectionStart, this.selectionEnd, this.increment == 0);
                if (this.increment != 0) {
                    vertical.setSelection(vertical.getSelection() + this.increment);
                    ColoredText.this.redraw();
                }
            }
        }

        public void mouseEnter(MouseEvent e) {
        }

        public void mouseExit(MouseEvent e) {
        }

        public void mouseHover(MouseEvent e) {
            LineFragment f;
            Point mouseLocation;
            TextPosition position;
            if (this.lastHoverSelection == null && (position = ColoredText.this.getIndexFromPoint(mouseLocation = new Point(e.x, e.y), true)).isValid()) {
                TextSelection s = ColoredText.this.getTextSelection();
                if (!s.contains(position)) {
                    s = null;
                }
                if (s != null) {
                    this.lastHoverSelection = s;
                    this.lastSelection = s;
                    ColoredText.this.fireTextEvent(new TextEvent(ColoredText.this, e, null), 5);
                    return;
                }
            }
            if (this.lastHoverLineFragment == null && (position = ColoredText.this.getIndexFromPoint(mouseLocation = new Point(e.x, e.y), true)).isValid() && (f = ColoredText.this.getLineFragmentFromIndex(position)) != null) {
                this.lastHoverLineFragment = f;
                ColoredText.this.fireTextEvent(new TextEvent(ColoredText.this, e, f), 2);
            }
        }

        static /* synthetic */ int access$0(MouseDragListener mouseDragListener) {
            return mouseDragListener.increment;
        }

        static /* synthetic */ Point access$1(MouseDragListener mouseDragListener) {
            return mouseDragListener.lastMouseLocation;
        }

        static /* synthetic */ void access$2(MouseDragListener mouseDragListener, TextPosition textPosition) {
            mouseDragListener.selectionEnd = textPosition;
        }

        static /* synthetic */ TextPosition access$3(MouseDragListener mouseDragListener) {
            return mouseDragListener.selectionStart;
        }

        static /* synthetic */ TextPosition access$4(MouseDragListener mouseDragListener) {
            return mouseDragListener.selectionEnd;
        }

        static /* synthetic */ ColoredText access$5(MouseDragListener mouseDragListener) {
            return mouseDragListener.ColoredText.this;
        }
    }
}

