/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.FormControl;
import com.meterware.httpunit.NodeUtils;
import com.meterware.httpunit.ParameterProcessor;
import java.io.IOException;
import java.util.List;
import org.w3c.dom.Node;

abstract class BooleanFormControl
extends FormControl {
    private boolean _isChecked;
    private String[] _value = new String[1];
    private final boolean _isCheckedDefault;

    public BooleanFormControl(Node node) {
        super(node);
        this._isChecked = this._isCheckedDefault = NodeUtils.isNodeAttributePresent(node, "checked");
    }

    boolean isChecked() {
        return this._isChecked;
    }

    public void setChecked(boolean checked) {
        this._isChecked = checked;
    }

    void reset() {
        this._isChecked = this._isCheckedDefault;
    }

    public String[] getValues() {
        return this.isChecked() ? this.toArray(this.getQueryValue()) : FormControl.NO_VALUE;
    }

    public String[] getOptionValues() {
        return this.isReadOnly() && !this.isChecked() ? FormControl.NO_VALUE : this.toArray(this.getQueryValue());
    }

    void addValues(ParameterProcessor processor, String characterSet) throws IOException {
        if (this.isChecked()) {
            processor.addParameter(this.getName(), this.getQueryValue(), characterSet);
        }
    }

    void claimRequiredValues(List values) {
        if (this.isValueRequired()) {
            this.claimValueIsRequired(values, this.getQueryValue());
        }
    }

    protected boolean isValueRequired() {
        return this.isReadOnly() && this.isChecked();
    }

    abstract String getQueryValue();

    private String[] toArray(String value) {
        this._value[0] = value;
        return this._value;
    }
}

