/*
 * RandomAmount.java
 *
 * Copyright 2014 the Monache.org.
 * http://www.monache.org/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.monache.nagesen.amount;

import java.math.BigDecimal;

import org.monache.nagesen.AddressData;

/**
 * 
 * 
 * @author monache.org
 * @since 1.0
 */
public class RandomAmount implements Amount {

	private BigDecimal min = null;
	private BigDecimal max = null;
	
	/**
	 * 
	 * @since 1.0
	 */
	public RandomAmount() {
		
	}

	/* (非 Javadoc)
	 * @see org.monache.nagesen.amount.AmountLogic#calc(org.monache.nagesen.AddressData)
	 * @since 1.0
	 */
	public BigDecimal calc(AddressData data) {

		BigDecimal ret = getMax().multiply(new BigDecimal(Math.random()));
		if (ret.compareTo(getMin()) == -1) {
			ret = new BigDecimal(getMin().toString());

		} else if (ret.compareTo(getMax()) == 1) {
			ret = new BigDecimal(getMax().toString());
		}
		
		// TODO 丸め処理、ウォレットが勝手にやってる
		return ret;
	}

	/**
	 * @return min
	 * @since 1.0
	 */
	public BigDecimal getMin() {
		return min;
	}

	/**
	 * @param min セットする min
	 * @since 1.0
	 */
	public void setMin(BigDecimal min) {
		this.min = min;
	}

	/**
	 * @return max
	 * @since 1.0
	 */
	public BigDecimal getMax() {
		return max;
	}

	/**
	 * @param max セットする max
	 * @since 1.0
	 */
	public void setMax(BigDecimal max) {
		this.max = max;
	}
	
	

}
