/*
 * SendFromTestManual1.java
 *
 * Copyright 2014 the Monache.org.
 * http://www.monache.org/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package org.monache.lib.api;

import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.ResourceBundle;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.monache.lib.api.CoinAPIJsonRPCClient;
import org.monache.lib.api.SendFrom;
import org.monache.lib.api.WalletLock;
import org.monache.lib.api.WalletPassphrase;
import org.monache.lib.api.impl.DefaultCoinAPIFactory;
import org.monache.lib.api.result.SendFromResult;
import org.monache.lib.api.result.WalletLockResult;
import org.monache.lib.api.result.WalletPassphraseResult;
import org.monache.lib.httpclient.BasicAuthenticationHttpClient;
import org.monache.lib.httpclient.HttpClient;
import org.monache.lib.jsonrpc.JsonRPCClient;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.S2ContainerFactory;

/**
 * 
 * 
 * @version 
 * @author monache.org
 * @since 
 */
public class SendFromTestManual1 {

	static ResourceBundle bundle = null;
	static S2Container container = null;
	static DefaultCoinAPIFactory factory = null;
	static JsonRPCClient jsonRPCS2 = null;
	static JsonRPCClient jsonRPC = null;
	
	/**
	 * 
	 * @throws java.lang.Exception
	 * @since 
	 */
	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
		bundle = ResourceBundle.getBundle("org.monache.lib.api.test-manual1p");

		// seaser2
		container = S2ContainerFactory.create("org/monache/lib/api/test-manual1d.dicon");
		jsonRPCS2 = (JsonRPCClient)container.getComponent(JsonRPCClient.class);

		// factory
		factory = DefaultCoinAPIFactory.newInstance();
		HttpClient httpClient = new BasicAuthenticationHttpClient(
				bundle.getString("host"),
				Integer.parseInt(bundle.getString("port")),
				bundle.getString("user"),
				bundle.getString("password"),
				Integer.parseInt(bundle.getString("connectionTimeout")),
				Integer.parseInt(bundle.getString("socketTimeout")));
		jsonRPC = new CoinAPIJsonRPCClient(
				httpClient, bundle.getString("uri"),
				bundle.getString("schema"),
				bundle.getString("responseCharset").length() == 0 ? null : Charset.forName(bundle.getString("responseCharset")));
	}

	/**
	 * @throws java.lang.Exception
	 * @since 
	 */
	@AfterClass
	public static void tearDownAfterClass() throws Exception {
		// seaser2
		jsonRPCS2.close();
		
		// factory
		jsonRPC.close();
	}

	/**
	 * @throws java.lang.Exception
	 * @since 
	 */
	@Before
	public void setUp() throws Exception {
	}

	/**
	 * @throws java.lang.Exception
	 * @since 
	 */
	@After
	public void tearDown() throws Exception {
	}

	public static void main(String[] args) throws Exception {
		
		boolean isTestSkip = true;
		if (isTestSkip) {
			System.out.println("test skip SendFromTestManual1.main");
			return;
		}
		
		setUpBeforeClass();
		SendFromTestManual1 test = new SendFromTestManual1();
		test.testS1();
		test.testF1();
		test.testS2();
		
		tearDownAfterClass();
	}

	
	//JUnitでテストしない 
	// SendFromResult call(String fromAccount, String toAddress, BigDecimal amount)
	//@Test
	public void testS1() throws Exception {
		// Seaser2

		System.out.println("***** testS1 *********************************");
		// パスワードを設定している場合は解除する
		if (bundle.getString("WalletPassphrase.passphrase").length() != 0) {
			WalletPassphrase unlock = (WalletPassphrase)container.getComponent(WalletPassphrase.class);
			WalletPassphraseResult unlockResult = unlock.call(jsonRPCS2, bundle.getString("WalletPassphrase.passphrase"), 10);
			System.out.println("unlock json: " + unlockResult.getJsonString());
			
		}
		
		try {
			SendFrom obj = (SendFrom)container.getComponent(SendFrom.class);
			SendFromResult result = obj.call(jsonRPCS2, bundle.getString("SendFrom.fromAccount"),bundle.getString("SendFrom.toAddress"),BigDecimal.valueOf(1.234));
			System.out.println("transactionId = " + result.getTransactionId());
			System.out.println("json = " + result.getJsonString());

		} finally {
			// パスワードを解除した場合はロックする
			if (bundle.getString("WalletPassphrase.passphrase").length() != 0) {
				WalletLock lock = (WalletLock)container.getComponent(WalletLock.class);
				WalletLockResult lockResult = lock.call(jsonRPCS2);
				System.out.println("lock json: " + lockResult.getJsonString());
			}
		}
	}


	//JUnitでテストしない 
	// SendFromResult call(String fromAccount, String toAddress, BigDecimal amount)
	//@Test
	public void testF1() throws Exception {
		// Factory
		System.out.println("***** testF1 *********************************");
		// パスワードを設定している場合は解除する
		if (bundle.getString("WalletPassphrase.passphrase").length() != 0) {
			WalletPassphrase unlock = factory.getWalletPassphrase();
			WalletPassphraseResult unlockResult = unlock.call(jsonRPC, bundle.getString("WalletPassphrase.passphrase"), 10);
			System.out.println("unlock json: " + unlockResult.getJsonString());
			
		}
		
		try {
			SendFrom obj = factory.getSendFrom();
			SendFromResult result = obj.call(jsonRPC, bundle.getString("SendFrom.fromAccount"),bundle.getString("SendFrom.toAddress"),BigDecimal.valueOf(1.234));
			System.out.println("transactionId = " + result.getTransactionId());
			System.out.println("json = " + result.getJsonString());

		} finally {
			// パスワードを解除した場合はロックする
			if (bundle.getString("WalletPassphrase.passphrase").length() != 0) {
				WalletLock lock = factory.getWalletLock();
				WalletLockResult lockResult = lock.call(jsonRPC);
				System.out.println("lock json: " + lockResult.getJsonString());
			}
		}
	}
	
	//JUnitでテストしない 
	//@Test
	public void testS2() throws Exception {
	}


}
