/*
 * Sample.java
 *
 * Copyright 2014 the Monache.org.
 * http://www.monache.org/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.ResourceBundle;

import org.monache.lib.api.CoinAPIJsonRPCClient;
import org.monache.lib.api.SendFrom;
import org.monache.lib.api.WalletLock;
import org.monache.lib.api.WalletPassphrase;
import org.monache.lib.api.impl.DefaultCoinAPIFactory;
import org.monache.lib.api.result.SendFromResult;
import org.monache.lib.httpclient.BasicAuthenticationHttpClient;
import org.monache.lib.httpclient.HttpClient;
import org.monache.lib.jsonrpc.JsonRPCClient;
import org.monache.lib.jsonrpc.JsonRPCException;


/**
 * 
 * 
 * @author monache.org
 * @since 1.0
 */
public class Sample {

	/**
	 * 
	 * @since 1.0
	 */
	public Sample() {
		// TODO 自動生成されたコンストラクター・スタブ
	}

	public static void main(String[] a) {
		new Sample().sample();
	}
	
	public void sample() {

		// 暗号化したウォレットで0.01monaをM83iPCZfjBzHkogog2eidFdVruJ38S37poに送信する
		// 送信元にはtest(ラベル名)を利用する
		ResourceBundle bundle = ResourceBundle.getBundle("sample");
		JsonRPCClient jsonRPC = null;
		try {
			DefaultCoinAPIFactory factory = DefaultCoinAPIFactory.newInstance();
			HttpClient httpClient = new BasicAuthenticationHttpClient(
					bundle.getString("host"),
					Integer.parseInt(bundle.getString("port")),
					bundle.getString("user"),
					bundle.getString("password"),
					Integer.parseInt(bundle.getString("connectionTimeout")),
					Integer.parseInt(bundle.getString("socketTimeout")));
			jsonRPC = new CoinAPIJsonRPCClient(
					httpClient, bundle.getString("uri"),
					bundle.getString("schema"),
					bundle.getString("responseCharset").length() == 0 ? null : Charset.forName(bundle.getString("responseCharset")));

			
			// 10秒間複合
			WalletPassphrase unlock = factory.getWalletPassphrase();
			unlock.call(jsonRPC, "12345", 10);

			try {
				SendFrom obj = factory.getSendFrom();
				SendFromResult result = obj.call(jsonRPC, "test", "M83iPCZfjBzHkogog2eidFdVruJ38S37po", new BigDecimal(0.01));
				System.out.println("transactionId = " + result.getTransactionId());

			} finally {				
				// 複合を解除する
				WalletLock lock = factory.getWalletLock();
				lock.call(jsonRPC);
			
			}
		
		} catch (Exception e) {
			e.printStackTrace();

		} finally {
			if (jsonRPC != null) {
				try {
					jsonRPC.close();
				} catch (JsonRPCException e1) {
					e1.printStackTrace();
				}
			}
		}

	}
}
