/*
 * JsonRPCException.java
 *
 * Copyright 2014 the Monache.org.
 * http://www.monache.org/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.monache.lib.jsonrpc;

import org.monache.lib.fw.MonacheException;

/**
 * 
 * 
 * @version 
 * @author monache.org
 * @since 
 */
public class JsonRPCException extends MonacheException {

	private static final long serialVersionUID = -7564036712440738014L;

	private JsonRPCErrorObject errorObject = null;
	
	/**
	 * 
	 * @since 1.0
	 */
	public JsonRPCException() {
		super();
	}

	/**
	 * @param message
	 * @param cause
	 * @since 1.0
	 */
	public JsonRPCException(String message, Throwable cause) {
		super(message, cause);
	}

	/**
	 * @param message
	 * @since 1.0
	 */
	public JsonRPCException(String message) {
		super(message);
	}

	/**
	 * @param cause
	 * @since 1.0
	 */
	public JsonRPCException(Throwable cause) {
		super(cause);
	}

	public JsonRPCException(JsonRPCErrorObject errorObject) {
		super();
		setErrorObject(errorObject);
	}
	
	public JsonRPCException(String message, JsonRPCErrorObject errorObject) {
		super(message);
		setErrorObject(errorObject);
	}
	
	/**
	 * @return errorObject
	 * @since 1.0
	 */
	public JsonRPCErrorObject getErrorObject() {
		return errorObject;
	}

	/**
	 * @param errorObject セットする errorObject
	 * @since 1.0
	 */
	public void setErrorObject(JsonRPCErrorObject errorObject) {
		this.errorObject = errorObject;
	}

	
	
}
