/*
 * JsonRPCErrorObject.java
 *
 * Copyright 2014 the Monache.org.
 * http://www.monache.org/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.monache.lib.jsonrpc;

/**
 * 
 * 
 * @author monache.org
 * @since 1.0
 */
public class JsonRPCErrorObject {

	private Integer code = null;
	private String message = null;
	private Object data = null;
	
	/**
	 * 
	 * @since 1.0
	 */
	public JsonRPCErrorObject() {
	}

	/**
	 * @return code
	 * @since 1.0
	 */
	public Integer getCode() {
		return code;
	}

	/**
	 * @param code セットする code
	 * @since 1.0
	 */
	public void setCode(Integer code) {
		this.code = code;
	}

	/**
	 * @return message
	 * @since 1.0
	 */
	public String getMessage() {
		return message;
	}

	/**
	 * @param message セットする message
	 * @since 1.0
	 */
	public void setMessage(String message) {
		this.message = message;
	}

	/**
	 * @return data
	 * @since 1.0
	 */
	public Object getData() {
		return data;
	}

	/**
	 * @param data セットする data
	 * @since 1.0
	 */
	public void setData(Object data) {
		this.data = data;
	}

}
