/*
 * BasicAuthenticationHttpClient.java
 *
 * Copyright 2014 the Monache.org.
 * http://www.monache.org/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.monache.lib.httpclient;

import java.io.IOException;

import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

/**
 * 
 * 
 * @author monache.org
 * @since 1.0
 */
public class BasicAuthenticationHttpClient extends ApacheHttpClient {

	private String user = null;
	private String password = null;
	private int connectionTimeout = 0;
	private int socketTimeout = 0;
	
	private CloseableHttpClient httpClient = null;
	
	/**
	 * 
	 * @throws HttpClientException 
	 * @since 1.0
	 */
	public BasicAuthenticationHttpClient(String host, int port, String user, String password,
			int connectionTimeout, int socketTimeout) throws HttpClientException {
		setHost(host);
		setPort(port);
		setUser(user);
		setPassword(password);
		setConnectionTimeout(connectionTimeout);
		setSocketTimeout(socketTimeout);
		init();
	}

	public BasicAuthenticationHttpClient() {
	}
	
	protected void init() throws HttpClientException{
		getHttpClient();
	}

	public synchronized HttpClient getHttpClient() throws HttpClientException{
		if (httpClient == null) {
			RequestConfig requestConfig = RequestConfig.custom()
					.setConnectTimeout(getConnectionTimeout())
					.setSocketTimeout(getSocketTimeout()).build();
			CredentialsProvider credsProvider = new BasicCredentialsProvider();
			credsProvider.setCredentials(
					new AuthScope(getHost(), getPort()),
					new UsernamePasswordCredentials(getUser(), getPassword()));
			httpClient = HttpClients.custom().setDefaultCredentialsProvider(credsProvider)
					.setDefaultRequestConfig(requestConfig).build();	
		}
		return httpClient;
	}


	/*
	 * (非 Javadoc)
	 * @see org.monache.lib.httpclient.HttpClient#close()
	 * @since 1.0
	 */
	public void close() throws HttpClientException {
		if (httpClient != null) {
			try {
				httpClient.close();
			} catch (IOException e) {
				throw new HttpClientException(e);
			}
		}
	}
	
	/**
	 * @return user
	 * @since 1.0
	 */
	public String getUser() {
		return user;
	}

	/**
	 * @param user セットする user
	 * @since 1.0
	 */
	public void setUser(String user) {
		this.user = user;
	}

	/**
	 * @return password
	 * @since 1.0
	 */
	public String getPassword() {
		return password;
	}

	/**
	 * @param password セットする password
	 * @since 1.0
	 */
	public void setPassword(String password) {
		this.password = password;
	}

	/**
	 * @return connectionTimeout
	 * @since 1.0
	 */
	public int getConnectionTimeout() {
		return connectionTimeout;
	}

	/**
	 * @param connectionTimeout セットする connectionTimeout
	 * @since 1.0
	 */
	public void setConnectionTimeout(int connectionTimeout) {
		this.connectionTimeout = connectionTimeout;
	}

	/**
	 * @return socketTimeout
	 * @since 1.0
	 */
	public int getSocketTimeout() {
		return socketTimeout;
	}

	/**
	 * @param socketTimeout セットする socketTimeout
	 * @since 1.0
	 */
	public void setSocketTimeout(int socketTimeout) {
		this.socketTimeout = socketTimeout;
	}




	
}
