/*
 * AbstractPostParams.java
 *
 * Copyright 2014 the Monache.org.
 * http://www.monache.org/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.monache.lib.httpclient;

import java.nio.charset.Charset;

/**
 * 
 * 
 * @author monache.org
 * @since 1.0
 */
public class AbstractPostParams {

	private String uri = null;
	private String schema = null;
	private Charset responseCharset = null;

	/**
	 * 
	 * @since 1.0
	 */
	public AbstractPostParams() {
	}

	/**
	 * @return uri
	 * @since 1.0
	 */
	public String getUri() {
		return uri;
	}

	/**
	 * @param uri セットする uri
	 * @since 1.0
	 */
	public void setUri(String uri) {
		this.uri = uri;
	}

	/**
	 * @return schema
	 * @since 1.0
	 */
	public String getSchema() {
		return schema;
	}

	/**
	 * @param schema セットする schema
	 * @since 1.0
	 */
	public void setSchema(String schema) {
		this.schema = schema;
	}

	/**
	 * @return responseCharset
	 * @since 1.0
	 */
	public Charset getResponseCharset() {
		return responseCharset;
	}

	/**
	 * @param responseCharset セットする responseCharset
	 * @since 1.0
	 */
	public void setResponseCharset(Charset responseCharset) {
		this.responseCharset = responseCharset;
	}

	
	
}
