/*
 * WalletPassphraseImpl.java
 *
 * Copyright 2014 the Monache.org.
 * http://www.monache.org/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.monache.lib.api.impl;

import org.monache.lib.api.AbstractCoinAPI;
import org.monache.lib.api.CoinAPIException;
import org.monache.lib.api.WalletPassphrase;
import org.monache.lib.api.result.WalletPassphraseResult;
import org.monache.lib.jsonrpc.JsonRPCClient;
import org.monache.lib.jsonrpc.JsonRPCv1RequestObject;
import org.monache.lib.jsonrpc.JsonRPCv1ResponseObject;

/**
 * 
 * 
 * @author monache.org
 * @since 1.0
 */
public class WalletPassphraseImpl extends AbstractCoinAPI implements WalletPassphrase {

	protected static final String METHOD = "walletpassphrase";
	
	/**
	 * 
	 * @since 1.0
	 */
	public WalletPassphraseImpl() {
	}

	/*
	 * (非 Javadoc)
	 * @see org.monache.lib.api.WalletPassphrase#call(org.monache.lib.jsonrpc.JsonRPCClient, java.lang.String, java.lang.Integer)
	 * @since 1.0
	 */
	public WalletPassphraseResult call(JsonRPCClient jsonRPCClient,
			String passphrase, Integer timeout) throws CoinAPIException {

		try {
			if (jsonRPCClient == null) {
				throw new NullPointerException("jsonRPCClient is null.");
			}
			if (passphrase == null) {
				throw new NullPointerException("passphrase is null.");
			}
			if (timeout == null) {
				throw new NullPointerException("timeout is null.");
			}

			// request
			JsonRPCv1RequestObject requestObject = new JsonRPCv1RequestObject();
			requestObject.setMethod(METHOD);
			requestObject.setParams(new Object[]{passphrase, timeout});

			// JSON-RPC call
			JsonRPCv1ResponseObject responseObject = jsonRPCClient.call(requestObject, JsonRPCv1ResponseObject.class);
			
			// Create a GetBalance result object
			WalletPassphraseResult result = new WalletPassphraseResult();
			// JSON string
			result.setJsonString(responseObject.getJsonString());
			return result;

		} catch (Exception e) {
			throw new CoinAPIException("Error: " + e.getMessage(), e);
		}
	}

}
