/*
 * GetNewAddressImpl.java
 *
 * Copyright 2014 the Monache.org.
 * http://www.monache.org/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.monache.lib.api.impl;

import org.monache.lib.api.AbstractCoinAPI;
import org.monache.lib.api.CoinAPIException;
import org.monache.lib.api.GetNewAddress;
import org.monache.lib.api.result.GetNewAddressResult;
import org.monache.lib.jsonrpc.JsonRPCClient;
import org.monache.lib.jsonrpc.JsonRPCv1RequestObject;
import org.monache.lib.jsonrpc.JsonRPCv1ResponseObject;

/**
 * 
 * @author monache.org
 * @since 
 */
public class GetNewAddressImpl extends AbstractCoinAPI implements GetNewAddress {

	protected static final String METHOD = "getnewaddress";

	public GetNewAddressImpl() {
	}

	/*
	 * (非 Javadoc)
	 * @see org.monache.lib.api.GetNewAddress#call(org.monache.lib.jsonrpc.JsonRPCClient)
	 * @since 1.0
	 */
	public GetNewAddressResult call(JsonRPCClient jsonRPCClient) throws CoinAPIException {
		return call(jsonRPCClient, null);
	}

	/*
	 * (非 Javadoc)
	 * @see org.monache.lib.api.GetNewAddress#call(org.monache.lib.jsonrpc.JsonRPCClient, java.lang.String)
	 * @since 1.0
	 */
	public GetNewAddressResult call(JsonRPCClient jsonRPCClient, String account) throws CoinAPIException {
		try {
			if (jsonRPCClient == null) {
				throw new NullPointerException("jsonRPCClient is null.");
			}
			
			// request
			JsonRPCv1RequestObject requestObject = new JsonRPCv1RequestObject();
			requestObject.setMethod(METHOD);
			if (account != null) {
				requestObject.setParams(new Object[]{account});
			}

			// JSON-RPC call
			JsonRPCv1ResponseObject responseObject = jsonRPCClient.call(requestObject, JsonRPCv1ResponseObject.class);
			
			// Create a GetNewAddress result object
			GetNewAddressResult result = new GetNewAddressResult();
			// JSON string
			result.setJsonString(responseObject.getJsonString());
			// created address
			result.setAddress((String)responseObject.getResult());
			return result;

		} catch (Exception e) {
			// JsonRPCException
			throw new CoinAPIException("Error: " + e.getMessage(), e);
		}
	}

}
