/*
 * CoinAPIJsonRPCException.java
 *
 * Copyright 2014 the Monache.org.
 * http://www.monache.org/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package org.monache.lib.api;

import org.monache.lib.jsonrpc.JsonRPCErrorObject;
import org.monache.lib.jsonrpc.JsonRPCException;

/**
 * 
 * 
 * @author monache.org
 * @since 
 */
public class CoinAPIJsonRPCException extends JsonRPCException {

	/**
	 * 
	 */
	private static final long serialVersionUID = -2941429927266211062L;

	/**
	 * 
	 * @since 1.0
	 */
	public CoinAPIJsonRPCException() {
		super();
	}

	/**
	 * @param errorObject
	 * @since 1.0
	 */
	public CoinAPIJsonRPCException(JsonRPCErrorObject errorObject) {
		super(errorObject);
	}

	/**
	 * @param message
	 * @param errorObject
	 * @since 1.0
	 */
	public CoinAPIJsonRPCException(String message,
			JsonRPCErrorObject errorObject) {
		super(message, errorObject);
	}

	/**
	 * @param message
	 * @param cause
	 * @since 1.0
	 */
	public CoinAPIJsonRPCException(String message, Throwable cause) {
		super(message, cause);
	}

	/**
	 * @param message
	 * @since 1.0
	 */
	public CoinAPIJsonRPCException(String message) {
		super(message);
	}

	/**
	 * @param cause
	 * @since 1.0
	 */
	public CoinAPIJsonRPCException(Throwable cause) {
		super(cause);
	}
	

}
