/*
 * Decompiled with CFR 0.152.
 */
package org.monache.lib.api.impl;

import org.monache.lib.api.AbstractCoinAPI;
import org.monache.lib.api.CoinAPIException;
import org.monache.lib.api.WalletLock;
import org.monache.lib.api.result.WalletLockResult;
import org.monache.lib.jsonrpc.JsonRPCClient;
import org.monache.lib.jsonrpc.JsonRPCv1RequestObject;
import org.monache.lib.jsonrpc.JsonRPCv1ResponseObject;

public class WalletLockImpl
extends AbstractCoinAPI
implements WalletLock {
    protected static final String METHOD = "walletlock";

    public WalletLockResult call(JsonRPCClient jsonRPCClient) throws CoinAPIException {
        try {
            if (jsonRPCClient == null) {
                throw new NullPointerException("jsonRPCClient is null.");
            }
            JsonRPCv1RequestObject requestObject = new JsonRPCv1RequestObject();
            requestObject.setMethod(METHOD);
            JsonRPCv1ResponseObject responseObject = jsonRPCClient.call(requestObject, JsonRPCv1ResponseObject.class);
            WalletLockResult result = new WalletLockResult();
            result.setJsonString(responseObject.getJsonString());
            return result;
        }
        catch (Exception e) {
            throw new CoinAPIException("Error: " + e.getMessage(), e);
        }
    }
}

