/*
 * Decompiled with CFR 0.152.
 */
package org.monache.lib.api.impl;

import java.math.BigDecimal;
import org.monache.lib.api.AbstractCoinAPI;
import org.monache.lib.api.CoinAPIException;
import org.monache.lib.api.GetBalance;
import org.monache.lib.api.result.GetBalanceResult;
import org.monache.lib.jsonrpc.JsonRPCClient;
import org.monache.lib.jsonrpc.JsonRPCv1RequestObject;
import org.monache.lib.jsonrpc.JsonRPCv1ResponseObject;

public class GetBalanceImpl
extends AbstractCoinAPI
implements GetBalance {
    protected static final String METHOD = "getbalance";

    public GetBalanceResult call(JsonRPCClient jsonRPCClient) throws CoinAPIException {
        return this.call(jsonRPCClient, null);
    }

    public GetBalanceResult call(JsonRPCClient jsonRPCClient, String account) throws CoinAPIException {
        return this.call(jsonRPCClient, account, null);
    }

    public GetBalanceResult call(JsonRPCClient jsonRPCClient, String account, Integer minconf) throws CoinAPIException {
        try {
            if (jsonRPCClient == null) {
                throw new NullPointerException("jsonRPCClient is null.");
            }
            JsonRPCv1RequestObject requestObject = new JsonRPCv1RequestObject();
            requestObject.setMethod(METHOD);
            if (account != null || minconf != null) {
                if (account != null && minconf == null) {
                    requestObject.setParams(new Object[]{account});
                } else {
                    if (account == null) {
                        account = "*";
                    }
                    requestObject.setParams(new Object[]{account, minconf});
                }
            }
            JsonRPCv1ResponseObject responseObject = jsonRPCClient.call(requestObject, JsonRPCv1ResponseObject.class);
            GetBalanceResult result = new GetBalanceResult();
            result.setJsonString(responseObject.getJsonString());
            result.setBalance((BigDecimal)responseObject.getResult());
            return result;
        }
        catch (Exception e) {
            throw new CoinAPIException("Error: " + e.getMessage(), e);
        }
    }
}

