/*
 * Decompiled with CFR 0.152.
 */
package org.monache.lib.api;

import java.nio.charset.Charset;
import org.monache.lib.api.CoinAPIJsonRPCException;
import org.monache.lib.httpclient.HttpClient;
import org.monache.lib.httpclient.HttpClientException;
import org.monache.lib.httpclient.HttpClientResult;
import org.monache.lib.httpclient.JsonPostParams;
import org.monache.lib.jsonrpc.AbstractJsonRPCClient;
import org.monache.lib.jsonrpc.JsonRPCException;
import org.monache.lib.jsonrpc.JsonRPCv1ResponseObject;
import org.monache.lib.jsonrpc.JsonRPCv2ResponseObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoinAPIJsonRPCClient
extends AbstractJsonRPCClient {
    private String uri = null;
    private String schema = null;
    private Charset responseCharset = null;
    private HttpClient httpClient = null;
    public static final String DEFAULT_URI = "/";
    public static final String DEFAULT_SCHEMA = "http";
    public static final Charset DEFAULT_RESPONSE_CHARSET = null;

    public CoinAPIJsonRPCClient() throws JsonRPCException {
        this(null, null, null, null);
    }

    public CoinAPIJsonRPCClient(HttpClient httpClient) throws JsonRPCException {
        this(httpClient, null, null, null);
    }

    public CoinAPIJsonRPCClient(HttpClient httpClient, String uri, String schema, Charset responseCharset) throws JsonRPCException {
        this.setHttpClient(httpClient);
        this.setUri(uri);
        this.setSchema(schema);
        this.setResponseCharset(responseCharset);
    }

    @Override
    protected String request(String jsonRequestString) throws JsonRPCException {
        try {
            if (this.getHttpClient() == null) {
                throw new NullPointerException("HttpClient is null.");
            }
            JsonPostParams postParams = new JsonPostParams();
            postParams.setUri(this.getUri() != null ? this.getUri() : DEFAULT_URI);
            postParams.setSchema(this.getSchema() != null ? this.getSchema() : DEFAULT_SCHEMA);
            postParams.setData(jsonRequestString);
            postParams.setResponseCharset(this.getResponseCharset() != null ? this.getResponseCharset() : DEFAULT_RESPONSE_CHARSET);
            HttpClientResult result = this.getHttpClient().post(postParams);
            return result.getContent();
        }
        catch (Exception e) {
            throw new CoinAPIJsonRPCException("JSON-RPC error: " + e.getMessage(), e);
        }
    }

    @Override
    public <T1, T2> T2 call(T1 requestObject, Class<? extends T2> responseObjectClass) throws JsonRPCException {
        JsonRPCv2ResponseObject responseObject2;
        T2 responseObject = super.call(requestObject, responseObjectClass);
        if (responseObject instanceof JsonRPCv1ResponseObject) {
            JsonRPCv1ResponseObject responseObject22 = (JsonRPCv1ResponseObject)responseObject;
            if (responseObject22.getError() != null) {
                throw new CoinAPIJsonRPCException("Server return error, code = " + responseObject22.getError().getCode() + ", message = " + responseObject22.getError().getMessage(), responseObject22.getError());
            }
        } else if (responseObject instanceof JsonRPCv2ResponseObject && (responseObject2 = (JsonRPCv2ResponseObject)responseObject).getError() != null) {
            throw new CoinAPIJsonRPCException("Server return error, code = " + responseObject2.getError().getCode() + ", message = " + responseObject2.getError().getMessage(), responseObject2.getError());
        }
        return responseObject;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public Charset getResponseCharset() {
        return this.responseCharset;
    }

    public void setResponseCharset(Charset responseCharset) {
        this.responseCharset = responseCharset;
    }

    @Override
    public void close() throws JsonRPCException {
        if (this.getHttpClient() != null) {
            try {
                this.getHttpClient().close();
            }
            catch (HttpClientException e) {
                throw new CoinAPIJsonRPCException(e);
            }
        }
    }
}

