#!/bin/bash
# Make One Linux on Linux File System
# Written by Keicho Kondo 2006.04.03
# Contact: dgel@users.sourceforge.jp
# License GPL

# ChangeLog
# 2006-10-10 Keicho Kondo
# - Added noeject option.
# 2006-04-03 Keicho Kondo
# - Modify setup.bat called from install2win.bat for Linux System.

# get information from Make One Linux System
MOLFLAG="${0%/*}/MOLFLAG"
if [ -f "${MOLFLAG}" ]
then
	. ${MOLFLAG}
else
	MOLVERSION="x.x.x"
	KERNEL_RELEASE="mol-${MOLVERSION}"
fi

# set kernel and initrd information
KERNEL="/boot/vmlinuz-${KERNEL_RELEASE}"
INITRD="/boot/initrd-mol-${MOLVERSION}.img"

# set title
OLTITLE="MakeOneLinux ${MOLVERSION} (Overlaying Mode)"
ROTITLE="MakeOneLinux ${MOLVERSION} (Read-Only Mode)"

# set options
OLOPTIONS="root=/dev/root boot=overlay rwdevice=ramdisk noeject selinux=0"
ROOPTIONS="root=/dev/root boot=romode rwdevice=ramdisk noeject selinux=0"

# configure boot loader
grubby --copy-default --add-kernel=${KERNEL} --title="${OLTITLE}" --args="${OLOPTIONS}" --initrd="${INITRD}" >/dev/null 2>&1
grubby --copy-default --add-kernel=${KERNEL} --title="${ROTITLE}" --args="${ROOPTIONS}" --initrd="${INITRD}" >/dev/null 2>&1

