%define version 0.13.2

Summary: CHTML to HDML,XHTML,JHTML convert module for Apache HTTPD.
Name:  mod_chxj
Version:  %{version}
Release:  1
License:  Apache License Version 2.0
Group: System Environment/Daemons
Vendor: Atsushi Konno
URL: http://sourceforge.jp/projects/modchxj/
Source:  http://sourceforge.jp/projects/modchxj/downloads/33637/mod-chxj_%{version}.src.tar.gz
Source1: http://launchpad.net/libmemcached/1.0/0.47/+download/libmemcached-0.47.tar.gz
Packager:  Atsushi Konno <konn@users.sourceforge.jp>
Requires: ImageMagick >= 6.2.8.0, httpd >= 2.2.3, apr >= 1.2.7, apr-util >= 1.2.7, mysql >= 5.0.22, openssl >= 0.9.8
BuildPreReq: mysql-devel httpd-devel ImageMagick-devel gcc-c++ libtool openssl-devel

%description
The contents conversion middleware for domestic main carrying (three careers)
is made as a module for Apache2.0. UserAgent is seen when contents made with
CHTML are output and it converts it into HDML, XHTML, and JHTML (The image :
to JPG, GIF, JPG, GIF from PNG, and PNG and BMP). With QR code generation
function.

%prep
cd $RPM_BUILD_DIR
rm -rf libmemcached-0.47
/bin/gzip -dc $RPM_SOURCE_DIR/libmemcached-0.47.tar.gz | tar -xf -
STATUS=$?
if [ $STATUS -ne 0 ]; then
  exit $STATUS
fi
cd libmemcached-0.47
./configure --with-pic --enable-static
make
%setup -q -n mod-chxj_%{version}

%build
./configure --enable-mysql-cookie \
            --with-mysql-header=/usr/include/mysql  \
            --with-mysql-lib-dir=/usr/lib/mysql \
            --enable-memcache-cookie \
            --with-memcached-header=%{_topdir}/BUILD/libmemcached-0.47 \
            --with-memcached-lib-dir=%{_topdir}/BUILD/libmemcached-0.47/libmemcached/.libs \
            --enable-memcached-static
%{__make}

%install
%{__rm} -rf $RPM_BUILD_ROOT
%{__mkdir} -p $RPM_BUILD_ROOT%{_sysconfdir}/httpd/conf.d
%{__mkdir} -p $RPM_BUILD_ROOT%{_sysconfdir}/httpd/chxj
%{__mkdir} -p $RPM_BUILD_ROOT%{_libdir}/httpd/modules
%{__install} -m0644 support/centos/chxj.conf $RPM_BUILD_ROOT%{_sysconfdir}/httpd/conf.d/chxj.conf
%{__install} -m0644 etc/emoji.xml $RPM_BUILD_ROOT%{_sysconfdir}/httpd/chxj/emoji.xml
%{__install} -m0644 etc/device_data.xml $RPM_BUILD_ROOT%{_sysconfdir}/httpd/chxj/device_data.xml
%{__make} -C src make_so
%{__install} -m0755 src/mod_chxj.so $RPM_BUILD_ROOT%{_libdir}/httpd/modules/mod_chxj.so

%files
%defattr(-, root, root)
%doc AUTHORS ChangeLog COPYING
%config(noreplace) %{_sysconfdir}/httpd/conf.d/chxj.conf
%config(noreplace) %{_sysconfdir}/httpd/chxj/emoji.xml
%config(noreplace) %{_sysconfdir}/httpd/chxj/device_data.xml
%{_libdir}/httpd/modules/mod_chxj.so

%changelog
* Fri Mar 4 2011 Atsushi Konno <konn@users.sourceforge.jp> 0.13.0
- Changed libmemcached version.
* Fri Nov  7 2008 Atsushi Konno <konn@users.sourceforge.jp> 0.12.17-1
- Added initial package for CentOS5.1.
