/*
 * Copyright (C) 2005-2008 Atsushi Konno All rights reserved.
 * Copyright (C) 2005 QSDN,Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include "chxj_qr_code.h"
#include "chxj_calc_ecc.h"
#include "apr.h"
#include "apr_strings.h"
#include "http_log.h"
#include <assert.h>
/*
#define QR_CODE_DEBUG
*/

/*----------------------------------------------------------------------------*/
/* ؿ                                                                 */
/*----------------------------------------------------------------------------*/
static const unsigned int v_galois_log_to_int[] = {
  1, 2, 4, 8, 16, 32, 64, 128,
  29, 58, 116, 232, 205, 135, 19, 38,
  76, 152, 45, 90, 180, 117, 234, 201,
  143, 3, 6, 12, 24, 48, 96, 192,
  157, 39, 78, 156, 37, 74, 148, 53,
  106, 212, 181, 119, 238, 193, 159, 35,
  70, 140, 5, 10, 20, 40, 80, 160,
  93, 186, 105, 210, 185, 111, 222, 161,
  95, 190, 97, 194, 153, 47, 94, 188,
  101, 202, 137, 15, 30, 60, 120, 240,
  253, 231, 211, 187, 107, 214, 177, 127,
  254, 225, 223, 163, 91, 182, 113, 226,
  217, 175, 67, 134, 17, 34, 68, 136,
  13, 26, 52, 104, 208, 189, 103, 206,
  129, 31, 62, 124, 248, 237, 199, 147,
  59, 118, 236, 197, 151, 51, 102, 204,
  133, 23, 46, 92, 184, 109, 218, 169,
  79, 158, 33, 66, 132, 21, 42, 84,
  168, 77, 154, 41, 82, 164, 85, 170,
  73, 146, 57, 114, 228, 213, 183, 115,
  230, 209, 191, 99, 198, 145, 63, 126,
  252, 229, 215, 179, 123, 246, 241, 255,
  227, 219, 171, 75, 150, 49, 98, 196,
  149, 55, 110, 220, 165, 87, 174, 65,
  130, 25, 50, 100, 200, 141, 7, 14,
  28, 56, 112, 224, 221, 167, 83, 166,
  81, 162, 89, 178, 121, 242, 249, 239,
  195, 155, 43, 86, 172, 69, 138, 9,
  18, 36, 72, 144, 61, 122, 244, 245,
  247, 243, 251, 235, 203, 139, 11, 22,
  44, 88, 176, 125, 250, 233, 207, 131,
  27, 54, 108, 216, 173, 71, 142, 1,
  2, 4, 8, 16, 32, 64, 128, 29,
  58, 116, 232, 205, 135, 19, 38, 76,
  152, 45, 90, 180, 117, 234, 201, 143,
  3, 6, 12, 24, 48, 96, 192, 157,
  39, 78, 156, 37, 74, 148, 53, 106,
  212, 181, 119, 238, 193, 159, 35, 70,
  140, 5, 10, 20, 40, 80, 160, 93,
  186, 105, 210, 185, 111, 222, 161, 95,
  190, 97, 194, 153, 47, 94, 188, 101,
  202, 137, 15, 30, 60, 120, 240, 253,
  231, 211, 187, 107, 214, 177, 127, 254,
  225, 223, 163, 91, 182, 113, 226, 217,
  175, 67, 134, 17, 34, 68, 136, 13,
  26, 52, 104, 208, 189, 103, 206, 129,
  31, 62, 124, 248, 237, 199, 147, 59,
  118, 236, 197, 151, 51, 102, 204, 133,
  23, 46, 92, 184, 109, 218, 169, 79,
  158, 33, 66, 132, 21, 42, 84, 168,
  77, 154, 41, 82, 164, 85, 170, 73,
  146, 57, 114, 228, 213, 183, 115, 230,
  209, 191, 99, 198, 145, 63, 126, 252,
  229, 215, 179, 123, 246, 241, 255, 227,
  219, 171, 75, 150, 49, 98, 196, 149,
  55, 110, 220, 165, 87, 174, 65, 130,
  25, 50, 100, 200, 141, 7, 14, 28,
  56, 112, 224, 221, 167, 83, 166, 81,
  162, 89, 178, 121, 242, 249, 239, 195,
  155, 43, 86, 172, 69, 138, 9, 18,
  36, 72, 144, 61, 122, 244, 245, 247,
  243, 251, 235, 203, 139, 11, 22, 44,
  88, 176, 125, 250, 233, 207, 131, 27,
  54, 108, 216, 173, 71, 142, 1, 0,
};

/*----------------------------------------------------------------------------*/
/* ؿ                                                                 */
/*----------------------------------------------------------------------------*/
static const unsigned int v_galois_int_to_log[] = {
  0, 0, 1, 25, 2, 50, 26, 198, 3,
  223, 51, 238, 27, 104, 199, 75, 4,
  100, 224, 14, 52, 141, 239, 129, 28,
  193, 105, 248, 200, 8, 76, 113, 5,
  138, 101, 47, 225, 36, 15, 33, 53,
  147, 142, 218, 240, 18, 130, 69, 29,
  181, 194, 125, 106, 39, 249, 185, 201,
  154, 9, 120, 77, 228, 114, 166, 6,
  191, 139, 98, 102, 221, 48, 253, 226,
  152, 37, 179, 16, 145, 34, 136, 54,
  208, 148, 206, 143, 150, 219, 189, 241,
  210, 19, 92, 131, 56, 70, 64, 30,
  66, 182, 163, 195, 72, 126, 110, 107,
  58, 40, 84, 250, 133, 186, 61, 202,
  94, 155, 159, 10, 21, 121, 43, 78,
  212, 229, 172, 115, 243, 167, 87, 7,
  112, 192, 247, 140, 128, 99, 13, 103,
  74, 222, 237, 49, 197, 254, 24, 227,
  165, 153, 119, 38, 184, 180, 124, 17,
  68, 146, 217, 35, 32, 137, 46, 55,
  63, 209, 91, 149, 188, 207, 205, 144,
  135, 151, 178, 220, 252, 190, 97, 242,
  86, 211, 171, 20, 42, 93, 158, 132,
  60, 57, 83, 71, 109, 65, 162, 31,
  45, 67, 216, 183, 123, 164, 118, 196,
  23, 73, 236, 127, 12, 111, 246, 108,
  161, 59, 82, 41, 157, 85, 170, 251,
  96, 134, 177, 187, 204, 62, 90, 203,
  89, 95, 176, 156, 169, 160, 81, 11,
  245, 22, 235, 122, 117, 44, 215, 79,
  174, 213, 233, 230, 231, 173, 232, 116,
  214, 244, 234, 168, 80, 88, 175, 
};

/*----------------------------------------------------------------------------*/
/* ¿༰ - ɿ7 򤢤魯                                  */
/* x^7 + ^87x^6 + ^229x^5 + ^146x^4 + ^149x^3 + ^238x^2 + ^102x   */
/* + ^21                                                                    */
/* Φλؿˤ                                                     */
/*----------------------------------------------------------------------------*/
static const int v_poly_ecc7[] = {
  21, 102,238,149,146,229,87,0,
};
/*----------------------------------------------------------------------------*/
/* ¿༰ - ɿ10 򤢤魯                                 */
/* JIS X0510 : x10ܦ251x9ܦ67x8ܦ61x6ܦ118x5ܦ70x4ܦ64x3        */
/*             94x2ܦ32xܦ45                                            */
/* :       x10ܦ251x9ܦ67x8ܦ46x7ܦ61x6ܦ118x5ܦ70x4        */
/*             64x3ܦ94x2ܦ32xܦ45                                    */
/* JIS X510Ǥx7ιब¸ߤʤ                                           */
/*----------------------------------------------------------------------------*/
static const int v_poly_ecc10[] = {
  45, 32, 94, 64, 70, 118, 61, 46, 67, 251, 0,
};

/*----------------------------------------------------------------------------*/
/* ¿༰ - ɿ13 򤢤魯                                 */
/*----------------------------------------------------------------------------*/
static const int v_poly_ecc13[] = {
  78, 140, 206, 218, 130, 104, 106, 100,
  86, 100, 176, 152, 74, 0,
};
/*----------------------------------------------------------------------------*/
/* ¿༰ - ɿ15 򤢤魯                                 */
/*----------------------------------------------------------------------------*/
static const int v_poly_ecc15[] = {
  105, 99, 5, 124, 140, 237, 58, 58, 
  51, 37, 202, 91, 61, 183, 8, 0,
};
/*----------------------------------------------------------------------------*/
/* ¿༰ - ɿ16 򤢤魯                                 */
/*----------------------------------------------------------------------------*/
static const int v_poly_ecc16[] = {
  120, 225, 194, 182, 169, 147, 191, 91,
  3, 76, 161, 102, 109, 107, 104, 120, 0,
};
/*----------------------------------------------------------------------------*/
/* ¿༰ - ɿ17 򤢤魯                                 */
/*----------------------------------------------------------------------------*/
static const int v_poly_ecc17[] = {
  136,163,243,39,150,99,24,147,214,206,
  123,239,43,78,206,139,43,0,
};
/*----------------------------------------------------------------------------*/
/* ¿༰ - ɿ18 򤢤魯                                 */
/*----------------------------------------------------------------------------*/
static const int v_poly_ecc18[] = {
  153, 96, 98, 5, 179, 252, 148, 152,
  187, 79, 170, 118, 97, 184, 94, 158,
  234, 215, 0,
};
/*----------------------------------------------------------------------------*/
/* ¿༰ - ɿ20 򤢤魯                                 */
/*----------------------------------------------------------------------------*/
static const int v_poly_ecc20[] = {
  190, 188, 212, 212, 164, 156, 239, 83,
  225, 221, 180, 202, 187, 26, 163, 61,
  50, 79, 60, 17, 0,
};
/*----------------------------------------------------------------------------*/
/* ¿༰ - ɿ22 򤢤魯                                 */
/* x22ܦ210x21ܦ171x20ܦ247x19ܦ242x18ܦ93x17ܦ230x16ܦ14x15  */
/* 109x14ܦ221x13ܦ53x12ܦ200x11ܦ74x10ܦ8x9ܦ172x8ܦ98x7   */
/* 80x6ܦ219x5ܦ134x4ܦ160x3ܦ105x2ܦ165xܦ231                  */
/*----------------------------------------------------------------------------*/
static const int v_poly_ecc22[] = {
  231, 165, 105, 160, 134, 219, 80, 98,
  172, 8, 74, 200, 53, 221, 109, 14, 
  230, 93, 242, 247, 171, 210, 0,
};

/*----------------------------------------------------------------------------*/
/* ¿༰ - ɿ24 򤢤魯                                 */
/* x24 229x23 121x22 135x21 48x20 211x19 117x18     */
/* 251x17ܦ126x16ܦ159x15 180x14 169x13 152x12 192x11 */
/* 226x10 228x9 218x8 111x7x6 117x5 232x4 87x3  */
/* 96x2 227x 21                                                     */
/*----------------------------------------------------------------------------*/
static const int v_poly_ecc24[] = {
  21, 227, 96, 87, 232, 117, 0, 111,
  218, 228, 226, 192, 152, 169, 180, 159,
  126, 251, 117, 211, 48, 135, 121, 229,
  0,
};

/*----------------------------------------------------------------------------*/
/* ¿༰ - ɿ26 򤢤魯                                 */
/*----------------------------------------------------------------------------*/
static const int v_poly_ecc26[] = {
  70, 218, 145, 153, 227, 48, 102, 13,
  142, 245, 21, 161, 53, 165, 28, 111,
  201, 145, 17, 118, 182, 103, 2, 158,
  125, 173, 0,
};
/*----------------------------------------------------------------------------*/
/* ¿༰ - ɿ28 򤢤魯                                 */
/* x28 168x27 223x26 200x25 104x24 224x23 234x22    */
/* 108x21 180x20  110x19 190x18 195x17 147x16         */
/* 205x15 27x14 232x13 201x12  21x11 43x10 245x9  */
/* 87x8 42x7 195x6 212x5 119x4 242x3 37x2 9x  */
/* 123                                                                      */
/*----------------------------------------------------------------------------*/
static const int v_poly_ecc28[] = {
  123, 9, 37, 242, 119, 212, 195, 42,
  87, 245, 43, 21, 201, 232, 27, 205,
  147, 195, 190, 110, 180, 108, 234, 224,
  104, 200, 223, 168, 0,
};
/*----------------------------------------------------------------------------*/
/* ¿༰ - ɿ30 򤢤魯                                 */
/* x30 41x29 173x28 145x27 152x26 216x25 31x24      */
/* 179x23 182x22  50x21 48x20 110x19 86x18 239x17 */
/* 96x16 222x15 125x14 42x13 173x12 226x11 193x10 */
/* 224x9 130x8 156x7 37x6 251x5  216x4 238x3      */
/* 40x2 192x 180                                                    */
/*----------------------------------------------------------------------------*/
static const int v_poly_ecc30[] = {
  180, 192, 40, 238, 216, 251, 37, 156,
  130, 224, 193, 226, 173, 42, 125, 222,
  96, 239, 86, 110, 48, 50, 182, 179,
  31, 216, 152, 145, 173, 41, 0,
};
/*----------------------------------------------------------------------------*/
/* ¿༰ - ɿ32 򤢤魯                                 */
/* x32 10x31 6x30 106x29 190x28 249x27 167x26       */
/* 4x25 67x24 209x23  138x22  138x21  32x20  242x19 */
/*  123x18  89x17  27x16  120x15  185x14 80x13      */
/* 156x12 38x11 60x10 171x9 60x8 28x7 222x6       */
/* 80x5ܦ52x4 254x3 185x2 220x 241                        */
/*----------------------------------------------------------------------------*/
static const int v_poly_ecc32[] = {
  241, 220, 185, 254, 52, 80, 222, 28,
  60, 171, 60, 38, 156, 80, 185, 120,
  27, 89, 123, 242, 32, 138, 138, 209,
  67, 4, 167, 249, 190, 106, 6, 10, 
  0,
};
/*----------------------------------------------------------------------------*/
/* ¿༰ - ɿ34 򤢤魯                                 */
/* x34 111x33 77x32 146x31 94x30 26x29 21x28        */
/* 108x27 19x26 105x25 94x24 113x23 193x22 86x21  */
/* 140x20 163x19 125x18 58x17  158x16 229x15          */
/* 239x14 218x13 103x12 56x11 70x10 114x9 61x8    */
/* 183x7 129x6 167x5 13x4 98x3 62x2 129x 51     */
/*----------------------------------------------------------------------------*/
static const int v_poly_ecc34[] = {
  51, 129, 62, 98, 13, 167, 129, 183,
  61, 114, 70, 56, 103, 218, 239, 229,
  158, 58, 125, 163, 140, 86, 193, 113,
  94, 105, 19, 108, 21, 26, 94, 146,
  77, 111, 0,
};
/*----------------------------------------------------------------------------*/
/* ¿༰ - ɿ36 򤢤魯                                 */
/* x36 200x35 183x34 98x33 16x32 172x31 31x30       */
/* 246x29 234x28  60x27  152x26  115x25  x24  167x23  */
/*  152x22  113x21  248x20 ܦ238x19  107x18  18x17    */
/* 63x16  218x15  37x14  87x13  210x12 ܦ105x11           */
/*  177x10 120x9 74x8 121x7 196x6 117x5 251x4   */
/* 113x3 233x2  30x 120                                         */
/*----------------------------------------------------------------------------*/
static const int v_poly_ecc36[] = {
  120, 30, 233, 113, 251, 117, 196, 121,
  74, 120, 177, 105, 210, 87, 37, 218,
  63, 18, 107, 238, 248, 113, 152, 167,
  0, 115, 152, 60, 234, 246, 31, 172,
  16, 98, 183, 200, 0,
};
/*----------------------------------------------------------------------------*/
/* ¿༰ - ɿ40 򤢤魯                                 */
/* x40 59x39 116x38 79x37 161x36 252x35 98x34       */
/* 128x33 205x32  128x31 161x30 247x29 57x28          */
/* 163x27 56x26 235x25 106x24  53x23 26x22 187x21 */
/* 174x20 226x19 104x18 170x17 7x16  175x15  35x14*/
/* 181x13  114x12  88x11  41x10  47x9  163x8          */
/* 125x7 134x6 72x5 20x4 232x3 53x2 35x 15      */
/*----------------------------------------------------------------------------*/
static const int v_poly_ecc40[] = {
  15, 35, 53, 232, 20, 72, 134, 125,
  163, 47, 41, 88, 114, 181, 35, 175,
  7, 170, 104, 226, 174, 187, 26, 53,
  106, 235, 56, 163, 57, 247, 161, 128,
  205, 128, 98, 252, 161, 79, 116, 59,
  0,
};
/*----------------------------------------------------------------------------*/
/* ¿༰ - ɿ42 򤢤魯                                 */
/* x42 250x41 103x40 221x39 230x38 25x37 18x36      */
/* 137x35 231x34 x33 3x32 58x31 242x30 221x29       */
/* 191x28 110x27 84x26 230x25 8x24  188x23  106x22*/
/* 96x21  147x20  15x19  131x18  139x17  34x16        */
/* 101x15  223x14  39x13  101x12  213x11  199x10      */
/* 237x9  254x8 201x7 123x6 171x5 162x4 194x3     */
/* 117x2 50x 96                                                     */
/*----------------------------------------------------------------------------*/
static const int v_poly_ecc42[] = {
  96, 50, 117, 194, 162, 171, 123, 201,
  254, 237, 199, 213, 101, 39, 223, 101,
  34, 139, 131, 15, 147, 96, 106, 188,
  8, 230, 84, 110, 191, 221, 242, 58,
  3, 0, 231, 137, 18, 25, 230, 221,
  103, 250, 0,
};
/*----------------------------------------------------------------------------*/
/* ¿༰ - ɿ44 򤢤魯                                 */
/* x44 190x43 7x42 61x41 121x40 71x39 246x38        */
/* 69x37 55x36 168x35  188x34  89x33  243x32          */
/* 191x31  25x30  72x29  123x28  9x27 145x26 14x25*/
/* 247x24 x23 238x22 44x21 78x20 143x19  62x18    */
/* 224x17 126x16 118x15 114x14 68x13 163x12 52x11 */
/* 194x10 217x9  147x8 204x7 169x6 37x5 130x4     */
/* 113x3 102x2 73x 181                                          */
/*----------------------------------------------------------------------------*/
static const int v_poly_ecc44[] = {
  181,  73, 102, 113, 130,  37, 169, 204,
  147, 217, 194,  52, 163,  68, 114, 118, 
  126, 224,  62, 143,  78,  44, 238,   1,
  247,  14, 145,   9, 123,  72,  25, 191,
  243,  89, 188, 168,  55,  69, 246,  71,
  121,  61,   7, 190,   0,
};
/*----------------------------------------------------------------------------*/
/* ¿༰ - ɿ46 򤢤魯                                 */
/* x46 112x45 94x44 88x43 112x42 253x41 224x40      */
/* 202x39 115x38  187x37  99x36  89x35  5x34  54x33 */
/*  113x32  129x31  44x30  58x29 16x28 135x27       */
/* 216x26 169x25 211x24 36x23 x22 4x21 96x20      */
/* 60x19 241x18 73x17 104x16 234x15 8x14 249x13   */
/* 245x12  119x11 174x10 52x9 25x8 157x7 224x6    */
/* 43x5 202x4 223x3  19x2 82x 15                        */
/*----------------------------------------------------------------------------*/
static const int v_poly_ecc46[] = {
   15,  82,  19, 223, 202,  43, 224, 157,
   25,  52, 174, 119, 245, 249,   8, 234,
  104,  73, 241,  60,  96,   4,   1,  36,
  211, 169, 216, 135,  16,  58,  44, 129,
  113,  54,   5,  89,  99, 187, 115, 202,
  224, 253, 112,  88,  94, 112,   0,
};
/*----------------------------------------------------------------------------*/
/* ¿༰ - ɿ48 򤢤魯                                 */
/* x48 228x47 25x46 196x45 130x44 211x43 146x42     */
/* 60x41 24x40  251x39 90x38 39x37 102x36 240x35  */
/* 61x34 178x33 63x32 46x31  123x30 115x29  18x28 */
/*  221x27  111x26  135x25  160x24  182x23  205x22    */
/* 107x21 206x20 95x19 150x18 120x17 184x16 91x15   */
/*  21x14  247x13  156x12  140x11  238x10  191x9    */
/* 11x8  94x7  227x6 84x5 50x4 163x3 39x2 34x */
/* 108                                                                      */
/*----------------------------------------------------------------------------*/
static const int v_poly_ecc48[] = {
  108,  34,  39, 163,  50,  84, 227,  94,
   11, 191, 238, 140, 156, 247,  21,  91,
  184, 120, 150,  95, 206, 107, 205, 182,
  160, 135, 111, 221,  18, 115, 123,  46,
   63, 178,  61, 240, 102,  39,  90, 251,
   24,  60, 146, 211, 130, 196,  25, 228,
    0,
};
/*----------------------------------------------------------------------------*/
/* ¿༰ - ɿ50 򤢤魯                                 */
/* x50 232x49 125x48 157x47 161x46 164x45 9x44      */
/* 118x43 46x42  209x41 99x40 203x39 193x38 35x37 */
/* 3x36 209x35 111x34  195x33 242x32 203x31 225x30*/
/* 46x29 13x28 32x27 160x26  126x25 209x24 130x23 */
/* 160x22 242x21 215x20 242x19 75x18  77x17 42x16 */
/* 189x15 32x14 113x13 65x12 124x11 69x10 228x9   */
/* 114x8 235x7 175x6 124x5 170x4 215x3 232x2      */
/* 133x 205                                                             */
/*----------------------------------------------------------------------------*/
static const int v_poly_ecc50[] = {
  205, 133, 232, 215, 170, 124, 175, 235,
  114, 228,  69, 124,  65, 113,  32, 189,
   42,  77,  75, 242, 215, 242, 160, 130,
  209, 126, 160,  32,  13,  46, 225, 203,
  242, 195, 111, 209,   3,  35, 193, 203,
   99, 209,  46, 118,   9, 164, 161, 157,
  125, 232, 0,
};
/*----------------------------------------------------------------------------*/
/* ¿༰ - ɿ52 򤢤魯                                 */
/* x52 116x51 50x50 86x49 186x48 50x47 220x46       */
/* 251x45 89x44  192x43 46x42 86x41 127x40 124x39 */
/* 19x38 184x37 233x36  151x35 215x34 22x33 14x32 */
/* 59x31 145x30 37x29 242x28  203x27 134x26 254x25*/
/* 89x24 190x23 94x22 59x21 65x20  124x19 113x18  */
/* 100x17 233x16 235x15 121x14 22x13 76x12  86x11 */
/* 97x10 39x9 242x8 200x7 220x6 101x5 33x4        */
/* 239x3  254x2 116x 51                                           */
/*----------------------------------------------------------------------------*/
static const int v_poly_ecc52[] = {
   51, 116, 254, 239,  33, 101, 220, 200,
  242,  39,  97,  86,  76,  22, 121, 235,
  233, 100, 113, 124,  65,  59,  94, 190,
   89, 254, 134, 203, 242,  37, 145,  59,
   14,  22, 215, 151, 233, 184,  19, 124,
  127,  86,  46, 192,  89, 251, 220,  50,
  186,  86,  50, 116,   0,
};
/*----------------------------------------------------------------------------*/
/* ¿༰ - ɿ54 򤢤魯                                 */
/* x54 183x53 26x52 201x51 87x50 210x49 221x48      */
/* 113x47 21x46  46x45 65x44 45x43 50x42 238x41   */
/* 184x40 249x39 225x38   102x37 58x36 209x35         */
/* 218x34 109x33 165x32 26x31 95x30   184x29          */
/* 192x28 52x27 245x26 35x25 254x24 238x23 175x22   */
/*  172x21 79x20 123x19 25x18 122x17 43x16          */
/* 120x15 108x14  215x13 80x12 128x11 201x10          */
/* 235x9 8x8 153x7 59x6 101x5  31x4 198x3         */
/* 76x2 31x 156                                                     */
/*----------------------------------------------------------------------------*/
static const int v_poly_ecc54[] = {
  156,  31,  76, 198,  31, 101,  59, 153,
    8, 235, 201, 128,  80, 215, 108, 120,
   43, 122,  25, 123,  79, 172, 175, 238,
  254,  35, 245,  52, 192, 184,  95,  26,
  165, 109, 218, 209,  58, 102, 225, 249,
  184, 238,  50,  45,  65,  46,  21, 113,
  221, 210,  87, 201,  26, 183,   0,
};
/*----------------------------------------------------------------------------*/
/* ¿༰ - ɿ56 򤢤魯                                 */
/* x56ܦ106x55ܦ120x54ܦ107x53ܦ157x52ܦ164x51ܦ216x50          */
/* 112x49ܦ116x48ܦ2x47ܦ91x46ܦ248x45ܦ163x44ܦ36x43         */
/* 201x42ܦ202x41ܦ229x40ܦ6x39ܦ144x38ܦ254x37ܦ155x36       */
/* 135x35ܦ208x34ܦ170x33ܦ209x32ܦ12x31 ܦ139x30               */
/* 127x29ܦ142x28ܦ182x27ܦ249x26ܦ177x25ܦ174x24               */
/* 190x23ܦ28x22ܦ10x21ܦ85x20ܦ239x19ܦ184x18ܦ101x17        */
/* 124x16ܦ152x15ܦ206x14ܦ96x13ܦ23x12ܦ163x11ܦ61x10        */
/* 27x9ܦ196x8ܦ247x7ܦ151x6ܦ154x5ܦ202x4ܦ207x3             */
/* 20x2ܦ61xܦ10                                                        */
/*----------------------------------------------------------------------------*/
static const int v_poly_ecc56[] = {
   10,  61,  20, 207, 202, 154, 151, 247,
  196,  27,  61, 163,  23,  96, 206, 152,
  124, 101, 184, 239,  85,  10,  28, 190,
  174, 177, 249, 182, 142, 127, 139,  12,
  209, 170, 208, 135, 155, 254, 144,   6,
  229, 202, 201,  36, 163, 248,  91,   2,
  116, 112, 216, 164, 157, 107, 120, 106,
    0,
};
/*----------------------------------------------------------------------------*/
/* ¿༰ - ɿ58 򤢤魯                                 */
/* x58 82x57 116x56 26x55 247x54 66x53 27x52        */
/* 62x51 107x50 252x49 182x48 200x47 185x46           */
/* 235x45 55x44 251x43 242x42 210x41  144x40          */
/* 154x39 237x38 176x37 141x36 192x35 248x34          */
/* 152x33  249x32 206x31 85x30 253x29 142x28          */
/* 65x27 165x26 125x25  23x24 24x23 30x22 122x21  */
/* 240x20 214x19 6x18 129x17 218x16 29x15 145x14  */
/* 127x13 134x12 206x11 245x10 117x9 29x8 41x7    */
/* 63x6 159x5 142x4 233x3 125x2 148x 123            */
/*----------------------------------------------------------------------------*/
static const int v_poly_ecc58[] = {
  123, 148, 125, 233, 142, 159,  63,  41,
   29, 117, 245, 206, 134, 127, 145,  29,
  218, 129,   6, 214, 240, 122,  30,  24,
   23, 125, 165,  65, 142, 253,  85, 206,
  249, 152, 248, 192, 141, 176, 237, 154,
  144, 210, 242, 251,  55, 235, 185, 200,
  182, 252, 107,  62,  27,  66, 247,  26,
  116,  82,   0,
};
/*----------------------------------------------------------------------------*/
/* ¿༰ - ɿ60 򤢤魯                                 */
/* x60 107x59 140x58 26x57 12x56 9x55 141x54        */
/* 243x53 197x52  226x51 197x50 219x49 45x48          */
/* 211x47 101x46 219x45 120x44 28x43 181x42           */
/* 127x41 6x40 100x39 247x38 2x37 205x36 198x35   */
/* 57x34 115x33 219x32 101x31 109x30 160x29 82x28 */
/* 37x27 38x26 238x25 49x24 160x23 209x22 121x21  */
/* 86x20 11x19  124x18 30x17 181x16 84x15 25x14   */
/* 194x13 87x12 65x11 102x10 190x9 220x8 70x7     */
/* 27x6 209x5 16x4 89x3 7x2 33x  240                */
/*----------------------------------------------------------------------------*/
static const int v_poly_ecc60[] = {
  240,  33,   7,  89,  16, 209,  27,  70,
  220, 190, 102,  65,  87, 194,  25,  84,
  181,  30, 124,  11,  86, 121, 209, 160,
   49, 238,  38,  37,  82, 160, 109, 101,
  219, 115,  57, 198, 205,   2, 247, 100,
    6, 127, 181,  28, 120, 219, 101, 211,
   45, 219, 197, 226, 197, 243, 141,   9,
   12,  26, 140, 107,   0,
};
/*----------------------------------------------------------------------------*/
/* ¿༰ - ɿ62 򤢤魯                                 */
/* x62 65x61 202x60 113x59 98x58 71x57 223x56       */
/* 248x55 118x54 214x53 94x52x51 122x50 37x49       */
/* 23x48 2x47 228x46 58x45 121x44 7x43 105x42     */
/* 135x41 78x40 243x39 118x38 70x37 76x36 223x35  */
/* 89x34 72x33 50x32 70x31 111x30 194x29 17x28      */
/*  212x27 126x26 181x25 35x24 221x23 117x22        */
/* 235x21 11x20 229x19 149x18 147x17 123x16 213x15*/
/* 40x14 115x13 6x12 200x11  100x10 26x9 246x8    */
/* 182x7 218x6 127x5 215x4 36x3 186x2 110x 106    */
/* !! JIStypoꡣx5ιब̵äΤǡ127x5Ȥɲá            */
/*----------------------------------------------------------------------------*/
static const int v_poly_ecc62[] = {
  106, 110, 186,  36, 215, 127, 218, 182,
  246,  26, 100, 200,   6, 115,  40, 213,
  123, 147, 149, 229,  11, 235, 117, 221,
   35, 181, 126, 212,  17, 194, 111,  70,
   50,  72,  89, 223,  76,  70, 118, 243,
   78, 135, 105,   7, 121,  58, 228,   2,
   23,  37, 122,   0,  94, 214, 118, 248,
  223,  71,  98, 113, 202,  65,   0,
};
/*----------------------------------------------------------------------------*/
/* ¿༰ - ɿ64 򤢤魯                                 */
/* x64  45x63  51x62  175x61  9x60  7x59  158x58    */
/* 159x57  49x56 ܦ68x55  119x54 92x53 123x52 177x51*/
/* 204x50 187x49 254x48 200x47 78x46 141x45 149x44*/
/* 119x43 26x42 127x41 53x40 160x39 93x38 199x37  */
/* 212x36 29x35 24x34 145x33 156x32 208x31 150x30 */
/* 218x29 209x28 4x27 216x26ܦ91x25 47x24 184x23    */
/* 146x22 47x21 140x20 195x19 195x18 125x17 242x16*/
/* 238x15 63x14 99x13 108x12 140x11 230x10 242x9  */
/* 31x8 204x7 11x6 178x5 243x4 217x3 156x2        */
/* 213x 231                                                             */
/*----------------------------------------------------------------------------*/
static const int v_poly_ecc64[] = {
  231, 213, 156, 217, 243, 178,  11, 204,
   31, 242, 230, 140, 108,  99,  63, 238,
  242, 125, 195, 195, 140,  47, 146, 184,
   47,  91, 216,   4, 209, 218, 150, 208,
  156, 145,  24,  29, 212, 199,  93, 160,
   53, 127,  26, 119, 149, 141,  78, 200,
  254, 187, 204, 177, 123,  92, 119,  68,
   49, 159, 158,   7,   9, 175,  51,  45,
  0,
};
/*----------------------------------------------------------------------------*/
/* ¿༰ - ɿ66 򤢤魯                                 */
/* x66 5x65 118x64 222x63 180x62 136x61 136x60      */
/* 162x59 51x58 46x57 117x56 13x55 215x54 81x53   */
/* 17x52 139x51 247x50 197x49 171x48 95x47 173x46 */
/* 65x45 137x44 178x43 68x42 111x41 95x40 101x39  */
/* 41x38 72x37 214x36 169x35 197x34 95x33  7x32   */
/* 44x31  154x30  77x29  111x28  236x27  40x26        */
/* 121x25  143x24  63x23  87x22  80x21  253x20        */
/* 240x19  126x18 ܦ217x17  77x16  34x15  232x14        */
/* 106x13  50x12  168x11  82x10  76x9 ܦ146x8 67x7  */
/* 106x6 171x5 25x4 132x3 93x2 45x 105              */
/*----------------------------------------------------------------------------*/
static const int v_poly_ecc66[] = {
  105,  45,  93, 132,  25, 171, 106,  67,
  146,  76,  82, 168,  50, 106, 232,  34,
   77, 217, 126, 240, 253,  80,  87,  63,
  143, 121,  40, 236, 111,  77, 154,  44,
    7,  95, 197, 169, 214,  72,  41, 101,
   95, 111,  68, 178, 137,  65, 173,  95,
  171, 197, 247, 139,  17,  81, 215,  13,
  117,  46,  51, 162, 136, 136, 180, 222,
  118,   5,   0,
};
/*----------------------------------------------------------------------------*/
/* ¿༰ - ɿ68 򤢤魯                                 */
/* x68 247x67 159x66 223x65 33x64 224x63 93x62      */
/* 77x61 70x60 90x59  160x58  32x57  254x56 43x55 */
/* 150x54  84x53  101x52 ܦ190x51 205x50 133x49         */
/* 52x48 60x47 202x46 165x45 220x44 203x43 151x42 */
/* 93x41 84x40 15x39 84x38 253x37 173x36 160x35   */
/* 89x34  227x33  52x32  199x31  97x30 95x29 231x28 */
/*  52x27  177x26 41x25 125x24 137x23 241x22        */
/* 166x21 225x20 118x19 2x18 54x17 32x16 82x15    */
/* 215x14 175x13 198x12 43x11 238x10 235x9 27x8   */
/* 101x7 184x6 127x5 3x4 5x3 8x2 163x 238       */
/*----------------------------------------------------------------------------*/
static const int v_poly_ecc68[] = {
  238, 163,   8,   5,   3, 127, 184, 101,
   27, 235, 238,  43, 198, 175, 215,  82,
   32,  54,   2, 118, 225, 166, 241, 137,
  125,  41, 177,  52, 231,  95,  97, 199,
   52, 227,  89, 160, 173, 253,  84,  15,
   84,  93, 151, 203, 220, 165, 202,  60,
   52, 133, 205, 190, 101,  84, 150,  43,
  254,  32, 160,  90,  70,  77,  93, 224,
   33, 223, 159, 247,   0,
};

/*----------------------------------------------------------------------------*/
/* ¿༰˥뤿                                         */
/*----------------------------------------------------------------------------*/
static const int *v_poly_ecc[] = {
/* 顼 *//* ¿༰ */
/* 0              */ NULL,
/* 1              */ NULL,
/* 2              */ NULL,
/* 3              */ NULL,
/* 4              */ NULL,
/* 5              */ NULL,
/* 6              */ NULL,
/* 7              */ v_poly_ecc7,
/* 8              */ NULL,
/* 9              */ NULL,
/* 10             */ v_poly_ecc10,
/* 11             */ NULL,
/* 12             */ NULL,
/* 13             */ v_poly_ecc13,
/* 14             */ NULL,
/* 15             */ v_poly_ecc15,
/* 16             */ v_poly_ecc16,
/* 17             */ v_poly_ecc17,
/* 18             */ v_poly_ecc18,
/* 19             */ NULL,
/* 20             */ v_poly_ecc20,
/* 21             */ NULL,
/* 22             */ v_poly_ecc22,
/* 23             */ NULL,
/* 24             */ v_poly_ecc24,
/* 25             */ NULL,
/* 26             */ v_poly_ecc26,
/* 27             */ NULL,
/* 28             */ v_poly_ecc28,
/* 29             */ NULL,
/* 30             */ v_poly_ecc30,
/* 31             */ NULL,
/* 32             */ v_poly_ecc32,
/* 33             */ NULL,
/* 34             */ v_poly_ecc34,
/* 35             */ NULL,
/* 36             */ v_poly_ecc36,
/* 37             */ NULL,
/* 38             */ NULL,
/* 39             */ NULL,
/* 40             */ v_poly_ecc40,
/* 41             */ NULL,
/* 42             */ v_poly_ecc42,
/* 43             */ NULL,
/* 44             */ v_poly_ecc44,
/* 45             */ NULL,
/* 46             */ v_poly_ecc46,
/* 47             */ NULL,
/* 48             */ v_poly_ecc48,
/* 49             */ NULL,
/* 50             */ v_poly_ecc50,
/* 51             */ NULL,
/* 52             */ v_poly_ecc52,
/* 53             */ NULL,
/* 54             */ v_poly_ecc54,
/* 55             */ NULL,
/* 56             */ v_poly_ecc56,
/* 57             */ NULL,
/* 58             */ v_poly_ecc58,
/* 59             */ NULL,
/* 60             */ v_poly_ecc60,
/* 61             */ NULL,
/* 62             */ v_poly_ecc62,
/* 63             */ NULL,
/* 64             */ v_poly_ecc64,
/* 65             */ NULL,
/* 66             */ v_poly_ecc66,
/* 67             */ NULL,
/* 68             */ v_poly_ecc68,
};
/*----------------------------------------------------------------------------*/
/* ECCSPEC                                                                    */
/*                                                                */
/*----------------------------------------------------------------------------*/
typedef struct _qr_ecc_spec_t {
  qr_ver_t ver;
  qr_level_t level;
  struct rs_block_t {
    int rs_block_count;
    int total_code_count;
    int data_code_count;
  } rs[2];
} qr_ecc_spec_t;

static qr_ecc_spec_t v_ecc_spec_table[] = {
  { QR_VER_1, QR_LEVEL_L, {{1, 26, 19,},{  0, 0, 0,}}}, /* OK */
  { QR_VER_1, QR_LEVEL_M, {{1, 26, 16,},{  0, 0, 0,}}}, /* OK */
  { QR_VER_1, QR_LEVEL_Q, {{1, 26, 13,},{  0, 0, 0,}}}, /* OK */
  { QR_VER_1, QR_LEVEL_H, {{1, 26,  9,},{  0, 0, 0,}}}, /* OK */

  { QR_VER_2, QR_LEVEL_L, {{1, 44, 34,},{  0, 0, 0,}}}, /* OK */
  { QR_VER_2, QR_LEVEL_M, {{1, 44, 28,},{  0, 0, 0,}}}, /* OK */
  { QR_VER_2, QR_LEVEL_Q, {{1, 44, 22,},{  0, 0, 0,}}}, /* OK */
  { QR_VER_2, QR_LEVEL_H, {{1, 44, 16,},{  0, 0, 0,}}}, /* OK */

  { QR_VER_3, QR_LEVEL_L, {{1, 70, 55,},{  0, 0, 0,}}},
  { QR_VER_3, QR_LEVEL_M, {{1, 70, 44,},{  0, 0, 0,}}},
  { QR_VER_3, QR_LEVEL_Q, {{2, 35, 17,},{  0, 0, 0,}}},
  { QR_VER_3, QR_LEVEL_H, {{2, 35, 13,},{  0, 0, 0,}}},

  { QR_VER_4, QR_LEVEL_L, {{1,100, 80,},{  0, 0, 0,}}},
  { QR_VER_4, QR_LEVEL_M, {{2, 50, 32,},{  0, 0, 0,}}},
  { QR_VER_4, QR_LEVEL_Q, {{2, 50, 24,},{  0, 0, 0,}}},
  { QR_VER_4, QR_LEVEL_H, {{4, 25,  9,},{  0, 0, 0,}}}, /* OK */

  { QR_VER_5, QR_LEVEL_L, {{1,134,108,},{  0, 0, 0,}}},
  { QR_VER_5, QR_LEVEL_M, {{2, 67, 43,},{  0, 0, 0,}}},
  { QR_VER_5, QR_LEVEL_Q, {{2, 33, 15,},{  2,34,16,}}}, /* OK */
  { QR_VER_5, QR_LEVEL_H, {{2, 33, 11,},{  2,34,12,}}}, /* OK */

  { QR_VER_6, QR_LEVEL_L, {{2, 86, 68,},{  0,  0,  0,}}},
  { QR_VER_6, QR_LEVEL_M, {{4, 43, 27,},{  0,  0,  0,}}},
  { QR_VER_6, QR_LEVEL_Q, {{4, 43, 19,},{  0,  0,  0,}}},
  { QR_VER_6, QR_LEVEL_H, {{4, 43, 15,},{  0,  0,  0,}}}, /* OK */

  { QR_VER_7, QR_LEVEL_L, {{2, 98, 78,},{  0,  0,  0,}}},
  { QR_VER_7, QR_LEVEL_M, {{4, 49, 31,},{  0,  0,  0,}}},
  { QR_VER_7, QR_LEVEL_Q, {{2, 32, 14,},{  4, 33, 15,}}},
  { QR_VER_7, QR_LEVEL_H, {{4, 39, 13,},{  1, 40, 14,}}}, /* OK */

  { QR_VER_8, QR_LEVEL_L, {{2,121, 97,},{  0,  0,  0,}}},
  { QR_VER_8, QR_LEVEL_M, {{2, 60, 38,},{  2, 61, 39,}}},
  { QR_VER_8, QR_LEVEL_Q, {{4, 40, 18,},{  2, 41, 19,}}},
  { QR_VER_8, QR_LEVEL_H, {{4, 40, 14,},{  2, 41, 15,}}}, /* OK */

  { QR_VER_9, QR_LEVEL_L, {{2,146,116,},{  0,  0,  0,}}},
  { QR_VER_9, QR_LEVEL_M, {{3, 58, 36,},{  2, 59, 37,}}},
  { QR_VER_9, QR_LEVEL_Q, {{4, 36, 16,},{  4, 37, 17,}}},
  { QR_VER_9, QR_LEVEL_H, {{4, 36, 12,},{  4, 37, 13,}}},

  { QR_VER_10, QR_LEVEL_L, {{2, 86, 68,},{  2, 87, 69,}}},
  { QR_VER_10, QR_LEVEL_M, {{4, 69, 43,},{  1, 70, 44,}}},
  { QR_VER_10, QR_LEVEL_Q, {{6, 43, 19,},{  2, 44, 20,}}},
  { QR_VER_10, QR_LEVEL_H, {{6, 43, 15,},{  2, 44, 16,}}},

  { QR_VER_11, QR_LEVEL_L, {{4,101, 81,},{  0,  0,  0,}}},
  { QR_VER_11, QR_LEVEL_M, {{1, 80, 50,},{  4, 81, 51,}}},
  { QR_VER_11, QR_LEVEL_Q, {{4, 50, 22,},{  4, 51, 23,}}},
  { QR_VER_11, QR_LEVEL_H, {{3, 36, 12,},{  8, 37, 13,}}},

  { QR_VER_12, QR_LEVEL_L, {{2,116, 92,},{  2,117, 93,}}},
  { QR_VER_12, QR_LEVEL_M, {{6, 58, 36,},{  2, 59, 37,}}},
  { QR_VER_12, QR_LEVEL_Q, {{4, 46, 20,},{  6, 47, 21,}}},
  { QR_VER_12, QR_LEVEL_H, {{7, 42, 14,},{  4, 43, 15,}}},

  { QR_VER_13, QR_LEVEL_L, {{ 4,133,107,},{  0,  0,  0,}}},
  { QR_VER_13, QR_LEVEL_M, {{ 8, 59, 37,},{  1, 60, 38,}}},
  { QR_VER_13, QR_LEVEL_Q, {{ 8, 44, 20,},{  4, 45, 21,}}},
  { QR_VER_13, QR_LEVEL_H, {{12, 33, 11,},{  4, 34, 12,}}},

  { QR_VER_14, QR_LEVEL_L, {{ 3,145,115,},{  1,146,116,}}},

  /*------------------------------------------------------------------*/
  /* JIS X0510p34Ǥϡ(65,44,12)ȤʤäƤ뤬˻פޤ */
  /* Ǥϡ(65,41,24ˤȤƤޤ                                */
  /*------------------------------------------------------------------*/
  { QR_VER_14, QR_LEVEL_M, {{ 4, 64, 40,},{  5, 65, 41,}}}, 
  { QR_VER_14, QR_LEVEL_Q, {{11, 36, 16,},{  5, 37, 17,}}},
  { QR_VER_14, QR_LEVEL_H, {{11, 36, 12,},{  5, 37, 13,}}},

  { QR_VER_15, QR_LEVEL_L, {{ 5,109, 87,},{  1,110, 88,}}},
  { QR_VER_15, QR_LEVEL_M, {{ 5, 65, 41,},{  5, 66, 42,}}},
  { QR_VER_15, QR_LEVEL_Q, {{ 5, 54, 24,},{  7, 55, 25,}}},
  { QR_VER_15, QR_LEVEL_H, {{11, 36, 12,},{  7, 37, 13,}}},

  { QR_VER_16, QR_LEVEL_L, {{ 5,122, 98,},{  1,123, 99,}}},
  { QR_VER_16, QR_LEVEL_M, {{ 7, 73, 45,},{  3, 74, 46,}}},
  { QR_VER_16, QR_LEVEL_Q, {{15, 43, 19,},{  2, 44, 20,}}},
  { QR_VER_16, QR_LEVEL_H, {{ 3, 45, 15,},{ 13, 46, 16,}}},

  { QR_VER_17, QR_LEVEL_L, {{ 1,135,107,},{  5,136,108,}}},
  { QR_VER_17, QR_LEVEL_M, {{10, 74, 46,},{  1, 75, 47,}}},
  { QR_VER_17, QR_LEVEL_Q, {{ 1, 50, 22,},{ 15, 51, 23,}}},
  { QR_VER_17, QR_LEVEL_H, {{ 2, 42, 14,},{ 17, 43, 15,}}},

  { QR_VER_18, QR_LEVEL_L, {{ 5,150,120,},{  1,151,121,}}},
  { QR_VER_18, QR_LEVEL_M, {{ 9, 69, 43,},{  4, 70, 44,}}},
  { QR_VER_18, QR_LEVEL_Q, {{17, 50, 22,},{  1, 51, 23,}}},
  { QR_VER_18, QR_LEVEL_H, {{ 2, 42, 14,},{ 19, 43, 15,}}},

  { QR_VER_19, QR_LEVEL_L, {{ 3,141,113,},{  4,142,114,}}},
  { QR_VER_19, QR_LEVEL_M, {{ 3, 70, 44,},{ 11, 71, 45,}}},
  { QR_VER_19, QR_LEVEL_Q, {{17, 47, 21,},{  4, 48, 22,}}},
  { QR_VER_19, QR_LEVEL_H, {{ 9, 39, 13,},{ 16, 40, 14,}}},

  { QR_VER_20, QR_LEVEL_L, {{ 3,135,107,},{  5,136,108,}}},
  { QR_VER_20, QR_LEVEL_M, {{ 3, 67, 41,},{ 13, 68, 42,}}},
  { QR_VER_20, QR_LEVEL_Q, {{15, 54, 24,},{  5, 55, 25,}}},
  { QR_VER_20, QR_LEVEL_H, {{15, 43, 15,},{ 10, 44, 16,}}},

  { QR_VER_21, QR_LEVEL_L, {{ 4,144,116,},{  4,145,117,}}},
  { QR_VER_21, QR_LEVEL_M, {{17, 68, 42,},{  0,  0,  0,}}},
  { QR_VER_21, QR_LEVEL_Q, {{17, 50, 22,},{  6, 51, 23,}}},
  { QR_VER_21, QR_LEVEL_H, {{19, 46, 16,},{  6, 47, 17,}}},

  { QR_VER_22, QR_LEVEL_L, {{ 2,139,111,},{  7,140,112,}}},
  { QR_VER_22, QR_LEVEL_M, {{17, 74, 46,},{  0,  0,  0,}}},
  { QR_VER_22, QR_LEVEL_Q, {{ 7, 54, 24,},{ 16, 55, 25,}}},
  { QR_VER_22, QR_LEVEL_H, {{34, 37, 13,},{  0,  0,  0,}}},

  { QR_VER_23, QR_LEVEL_L, {{ 4,151,121,},{  5,152,122,}}},
  { QR_VER_23, QR_LEVEL_M, {{ 4, 75, 47,},{ 14, 76, 48,}}},
  { QR_VER_23, QR_LEVEL_Q, {{11, 54, 24,},{ 14, 55, 25,}}},
  { QR_VER_23, QR_LEVEL_H, {{16, 45, 15,},{ 14, 46, 16,}}},

  { QR_VER_24, QR_LEVEL_L, {{ 6,147,117,},{  4,148,118,}}},
  { QR_VER_24, QR_LEVEL_M, {{ 6, 73, 45,},{ 14, 74, 46,}}},
  { QR_VER_24, QR_LEVEL_Q, {{11, 54, 24,},{ 16, 55, 25,}}},
  { QR_VER_24, QR_LEVEL_H, {{30, 46, 16,},{  2, 47, 17,}}},

  { QR_VER_25, QR_LEVEL_L, {{ 8,132,106,},{  4,133,107,}}},
  { QR_VER_25, QR_LEVEL_M, {{ 8, 75, 47,},{ 13, 76, 48,}}},
  { QR_VER_25, QR_LEVEL_Q, {{ 7, 54, 24,},{ 22, 55, 25,}}},
  { QR_VER_25, QR_LEVEL_H, {{22, 45, 15,},{ 13, 46, 16,}}},

  { QR_VER_26, QR_LEVEL_L, {{10,142,114,},{  2,143,115,}}},
  { QR_VER_26, QR_LEVEL_M, {{19, 74, 46,},{  4, 75, 47,}}},
  { QR_VER_26, QR_LEVEL_Q, {{28, 50, 22,},{  6, 51, 23,}}},
  { QR_VER_26, QR_LEVEL_H, {{33, 46, 16,},{  4, 47, 17,}}},

  { QR_VER_27, QR_LEVEL_L, {{ 8,152,122,},{  4,153,123,}}},
  { QR_VER_27, QR_LEVEL_M, {{22, 73, 45,},{  3, 74, 46,}}},
  { QR_VER_27, QR_LEVEL_Q, {{ 8, 53, 23,},{ 26, 54, 24,}}},
  { QR_VER_27, QR_LEVEL_H, {{12, 45, 15,},{ 28, 46, 16,}}},

  { QR_VER_28, QR_LEVEL_L, {{ 3,147,117,},{ 10,148,118,}}},
  { QR_VER_28, QR_LEVEL_M, {{ 3, 73, 45,},{ 23, 74, 46,}}},
  { QR_VER_28, QR_LEVEL_Q, {{ 4, 54, 24,},{ 31, 55, 25,}}},
  { QR_VER_28, QR_LEVEL_H, {{11, 45, 15,},{ 31, 46, 16,}}},

  { QR_VER_29, QR_LEVEL_L, {{ 7,146,116,},{  7,147,117,}}},
  { QR_VER_29, QR_LEVEL_M, {{21, 73, 45,},{  7, 74, 46,}}},
  { QR_VER_29, QR_LEVEL_Q, {{ 1, 53, 23,},{ 37, 54, 24,}}},
  { QR_VER_29, QR_LEVEL_H, {{19, 45, 15,},{ 26, 46, 16,}}},

  { QR_VER_30, QR_LEVEL_L, {{ 5,145,115,},{ 10,146,116,}}},
  { QR_VER_30, QR_LEVEL_M, {{19, 75, 47,},{ 10, 76, 48,}}},
  { QR_VER_30, QR_LEVEL_Q, {{15, 54, 24,},{ 25, 55, 25,}}},
  { QR_VER_30, QR_LEVEL_H, {{23, 45, 15,},{ 25, 46, 16,}}},

  { QR_VER_31, QR_LEVEL_L, {{13,145,115,},{  3,146,116,}}},
  { QR_VER_31, QR_LEVEL_M, {{ 2, 74, 46,},{ 29, 75, 47,}}},
  { QR_VER_31, QR_LEVEL_Q, {{42, 54, 24,},{  1, 55, 25,}}},
  { QR_VER_31, QR_LEVEL_H, {{23, 45, 15,},{ 28, 46, 16,}}},

  { QR_VER_32, QR_LEVEL_L, {{17,145,115,},{  0,  0,  0,}}},
  { QR_VER_32, QR_LEVEL_M, {{10, 74, 46,},{ 23, 75, 47,}}},
  { QR_VER_32, QR_LEVEL_Q, {{10, 54, 24,},{ 35, 55, 25,}}},
  { QR_VER_32, QR_LEVEL_H, {{19, 45, 15,},{ 35, 46, 16,}}},

  { QR_VER_33, QR_LEVEL_L, {{17,145,115,},{  1,146,116,}}},
  { QR_VER_33, QR_LEVEL_M, {{14, 74, 46,},{ 21, 75, 47,}}},
  { QR_VER_33, QR_LEVEL_Q, {{29, 54, 24,},{ 19, 55, 25,}}},
  { QR_VER_33, QR_LEVEL_H, {{11, 45, 15,},{ 46, 46, 16,}}},

  { QR_VER_34, QR_LEVEL_L, {{13,145,115,},{  6,146,116,}}},
  { QR_VER_34, QR_LEVEL_M, {{14, 74, 46,},{ 23, 75, 47,}}},
  { QR_VER_34, QR_LEVEL_Q, {{44, 54, 24,},{  7, 55, 25,}}},
  { QR_VER_34, QR_LEVEL_H, {{59, 46, 16,},{  1, 47, 17,}}},

  { QR_VER_35, QR_LEVEL_L, {{12,151,121,},{  7,152,122,}}},
  { QR_VER_35, QR_LEVEL_M, {{12, 75, 47,},{ 26, 76, 48,}}},
  { QR_VER_35, QR_LEVEL_Q, {{39, 54, 24,},{ 14, 55, 25,}}},
  { QR_VER_35, QR_LEVEL_H, {{22, 45, 15,},{ 41, 46, 16,}}},

  { QR_VER_36, QR_LEVEL_L, {{ 6,151,121,},{ 14,152,122,}}},
  { QR_VER_36, QR_LEVEL_M, {{ 6, 75, 47,},{ 34, 76, 48,}}},
  { QR_VER_36, QR_LEVEL_Q, {{46, 54, 24,},{ 10, 55, 25,}}},
  { QR_VER_36, QR_LEVEL_H, {{ 2, 45, 15,},{ 64, 46, 16,}}},

  { QR_VER_37, QR_LEVEL_L, {{17,152,122,},{  4,153,123,}}},
  { QR_VER_37, QR_LEVEL_M, {{29, 74, 46,},{ 14, 75, 47,}}},
  { QR_VER_37, QR_LEVEL_Q, {{49, 54, 24,},{ 10, 55, 25,}}},
  { QR_VER_37, QR_LEVEL_H, {{24, 45, 15,},{ 46, 46, 16,}}},

  { QR_VER_38, QR_LEVEL_L, {{ 4,152,122,},{ 18,153,123,}}},
  { QR_VER_38, QR_LEVEL_M, {{13, 74, 46,},{ 32, 75, 47,}}},
  { QR_VER_38, QR_LEVEL_Q, {{48, 54, 24,},{ 14, 55, 25,}}},
  { QR_VER_38, QR_LEVEL_H, {{42, 45, 15,},{ 32, 46, 16,}}},

  { QR_VER_39, QR_LEVEL_L, {{20,147,117,},{  4,148,118,}}},
  { QR_VER_39, QR_LEVEL_M, {{40, 75, 47,},{  7, 76, 48,}}},
  { QR_VER_39, QR_LEVEL_Q, {{43, 54, 24,},{ 22, 55, 25,}}},
  { QR_VER_39, QR_LEVEL_H, {{10, 45, 15,},{ 67, 46, 16,}}},

  { QR_VER_40, QR_LEVEL_L, {{19,148,118,},{  6,149,119,}}},
  { QR_VER_40, QR_LEVEL_M, {{18, 75, 47,},{ 31, 76, 48,}}},
  { QR_VER_40, QR_LEVEL_Q, {{34, 54, 24,},{ 34, 55, 25,}}},
  { QR_VER_40, QR_LEVEL_H, {{20, 45, 15,},{ 61, 46, 16,}}},
};




/**
 * ղäޤޤңӥ֥åʣξϡ
 * 󥿥꡼֤̤<code>dst</code>ꤷޤ.
 */
int
chxj_calc_ecc(qr_code_t* qrcode,
              unsigned char* indata, 
              unsigned char* dst)
{
  request_rec* r = qrcode->r;
  int ii;
  int jj;
  int rslt_pos = 0;
  int in_pos = 0;
  int xx;
  int rs_pos;
  int rs_cnt;
  int data_count;
  int ecc_count;
  int rs_total_block_count;   /* RS֥å */
  int *rs_block_rest;         /* RS֥åλĿ */
  int *rs_block_size;         /* RS֥åΥ */
  int *rs_block_ecc_size;     /* RS֥åeccΥ */
  int now_rs_num;
  int total_size;
  int exist_flag = 0;
  unsigned char** rs_block;
#ifdef QR_CODE_DEBUG
  DBG(r,"start chxj_calc_ecc()");
#endif

  rs_total_block_count = v_ecc_spec_table[qrcode->version*4+qrcode->level].rs[0].rs_block_count +
                         v_ecc_spec_table[qrcode->version*4+qrcode->level].rs[1].rs_block_count ;

  rs_block = (unsigned char**)apr_palloc(r->pool, sizeof(unsigned char*)*rs_total_block_count);
  rs_block_rest = (int*)apr_palloc(r->pool, sizeof(int)*rs_total_block_count);
  rs_block_size = (int*)apr_palloc(r->pool, sizeof(int)*rs_total_block_count);
  rs_block_ecc_size = (int*)apr_palloc(r->pool, sizeof(int)*rs_total_block_count);

  total_size = (v_ecc_spec_table[qrcode->version*4+qrcode->level].rs[0].rs_block_count 
               * v_ecc_spec_table[qrcode->version*4+qrcode->level].rs[0].total_code_count) +
               (v_ecc_spec_table[qrcode->version*4+qrcode->level].rs[1].rs_block_count 
                * v_ecc_spec_table[qrcode->version*4+qrcode->level].rs[1].total_code_count);


  now_rs_num = 0;
  for (rs_pos = 0; rs_pos < 2; rs_pos++) {
    for (rs_cnt = v_ecc_spec_table[qrcode->version*4+qrcode->level].rs[rs_pos].rs_block_count;
         rs_cnt > 0;
         rs_cnt--) {

      unsigned char* tmp;
      int  rs_ii = 0;

      data_count  = v_ecc_spec_table[qrcode->version*4+qrcode->level].rs[rs_pos].data_code_count;
      ecc_count = v_ecc_spec_table[qrcode->version*4+qrcode->level].rs[rs_pos].total_code_count - data_count;

#ifdef QR_CODE_DEBUG
      DBG(r,"data_count[%d] ecc_count[%d]", data_count, ecc_count);
#endif

      rs_block[now_rs_num] = (unsigned char*)apr_palloc(qrcode->r->pool, data_count + ecc_count + 1);
      tmp = (unsigned char*)apr_palloc(qrcode->r->pool, data_count + ecc_count + 1);

      rs_block_size[now_rs_num] = rs_block_rest[now_rs_num] = data_count + ecc_count;
      rs_block_ecc_size[now_rs_num] = ecc_count;

#ifdef QR_CODE_DEBUG
      DBG(r,"apr_palloc() tmp");
#endif

      memset(tmp, 0, data_count + ecc_count + 1);
      memset(rs_block[now_rs_num], 0, data_count + ecc_count + 1);

#ifdef QR_CODE_DEBUG
      DBG(r,"memset end");
#endif

      /* ǡ򥳥ԡ */
      for (jj=0; jj<data_count; jj++) {
        tmp[data_count + ecc_count - 1 - jj] = indata[in_pos];

        rs_block[now_rs_num][rs_ii++] = indata[in_pos];

        in_pos++;
      }
#ifdef QR_CODE_DEBUG
      /* for DEBUG */
      do {
        char* debug_rows;

        debug_rows    = apr_palloc(r->pool, 1);
        debug_rows[0] = 0;

        for (jj=ecc_count + data_count - 1; jj>=0; jj--)
          debug_rows = apr_pstrcat(r->pool, debug_rows, apr_psprintf(r->pool, "[%d]", tmp[jj]), NULL);

        DBG(r,"rows [%s]", debug_rows);
      } while(0);
      /* for DEBUG END */
#endif

      ii=data_count + ecc_count -1;

      for (xx = data_count - 1; xx >= 0; xx--) {
        int tgt = tmp[ii--];
        int shisu = v_galois_int_to_log[tgt];
#ifdef QR_CODE_DEBUG
        DBG(r,"tgt[%d] shisu[%d]", tgt, shisu);
#endif
        if (tgt == 0)
          continue;

        for (jj=ecc_count; jj>=0;jj--) {
          assert(v_poly_ecc[ecc_count] != NULL);
          tmp[jj+xx] ^= v_galois_log_to_int[(v_poly_ecc[ecc_count][jj] + shisu)]; 
        }
#ifdef QR_CODE_DEBUG
        /* for DEBUG */
        do {
          char* debug_rows;

          debug_rows = apr_palloc(r->pool, 1);
          debug_rows[0] = 0;
          for (jj=ecc_count + data_count - 1; jj>=0; jj--)
            debug_rows = apr_pstrcat(r->pool, debug_rows, apr_psprintf(r->pool, "[%d]", tmp[jj]), NULL);

          DBG(r,"rows [%s]", debug_rows);
        } while(0);
        /* for DEBUG END */
#endif
      }

      for (; ii>=0; ii--)
        rs_block[now_rs_num][rs_ii++] = tmp[ii];

      now_rs_num++;
    }
  }

#ifdef QR_CODE_DEBUG
  /* for DEBUG */
  do {
    DBG(r,"######### RS BLOCK DUMP ###############");
    for (jj=0; jj<rs_total_block_count; jj++) {
       char* rows = apr_psprintf(r->pool, "%02d size:[%d] rest:[%d]",jj, rs_block_size[jj], rs_block_rest[jj]);
       for (ii=0; ii<rs_block_size[jj]; ii++) {
         rows = apr_pstrcat(r->pool, rows, apr_psprintf(r->pool, "[%d]", rs_block[jj][ii]), NULL);
       }
       DBG(r,"%s", rows);
    }
  } while(0);
#endif


  /* 󥿥꡼֤μ ʥǡ*/
  for (;;) {
    exist_flag = 0;
    for (jj=0; jj<rs_total_block_count; jj++) {
      if (rs_block_rest[jj] - rs_block_ecc_size[jj] > 0) {
        dst[rslt_pos++] = rs_block[jj][rs_block_size[jj]-rs_block_rest[jj]];
        rs_block_rest[jj]--;
        exist_flag = 1;
      }
    }
    if (exist_flag == 0) {
      /* RS֥åλĿƣˤʤä顢λ */
      break;
    }
  }
  /* 󥿥꡼֤μʣţã */
  for (;;) {
    exist_flag = 0;
    for (jj=0; jj<rs_total_block_count; jj++) {
      if (rs_block_rest[jj] > 0) {
        dst[rslt_pos++] = rs_block[jj][rs_block_size[jj]-rs_block_rest[jj]];
        rs_block_rest[jj]--;
        exist_flag = 1;
      }
    }
    if (exist_flag == 0) {
      /* RS֥åλĿƣˤʤä顢λ */
      break;
    }
  }
#ifdef QR_CODE_DEBUG
  /* for DEBUG */
  do {
    DBG(r,"######### AFTER BLOCK DUMP ###############");
    for (ii=0; ii<rslt_pos; ii++) {
      DBG(r,"[%d]", dst[ii]);
    }
  } while(0);
#endif

  return rslt_pos;
}
/*
 * vim:ts=2 et
 */
