<?php
/**
 * mod_auth_hmac ticket generator
 * 
 * PHP version 5
 * 
 * 
 * Copyright 2007 Takayuki Ogiso
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 *
 * @author    Takayuki Ogiso <tatami@users.sourceforge.jp>
 * @copyright 2007 Takayuki Ogiso
 * @license   http://www.apache.org/licenses/LICENSE-2.0  Apache License 2.0
 */

/**
 * Generate and return a AuthHmac ticket
 * 
 * @param string $key HMAC key (BASE64 encoded)
 * @param int $expire Expiration (UNIX timestamp)
 * @return string AuthHmac ticket
 */
function getAuthHmac($key, $expire)
{
    // RFC 822 format
    $expireString = gmdate('D, d M Y H:i:s', $expire) . ' GMT';
    
    $hmac = hash_hmac('sha1', $expireString, base64_decode($key));
    $authHmac = $expireString . "\t" . $hmac;
    
    return $authHmac;
}

?>
