// p[^錾

#define Near 1.0
#define Far 1000.0

// @ϊs
float4x4 WorldViewProjMatrix      : WORLDVIEWPROJECTION;
float4x4 WorldMatrix              : WORLD;

float3   CameraPosition    : POSITION  < string Object = "Camera"; >;

// MMD{sampler㏑Ȃ߂̋LqłB폜sB
sampler MMDSamp0 : register(s0);
sampler MMDSamp1 : register(s1);
sampler MMDSamp2 : register(s2);

///////////////////////////////////////////////////////////////////////////////////////////////
// IuWFNg`iZtVhEOFFj

struct VS_OUTPUT
{
    float4 Pos        : POSITION;    // ˉeϊW
    float  Z 		  : TEXCOORD0;    // Zl
};

// _VF[_
VS_OUTPUT Basic_VS(float4 Pos : POSITION, float3 Normal : NORMAL, float2 Tex : TEXCOORD0)
{
    VS_OUTPUT Out = (VS_OUTPUT)0;
    
    // J_̃[hr[ˉeϊ
    Out.Pos = mul( Pos, WorldViewProjMatrix );
    Out.Z = 1-length(CameraPosition - mul( Pos, WorldMatrix ))*(Near/Far);
    
    return Out;
}

// sNZVF[_
float4 Basic_PS( VS_OUTPUT IN ) : COLOR0
{
    return float4(IN.Z,IN.Z,IN.Z,1);
}

// IuWFNg`peNjbN
technique MainTec < string MMDPass = "object"; > {
    pass DrawObject
    {
        VertexShader = compile vs_2_0 Basic_VS();
        PixelShader  = compile ps_2_0 Basic_PS();
    }
}

// IuWFNg`peNjbN
technique MainTecBS  < string MMDPass = "object_ss"; > {
    pass DrawObject {
        VertexShader = compile vs_2_0 Basic_VS();
        PixelShader  = compile ps_2_0 Basic_PS();
    }
}
technique EdgeTec < string MMDPass = "edge"; > {

}
technique ShadowTech < string MMDPass = "shadow";  > {
    
}

///////////////////////////////////////////////////////////////////////////////////////////////
