////////////////////////////////////////////////////////////////////////////////////////////////
// p[^錾

float Script : STANDARDSGLOBAL <
    string ScriptOutput = "color";
    string ScriptClass = "object";
    string ScriptOrder = "postprocess";
> = 0.8;

// @ϊs
float4x4 WorldViewProjMatrix      : WORLDVIEWPROJECTION;
float4x4 WorldViewMatrix          : WORLDVIEW;

float4   MaterialDiffuse   : DIFFUSE  < string Object = "Geometry"; >;


///////////////////////////////////////////////////////////////////////////////////////////////
// ֘A

// eNX`̃TCY
#define WIDTH   1024
#define HEIGHT  1024

// _O^[Qbg̃NAl
float4 ClearColor = {1,1,1,1};
float ClearDepth  = 1.0;

// ɔ˂IuWFNg̕`挋ʂL^邽߂̃_[^[Qbg
shared texture MirrorTex : RENDERCOLORTARGET <
    float Width = WIDTH;
    float Height = HEIGHT;
>;
shared texture MirrorDepthBuffer : RENDERDEPTHSTENCILTARGET <
    float Width = WIDTH;
    float Height = HEIGHT;
>;

sampler MirrorView = sampler_state {
    texture = <MirrorTex>;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    MipFilter = NONE;
    AddressU  = CLAMP;
    AddressV = CLAMP;
};


///////////////////////////////////////////////////////////////////////////////////////////////
// IuWFNg`

struct VS_OUTPUT {
    float4 Pos        : POSITION;    // ˉeϊW
    float2 Tex        : TEXCOORD1;   // eNX`
};

// _VF[_
VS_OUTPUT Mirror_VS(float4 Pos : POSITION, float2 Tex : TEXCOORD0)
{
    VS_OUTPUT Out = (VS_OUTPUT)0;
    
    // J_̃[hr[ˉeϊ
    Out.Pos = mul( Pos, WorldViewProjMatrix );
    
    // eNX`W
    Out.Tex = Tex;
    
    if ( dot(WorldViewMatrix[2].xyz,WorldViewMatrix[3].xyz) > 0 ) {
        // ̕\̖ʂ̏ꍇAX𔽓]ĕ`悵Ă̂ŁAŔ]B
        Out.Tex.x = 1 - Out.Tex.x;
    }
    
    return Out;
}

// sNZVF[_
float4 Mirror_PS(VS_OUTPUT IN) : COLOR0
{
    return tex2D(MirrorView, IN.Tex);
}

technique MainTec <
    string Script = 
        "RenderColorTarget0=MirrorTex;"
	    "RenderDepthStencilTarget=MirrorDepthBuffer;"
		"ClearSetColor=ClearColor;"
		"ClearSetDepth=ClearDepth;"
		"Clear=Color;"
		"Clear=Depth;"
        "RenderColorTarget0=;"
	    "RenderDepthStencilTarget=;"
	    "ScriptExternal=Color;"
	    "Pass=DrawObject;"
    ;
> {
    pass DrawObject {
        CULLMODE = NONE;
        VertexShader = compile vs_2_0 Mirror_VS();
        PixelShader  = compile ps_2_0 Mirror_PS();
    }
}


///////////////////////////////////////////////////////////////////////////////////////////////
