////////////////////////////////////////////////////////////////////////////////////////////////
// p[^錾

// @ϊs
float4x4 WorldViewProjMatrix      : WORLDVIEWPROJECTION;
float4x4 WorldViewMatrixInverse        : WORLDVIEWINVERSE;

texture MaskTex : ANIMATEDTEXTURE <
    string ResourceName = "laughing_man.png";
>;
sampler Mask = sampler_state {
    texture = <MaskTex>;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    MipFilter = NONE;
    AddressU  = CLAMP;
    AddressV  = CLAMP;
};


static float3x3 BillboardMatrix = {
    normalize(WorldViewMatrixInverse[0].xyz),
    normalize(WorldViewMatrixInverse[1].xyz),
    normalize(WorldViewMatrixInverse[2].xyz),
};

///////////////////////////////////////////////////////////////////////////////////////////////

struct VS_OUTPUT
{
    float4 Pos        : POSITION;    // ˉeϊW
    float2 Tex        : TEXCOORD0;   // eNX`
};

// _VF[_
VS_OUTPUT Mask_VS(float4 Pos : POSITION, float2 Tex : TEXCOORD0)
{
    VS_OUTPUT Out;
    
    // r{[h
    Pos.xyz = mul( Pos.xyz, BillboardMatrix );
    // J_̃[hr[ˉeϊ
    Out.Pos = mul( Pos, WorldViewProjMatrix );
    
    // eNX`W
    Out.Tex = Tex;
    
    return Out;
}

// sNZVF[_
float4 Mask_PS( float2 Tex :TEXCOORD0 ) : COLOR0
{
    return tex2D( Mask, Tex );
}

technique MainTec < string MMDPass = "object"; > {
    pass DrawObject {
        ZENABLE = false;
        VertexShader = compile vs_1_1 Mask_VS();
        PixelShader  = compile ps_2_0 Mask_PS();
    }
}

