////////////////////////////////////////////////////////////////////////////////////////////////
// p[^錾

// @ϊs
float4x4 WorldViewProjMatrix      : WORLDVIEWPROJECTION;
float4x4 WorldMatrix              : WORLD;
float4x4 ViewMatrix               : VIEW;

//float3   LightDirection    : DIRECTION < string Object = "Light"; >;
float3   CameraPosition    : POSITION  < string Object = "Camera"; >;

// }eAF
float4   MaterialDiffuse   : DIFFUSE  < string Object = "Geometry"; >;
float3   MaterialAmbient   : AMBIENT  < string Object = "Geometry"; >;
float3   MaterialEmmisive  : EMISSIVE < string Object = "Geometry"; >;
float3   MaterialSpecular  : SPECULAR < string Object = "Geometry"; >;
float    SpecularPower     : SPECULARPOWER < string Object = "Geometry"; >;
float3   MaterialToon      : TOONCOLOR;
// CgF
//float3   LightDiffuse      : DIFFUSE   < string Object = "Light"; >;
//float3   LightAmbient      : AMBIENT   < string Object = "Light"; >;
//float3   LightSpecular     : SPECULAR  < string Object = "Light"; >;
//static float4 DiffuseColor  = MaterialDiffuse  * float4(LightDiffuse, 1.0f);
//static float3 AmbientColor  = saturate(MaterialAmbient  * LightAmbient + MaterialEmmisive);
//static float3 SpecularColor = MaterialSpecular * LightSpecular;

bool	 spadd;    // XtBA}bvZtO


// IuWFNg̃eNX`
texture ObjectTexture: MATERIALTEXTURE;
sampler ObjTexSampler = sampler_state {
    texture = <ObjectTexture>;
    MINFILTER = LINEAR;
    MAGFILTER = LINEAR;
};

// XtBA}bṽeNX`
texture ObjectSphereMap: MATERIALSPHEREMAP;
sampler ObjSphareSampler = sampler_state {
    texture = <ObjectSphereMap>;
    MINFILTER = LINEAR;
    MAGFILTER = LINEAR;
};

// MMD{sampler㏑Ȃ߂̋LqłB폜sB
sampler MMDSamp0 : register(s0);
sampler MMDSamp1 : register(s1);
sampler MMDSamp2 : register(s2);

///////////////////////////////////////////////////////////////////////////////////////////////
// DiscoLightingp

float BallTime : TIME;
float3x3 CalcRotateMatrix(float time) {
   float cosX,sinX;
   float cosY,sinY;
   float cosZ,sinZ;

   sincos(0.48 * time,sinX,cosX);
   sincos(0.42 * time,sinY,cosY);
   sincos(0.45 * time,sinZ,cosZ);

   return float3x3(
      cosY * cosZ + sinX * sinY * sinZ,  cosY * sinZ - sinX * sinY * cosZ, cosX * sinY,
     -cosX * sinZ,                       cosX * cosZ,                      sinX, 
      sinX * cosY * sinZ - sinY * cosZ, -sinY * sinZ - sinX * cosY * cosZ, cosX * cosY
   );
}
static float3x3 BallRotateMatrix = CalcRotateMatrix(BallTime);

shared textureCUBE LightCube_Tex;
samplerCUBE LightCube = sampler_state
{
   Texture = (LightCube_Tex);
   ADDRESSU = CLAMP;
   ADDRESSV = CLAMP;
   MAGFILTER = LINEAR;
   MINFILTER = LINEAR;
   MIPFILTER = LINEAR;
};

// Cg̕\ON/OFF
bool LightOn: CONTROLOBJECT < string Name = "DiscoLight.x"; >;
// Cg̈ʒu
float4 LightPositon: CONTROLOBJECT < string Name = "DiscoLight.x"; >;

///////////////////////////////////////////////////////////////////////////////////////////////
// IuWFNg`iZtVhEOFFj

struct VS_OUTPUT {
    float4 Pos        : POSITION;    // ˉeϊW
    float2 Tex        : TEXCOORD1;   // eNX`
    float3 Normal     : TEXCOORD2;   // @
    float3 Eye        : TEXCOORD3;   // JƂ̑Έʒu
    float2 SpTex      : TEXCOORD4;	 // XtBA}bveNX`W
    float3 LightDir   : TEXCOORD5;	 // Cg̕
    float3 BallDir    : TEXCOORD6;	 // {[̌
//    float4 Color      : COLOR0;      // fBt[YF
};

// _VF[_
VS_OUTPUT Basic_VS(float4 Pos : POSITION, float3 Normal : NORMAL, float2 Tex : TEXCOORD0, uniform bool useTexture, uniform bool useSphereMap, uniform bool useToon)
{
    VS_OUTPUT Out = (VS_OUTPUT)0;
    
    // J_̃[hr[ˉeϊ
    Out.Pos = mul( Pos, WorldViewProjMatrix );
    
    float4 PosW = mul( Pos, WorldMatrix );
    // JƂ̑Έʒu
    Out.Eye = CameraPosition - PosW;
    // _@
    Out.Normal = normalize( mul( Normal, (float3x3)WorldMatrix ) );
    
    // eNX`W
    Out.Tex = Tex;
    
    if ( useSphereMap ) {
        // XtBA}bveNX`W
        float2 NormalWV = mul( Out.Normal, (float3x3)ViewMatrix );
        Out.SpTex.x = NormalWV.x * 0.5f + 0.5f;
        Out.SpTex.y = NormalWV.y * -0.5f + 0.5f;
    }
    
    Out.LightDir = PosW - LightPositon;
    float3 dir = Out.LightDir;
    Out.BallDir = mul(dir, BallRotateMatrix);
    
    return Out;
}

// sNZVF[_
float4 Basic_PS(VS_OUTPUT IN, uniform bool useTexture, uniform bool useSphereMap, uniform bool useToon) : COLOR0
{
    float3 LightDir = normalize( IN.LightDir );
    float3 lightColor = texCUBE( LightCube, IN.BallDir ).rgb * LightOn;
    
    // XyLFvZ
    float3 HalfVector = normalize( normalize(IN.Eye) + -LightDir );
    float3 Specular = pow( max(0,dot( HalfVector, normalize(IN.Normal) )), SpecularPower ) * MaterialSpecular * lightColor;
    
    float4 Color;
    if ( useToon ) {
        Color.rgb = MaterialAmbient * lightColor*0.8 + MaterialEmmisive;
    } else {
        Color = max(0,dot( IN.Normal, -LightDir )) * MaterialDiffuse * float4(lightColor, 1.0f) ;
        Color.rgb += MaterialAmbient * lightColor*0.1 + MaterialEmmisive;
    }
    Color.a = MaterialDiffuse.a;
    Color = saturate( Color );
    
    if ( useTexture ) {
        // eNX`Kp
        Color *= tex2D( ObjTexSampler, IN.Tex );
    }
    if ( useSphereMap ) {
        // XtBA}bvKp
        if(spadd) Color += tex2D(ObjSphareSampler,IN.SpTex);
        else      Color *= tex2D(ObjSphareSampler,IN.SpTex);
    }
    
    if ( useToon ) {
        // gD[Kp
        float LightNormal = dot( IN.Normal, -LightDir );
        Color.rgb *= lerp(MaterialToon, float3(1,1,1), saturate(LightNormal * 16 + 0.5));
    }
    
    // XyLKp
    Color.rgb += Specular;
    
    return Color;
}

// IuWFNg`peNjbNiANZTpj
// svȂ͍̂폜
technique MainTec0 < string MMDPass = "object"; bool UseTexture = false; bool UseSphereMap = false; bool UseToon = false; > {
    pass DrawObject {
        VertexShader = compile vs_2_0 Basic_VS(false, false, false);
        PixelShader  = compile ps_2_0 Basic_PS(false, false, false);
    }
}

technique MainTec1 < string MMDPass = "object"; bool UseTexture = true; bool UseSphereMap = false; bool UseToon = false; > {
    pass DrawObject {
        VertexShader = compile vs_2_0 Basic_VS(true, false, false);
        PixelShader  = compile ps_2_0 Basic_PS(true, false, false);
    }
}

technique MainTec2 < string MMDPass = "object"; bool UseTexture = false; bool UseSphereMap = true; bool UseToon = false; > {
    pass DrawObject {
        VertexShader = compile vs_2_0 Basic_VS(false, true, false);
        PixelShader  = compile ps_2_0 Basic_PS(false, true, false);
    }
}

technique MainTec3 < string MMDPass = "object"; bool UseTexture = true; bool UseSphereMap = true; bool UseToon = false; > {
    pass DrawObject {
        VertexShader = compile vs_2_0 Basic_VS(true, true, false);
        PixelShader  = compile ps_2_0 Basic_PS(true, true, false);
    }
}

// IuWFNg`peNjbNiPMDfpj
technique MainTec4 < string MMDPass = "object"; bool UseTexture = false; bool UseSphereMap = false; bool UseToon = true; > {
    pass DrawObject {
        VertexShader = compile vs_2_0 Basic_VS(false, false, true);
        PixelShader  = compile ps_2_0 Basic_PS(false, false, true);
    }
}

technique MainTec5 < string MMDPass = "object"; bool UseTexture = true; bool UseSphereMap = false; bool UseToon = true; > {
    pass DrawObject {
        VertexShader = compile vs_2_0 Basic_VS(true, false, true);
        PixelShader  = compile ps_2_0 Basic_PS(true, false, true);
    }
}

technique MainTec6 < string MMDPass = "object"; bool UseTexture = false; bool UseSphereMap = true; bool UseToon = true; > {
    pass DrawObject {
        VertexShader = compile vs_2_0 Basic_VS(false, true, true);
        PixelShader  = compile ps_2_0 Basic_PS(false, true, true);
    }
}

technique MainTec7 < string MMDPass = "object"; bool UseTexture = true; bool UseSphereMap = true; bool UseToon = true; > {
    pass DrawObject {
        VertexShader = compile vs_2_0 Basic_VS(true, true, true);
        PixelShader  = compile ps_2_0 Basic_PS(true, true, true);
    }
}


///////////////////////////////////////////////////////////////////////////////////////////////
