////////////////////////////////////////////////////////////////////////////////////////////////
//
//  basic.fx ver1.2
//  쐬: ͉P
//
////////////////////////////////////////////////////////////////////////////////////////////////
// p[^錾

// @ϊs
float4x4 WorldViewProjMatrix      : WORLDVIEWPROJECTION;
float4x4 WorldMatrix              : WORLD;
float4x4 LightWorldViewProjMatrix : WORLDVIEWPROJECTION < string Object = "Light"; >;

float3   LightDirection    : DIRECTION < string Object = "Light"; >;
float3   CameraPosition    : POSITION  < string Object = "Camera"; >;

// }eAF
float4   MaterialDiffuse   : DIFFUSE  < string Object = "Geometry"; >;
float3   MaterialAmbient   : AMBIENT  < string Object = "Geometry"; >;
float3   MaterialEmmisive  : EMISSIVE < string Object = "Geometry"; >;
float3   MaterialSpecular  : SPECULAR < string Object = "Geometry"; >;
float    SpecularPower     : SPECULARPOWER < string Object = "Geometry"; >;
float3   MaterialToon      : TOONCOLOR;
// CgF
float3   LightDiffuse      : DIFFUSE   < string Object = "Light"; >;
float3   LightAmbient      : AMBIENT   < string Object = "Light"; >;
float3   LightSpecular     : SPECULAR  < string Object = "Light"; >;
static float4 DiffuseColor  = MaterialDiffuse  * float4(LightDiffuse, 1.0f);
static float3 AmbientColor  = saturate(MaterialAmbient  * LightAmbient + MaterialEmmisive);
static float3 SpecularColor = MaterialSpecular * LightSpecular;

bool use_texture;  //eNX`̗L
bool use_toon;     //gD[̗L

bool     parthf;   // p[XyNeButO
bool     transp;   // tO
#define SKII1    1500
#define SKII2    8000
#define Toon     3

// IuWFNg̃eNX`
texture ObjectTexture: MATERIALTEXTURE;
sampler ObjTexSampler = sampler_state
{
    texture = <ObjectTexture>;
    MINFILTER = LINEAR;
    MAGFILTER = LINEAR;
};

// MMD{sampler㏑Ȃ߂̋LqłB폜sB
sampler MMDSamp0 : register(s0);
sampler MMDSamp1 : register(s1);
sampler MMDSamp2 : register(s2);

///////////////////////////////////////////////////////////////////////////////////////////////
// IuWFNg`iZtVhEOFFj

struct VS_OUTPUT
{
    float4 Pos        : POSITION;    // ˉeϊW
    float2 Tex        : TEXCOORD1;   // eNX`
    float3 Normal     : TEXCOORD2;   // @
    float3 Eye        : TEXCOORD3;   // JƂ̑Έʒu
    float4 Color      : COLOR0;      // fBt[YF
};

// _VF[_
VS_OUTPUT Basic_VS(float4 Pos : POSITION, float3 Normal : NORMAL, float2 Tex : TEXCOORD0)
{
    VS_OUTPUT Out = (VS_OUTPUT)0;
    
    // J_̃[hr[ˉeϊ
    Out.Pos = mul( Pos, WorldViewProjMatrix );
    
    // JƂ̑Έʒu
    Out.Eye = CameraPosition - mul( Pos, WorldMatrix );
    // _@
    Out.Normal = normalize( mul( Normal, (float3x3)WorldMatrix ) );
    
    // fBt[YF{ArGgF vZ
    Out.Color.rgb = saturate( max(0,dot( Out.Normal, -LightDirection )) * DiffuseColor.rgb + AmbientColor );
    Out.Color.a = DiffuseColor.a;
    
    // eNX`W
    Out.Tex = Tex;
    
    return Out;
}

// sNZVF[_
float4 Basic_PS( VS_OUTPUT IN ) : COLOR0
{
    // XyLFvZ
    float3 HalfVector = normalize( normalize(IN.Eye) + -LightDirection );
    float3 Specular = pow( max(0,dot( HalfVector, normalize(IN.Normal) )), SpecularPower ) * SpecularColor;
    
    float4 Color = IN.Color;
    if ( use_texture ) {  //if͔I
        // eNX`Kp
        Color *= tex2D( ObjTexSampler, IN.Tex );
    }
    if ( use_toon ) {  //
        // gD[Kp
        float LightNormal = dot( IN.Normal, -LightDirection );
        // if(LightNormal<0){Color.rgb*=MaterialToon;} ƂĂ悢AẼhbgĂ܂̂łڂ
        Color.rgb *= lerp(MaterialToon, float3(1,1,1), saturate(LightNormal * 16 + 0.5));
    }
    // XyLKp
    Color.rgb += Specular;
    
    return Color;
}

// IuWFNg`peNjbN
technique MainTec < string MMDPass = "object"; > {
    pass DrawObject
    {
        VertexShader = compile vs_2_0 Basic_VS();
        PixelShader  = compile ps_2_0 Basic_PS();
    }
}


///////////////////////////////////////////////////////////////////////////////////////////////
// IuWFNg`iZtVhEONj

// VhEobt@̃TvB"register(s0)"Ȃ̂MMDs0gĂ邩
sampler DefSampler : register(s0);

struct BufferShadow_OUTPUT
{
    float4 Pos      : POSITION;     // ˉeϊW
    float4 ZCalcTex : TEXCOORD0;    // Zl
    float2 Tex      : TEXCOORD1;    // eNX`
    float3 Normal   : TEXCOORD2;    // @
    float3 Eye      : TEXCOORD3;    // JƂ̑Έʒu
    float4 Color    : COLOR0;       // fBt[YF
};

// _VF[_
BufferShadow_OUTPUT BufferShadow_VS(float4 Pos : POSITION, float3 Normal : NORMAL, float2 Tex : TEXCOORD0)
{
    BufferShadow_OUTPUT Out = (BufferShadow_OUTPUT)0;

    // J_̃[hr[ˉeϊ
    Out.Pos = mul( Pos, WorldViewProjMatrix );
    
    // JƂ̑Έʒu
    Out.Eye = CameraPosition - mul( Pos, WorldMatrix );
    // _@
    Out.Normal = normalize( mul( Normal, (float3x3)WorldMatrix ) );
	// Cg_ɂ郏[hr[ˉeϊ
    Out.ZCalcTex = mul( Pos, LightWorldViewProjMatrix );
    
    // fBt[YF{ArGgF vZ
    Out.Color.rgb = saturate( max(0,dot( Out.Normal, -LightDirection )) * DiffuseColor.rgb + AmbientColor );
    Out.Color.a = DiffuseColor.a;
    
    // eNX`W
    Out.Tex = Tex;
    
    return Out;
}

// sNZVF[_
float4 BufferShadow_PS( BufferShadow_OUTPUT IN ) : COLOR
{
    // XyLFvZ
    float3 HalfVector = normalize( normalize(IN.Eye) + -LightDirection );
    float3 Specular = pow( max(0,dot( HalfVector, normalize(IN.Normal) )), SpecularPower ) * SpecularColor;
    
    float4 Color = IN.Color;
    float4 ShadowColor = float4(AmbientColor, Color.a);  // e̐F
    if ( use_texture ) {
        // eNX`Kp
        float4 TexColor = tex2D( ObjTexSampler, IN.Tex );
        Color *= TexColor;
        ShadowColor *= TexColor;
    }
    // XyLKp
    Color.rgb += Specular;
    
    // eNX`Wɕϊ
    IN.ZCalcTex /= IN.ZCalcTex.w;
    float2 TransTexCoord;
    TransTexCoord.x = (1.0f + IN.ZCalcTex.x)*0.5f;
    TransTexCoord.y = (1.0f - IN.ZCalcTex.y)*0.5f;
    
    if(TransTexCoord.x<0.0f || TransTexCoord.y<0.0f || TransTexCoord.x>1.0f || TransTexCoord.y>1.0f) {
        // VhEobt@O
        return Color;
    } else {
        float comp;
        if(parthf) {
            // ZtVhE mode2
            comp=1-saturate(max(IN.ZCalcTex.z-tex2D(DefSampler,TransTexCoord).r , 0.0f)*SKII2*TransTexCoord.y-0.3f);
        } else {
            // ZtVhE mode1
            comp=1-saturate(max(IN.ZCalcTex.z-tex2D(DefSampler,TransTexCoord).r , 0.0f)*SKII1-0.3f);
        }
        if ( use_toon ) {
            // gD[Kp
            comp = min(saturate(dot(IN.Normal,-LightDirection)*Toon),comp);
            ShadowColor.rgb *= MaterialToon;
        }
        float4 ans = lerp(ShadowColor, Color, comp);
        if( transp ) ans.a = 0.5f;
        return ans;
    }
}

// IuWFNg`peNjbN
technique MainTecBS  < string MMDPass = "object_ss"; > {
    pass DrawObject {
        VertexShader = compile vs_2_0 BufferShadow_VS();
        PixelShader  = compile ps_2_0 BufferShadow_PS();
    }
}


///////////////////////////////////////////////////////////////////////////////////////////////
