/* vi: ts=8 sw=8 : */
/**
	mkimgminixfs - create an minixfs image like as mkisofs

	Copyright (c) 2003 Masuichi Noritoshi <nor@users.sourceforge.jp>

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version
	2 of the License, or (at your option) any later version.

	from:

		linux/include/linux/minix_fs.h

		Copyright (C) 1991, 1992  Linus Torvalds
**/

#ifndef INCLUDE_MKIMGMINIXFS_H
#define INCLUDE_MKIMGMINIXFS_H

#include <util.h>

#define MINIX_ROOT_INO 1

/* Not the same as the bogus LINK_MAX in <linux/limits.h>. Oh well. */
#define MINIX_LINK_MAX	250
#define MINIX2_LINK_MAX	65530

#define MINIX_I_MAP_SLOTS	8
#define MINIX_Z_MAP_SLOTS	64
#define MINIX_SUPER_MAGIC	0x137F		/* original minix fs */
#define MINIX_SUPER_MAGIC2	0x138F		/* minix fs, 30 char names */
#define MINIX2_SUPER_MAGIC	0x2468		/* minix V2 fs */
#define MINIX2_SUPER_MAGIC2	0x2478		/* minix V2 fs, 30 char names */
#define MINIX_VALID_FS		0x0001		/* Clean fs. */
#define MINIX_ERROR_FS		0x0002		/* fs has errors. */
#define MINIX_MAX_ZONES		0xffff

#define MINIX_INODES_PER_BLOCK ((BLOCK_SIZE)/(sizeof (struct minix_inode)))
#define MINIX2_INODES_PER_BLOCK ((BLOCK_SIZE)/(sizeof (struct minix2_inode)))

#define MINIX_V1		0x0001		/* original minix fs */
#define MINIX_V2		0x0002		/* minix V2 fs */

#define INODE_VERSION(inode)	inode->i_sb->u.minix_sb.s_version


/* block size */

#define BLOCKSIZE         1024
#define BYTES_PER_INODE   (3*BLOCKSIZE)


/* inode block size (why is it != BLOCKSIZE ?!?) */

#define INODE_BLOCKSIZE   512
#define INOBLK            (BLOCKSIZE / INODE_BLOCKSIZE)

/**
	number of 512byte-blocks in ext2fs-block
**/
#define B512PERBLOCK      (BLOCKSIZE / 512)

/* reserved inodes */

#define MINIX_INIT_BLOCK    0xFFFFFFFF
#define WALK_END           0xFFFFFFFE

typedef struct {
	uint8 bm[BLOCKSIZE];
} TBitmap;

#if BLOCKSIZE != 1024
	/* FIX ME! */
#error TMinixfs can handle only block which size is 1024.
#endif


/*
 * Constants relative to the data blocks
 */
#define	MINIX_NDIR_BLOCKS	7
#define	MINIX_IND_BLOCK		MINIX_NDIR_BLOCKS
#define	MINIX_DIND_BLOCK	(MINIX_IND_BLOCK + 1)
#define	MINIX_TIND_BLOCK	(MINIX_DIND_BLOCK + 1)
#define	MINIX_N_BLOCKS		(MINIX_TIND_BLOCK + 1)

#define MINIX_IFMT  		0xF000	/* format mask */
#define MINIX_IFHLNK 		0xE000	/* hardlink (only for internal use) */
#define MINIX_IFLNK 		0xA000	/* symlink */
#define MINIX_IFSOCK 		0xC000	/* socket */
#define MINIX_IFREG  		0x8000	/* regular file */
#define MINIX_IFBLK		0x6000	/* block device */
#define MINIX_IFDIR		0x4000	/* directory */
#define MINIX_IFCHR		0x2000	/* character device */
#define MINIX_IFIFO		0x1000	/* fifo */

#define MINIX_ISUID		0x0800	/* SUID */
#define MINIX_ISGID		0x0400	/* SGID */
#define MINIX_ISVTX		0x0200	/* sticky bit */

#define MINIX_IRWXU		0x01C0	/* user mask */
#define MINIX_IRUSR		0x0100	/* read */
#define MINIX_IWUSR		0x0080	/* write */
#define MINIX_IXUSR		0x0040	/* execute */

#define MINIX_IRWXG		0x0038	/* group mask */
#define MINIX_IRGRP		0x0020	/* read */
#define MINIX_IWGRP		0x0010	/* write */
#define MINIX_IXGRP		0x0008	/* execute */

#define MINIX_IRWXO		0x0007	/* other mask */
#define MINIX_IROTH		0x0004	/* read */
#define MINIX_IWOTH		0x0002	/* write */
#define MINIX_IXOTH		0x0001	/* execute */

typedef struct {
	uint16 i_mode;
	uint16 i_uid;
	uint32 i_size;
	uint32 i_time;
	uint8  i_gid;
	uint8  i_links_count;
	uint16 i_zone[9];
} inode;

/*
 * Structure of the super block
 */
typedef struct {
	uint16 s_inodes_count;	/* s_ninodes; */
	uint16 s_zones_count;	/* s_nzones; */
	uint16 s_imap_blocks;
	uint16 s_zmap_blocks;
	uint16 s_firstdatazone;
	uint16 s_log_zone_size;
	uint32 s_max_size;
	uint16 s_magic;
	uint16 s_state;
	uint32 s_zones;
	uint32 s_reserved[250];	/* Padding to the end of the block */
} superblock;

/*
 * Structure of a directory entry
 */

typedef struct {
	uint16	d_inode;		/* Inode number */
	char	d_name[0];		/* File name */
} directory;

typedef struct
{
	TVfs mCommon;		/* Virtual Filesystem infomation */
	uint8* rawimg;		/* The raw image of filesystem */
	superblock* sb;		/* The superblock */
	TBitmap* bbm;		/* The block bitmap */
	TBitmap* ibm;		/* The inode bitmap */
	inode* itab;		/* The inode table */
	uint32 mFsVersion;
	uint32 mDirNameLen;
} TMinixfs;

typedef struct
{
	TMinixfs* asnfs;		/* link to filesystem */
	uint32 asnod;
	inode* asnode;
	uint32 bnum;		/* number of allocated blocks */
	uint32 state;		/* direct/indirect -state */
	uint32 bpdir;		/* index of direct block */
	uint32 bpind;		/* index of indirect block */
	uint32 bpdind;		/* index of double indirect block */
	uint32 bptind;		/* index of triple indirect block */
				/* Not support tri-ind : FIX ME ! */
} TBpFs;

#define MINIX_BP_STATE_INI		0
#define MINIX_BP_STATE_DIR		1
#define MINIX_BP_STATE_DIR_LAST		2
#define MINIX_BP_STATE_IND		3
#define MINIX_BP_STATE_IND_LAST		4
#define MINIX_BP_STATE_DIND		5
#define MINIX_BP_STATE_DIND_LAST	6
#define MINIX_BP_STATE_TIND		7
#define MINIX_BP_STATE_TIND_LAST	8
#define MINIX_BP_STATE_TOO_DEEP		9

#define	MINIX_BP_FINI	0xFFFFFFFE
#define	MINIX_BP_INIT	0xFFFFFFFF
#define	MINIX_BP_IND	MINIX_IND_BLOCK
#define	MINIX_BP_DIND	MINIX_DIND_BLOCK
#define	MINIX_BP_TIND	MINIX_TIND_BLOCK
/**

bpdir			bpind	bpdind	BLOCK NO in INODE
------------------------------------------------------------------
MINIX_BP_INIT(-1)	*	*	(initial state)
0			*	*	block 0.
...					...
11			*	*	block 11.
MINIX_BP_IND(6)		0	*	block 11+1.
			...		...
MINIX_BP_IND(6)		IPB-1	*	block 11+IPB		
MINIX_BP_DIND(7)	0	0	block 11+IPB+1
				...	...
MINIX_BP_DIND(7)	0	IPB-1	block 11+IPB+IPB
			...	...	...
MINIX_BP_DIND(7)	IPB-1	IPB-1	block 11+IPB+IPB*IPB
MINIX_BP_TIND(8)	*	*	(PANIC !)

**/

#endif /* INCLUDE_MKIMGMINIXFS_H */

/* END-OF-FILE */
