/* vi: sw=8 ts=8 : */
/**
	mkimgfatfs - create a FAT image like as mkisofs

	Copyright (c) 2003 Masuichi Noritoshi <nor@users.sourceforge.jp>

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version
	2 of the License, or (at your option) any later version.
**/

#ifndef INCLUDE_MKIMGFATFS_H
#define INCLUDE_MKIMGFATFS_H

#define ATTR_RO      1		/* read-only */
#define ATTR_HIDDEN  2		/* hidden */
#define ATTR_SYS     4		/* system */
#define ATTR_VOLUME  8		/* volume label */
#define ATTR_DIR     16		/* directory */
#define ATTR_ARCH    32		/* archived */

/*
 * Structure of the super block
 */
typedef struct {
	uint8	s_jump_to_bootcode[3];	/* Boot strap short or near jump */
	uint8	s_system_id[8];		/* SYSTEM ID */
	uint8	s_sector_size[2];	/* bytes per logical sector */
	uint8	s_sectors_per_cluster;	/* sectors per cluster */
	uint16	s_reserved_sectors;	/* reserved sectors */
	uint8	s_fats;			/* number of FATs */
	uint8	s_dir_entries[2];	/* root directory entries */
	uint8	s_total_sectors[2];	/* number of sectors */
	uint8	s_media;	/* media code (unused) */
	uint16	s_sectors_per_fat;	/* sectors per FAT */
	uint16	s_sectors_per_track;	/* sectors per track */
	uint16	s_heads;		/* number of heads */
	uint32	s_hidden_sectors;	/* hidden sectors (unused) */
	uint32	s_total_sectors_2;	/* number of sectors (if sectors == 0) */
	uint8	s_reserved1;		/* Unused */
	uint8	s_reserved2; 		/* Unused */
	uint8	s_extbootsign;		/* 0x29 if fields below exist (DOS 3.3+) */
	uint8	s_volume_id[4];		/* Volume ID number */
	uint8	s_volume_label[11];	/* Volume label */
	uint8	s_fs_type[8];		/* Typically FAT12 or FAT16 */
	uint8	s_boot_code[448];	/* Boot code (or message) */
	uint16	s_magic;		/* 0xAA55 */
} TFatSuperSector;

/*
 * Structure of a directory entry
 */
typedef struct {
    uint8 name[8], ext[3];	/* name and extension */
    uint8 attr;		/* attribute bits */
    uint8 unused[10];
    uint16 time, date, start;	/* time, date and first cluster */
    uint32 size;		/* file size (in bytes) */
} TFatDirEnt;

typedef struct {
	TVfs mCommon;		/* Virtual Filesystem infomation */
	uint8* mRawImage;	/* The raw image of filesystem */
	TFatSuperSector* mFSS;	/* The fat boot sector */
	/* */
	uint8* mFAT;		/* The first file allocation table */
	uint32 s_fats;	 	/* number of FATs */
	uint32 s_sectors_per_fat;	/* sectors per FAT */
	/* */
	TFatDirEnt* mRootDir;	/* The first entry of the root directory */
	uint32 s_dir_entries;	/* root directory entries */
	/* */
	uint8* mData;
	/* */
	uint32	s_sector_size;		/* bytes per logical sector */
	uint32	s_sectors_per_cluster;	/* sectors per cluster */
	uint32	s_reserved_sectors;	/* reserved sectors */
	uint32	s_total_sectors;	/* number of sectors */
	uint32	s_data_clusters;
	uint32	s_data_sectors;
	uint32	s_dir_sectors;
	uint32	s_cluster_size;
} TFatfs;

typedef struct
{
	TFatfs* asnfs;		/* link to filesystem */
	uint32 asnod;
	TFatDirEnt* asnode;
	uint32 bpdir;		/* index of direct block */
} TBpFs;

typedef struct {
	TVfsParam mCommon;
	int nbsectors;
	int nbentries;
	int nbresrvd;
	int nbfats;
} TFatfsParam;

#endif /* INCLUDE_MKIMGFATFS_H */

/* END-OF-FILE */

