/* vi: ts=8 sw=8 : */
/**
        libmkimgfs - support library for creating filesystem images

	Copyright (C) 2002-2003 Masuichi Noritoshi <nor@users.sourceforge.jp>

        This program is free software; you can redistribute it and/or
        modify it under the terms of the GNU General Public License
        as published by the Free Software Foundation; either version
        2 of the License, or (at your option) any later version.
**/

#ifndef INCLUDE_UTIL_H
#define INCLUDE_UTIL_H

/**
	types that were designated the size.
**/
typedef signed char int8;
typedef unsigned char uint8;
typedef signed short int16;
typedef unsigned short uint16;
typedef signed int int32;
typedef unsigned int uint32;

extern const char * g_ThisExecName;

void* ut_Malloc(size_t s);
void ut_Free(void* p);
char* ut_TokenZ(char** s);
inline uint32 ut_RoundUp(uint32 n, uint32 u);
uint32 ut_StringToMode(const char *p);
char* ut_GenBasename(const char* s);
char* ut_GenDirname(const char* s);
void errexit(const char *fmt, ...);
void pexit(const char *fname);

#define XMALLOC(t,n)	((t*)ut_Malloc(sizeof(t) * (n)))
/**
	Use this macro, if free(3) permits  NULL .
	Use another one, if not.
**/
#define Safe_Free(v)	do { ut_Free(v); v = NULL; } while (0)
/* #define Safe_Free(v)	do { if (v) { ut_Free(v); v = NULL; } } while (0) */

#define SafeDel_PROP(v)		Safe_Free(v)
#define SafeDel(fini,v)		do { fini(v); Safe_Free(v); } while (0)


#endif /* INCLUDE_UTIL_H */

/* END-OF-FILE */
