/* vi: sw=8 ts=8 */
/**
        libmkimgfs - support library for creating filesystem images

	Copyright (C) 2002-2003 Masuichi Noritoshi <nor@users.sourceforge.jp>

        This program is free software; you can redistribute it and/or
        modify it under the terms of the GNU General Public License
        as published by the Free Software Foundation; either version
        2 of the License, or (at your option) any later version.
**/

#ifndef INCLUDE_SRCINODE_H
#define INCLUDE_SRCINODE_H

#include <util.h>
#include <splitpath.h>

#define VFS_IFMT  			0xF000	/* format mask */
#define VFS_IFHLNK 			0xE000	/* hardlink (only for internal use) */
#define VFS_IFLNK 			0xA000	/* symlink */
#define VFS_IFSOCK 			0xC000	/* socket */
#define VFS_IFREG  			0x8000	/* regular file */
#define VFS_IFBLK			0x6000	/* block device */
#define VFS_IFDIR			0x4000	/* directory */
#define VFS_IFCHR			0x2000	/* character device */
#define VFS_IFIFO			0x1000	/* fifo */

#define VFS_ISUID			0x0800	/* SUID */
#define VFS_ISGID			0x0400	/* SGID */
#define VFS_ISVTX			0x0200	/* sticky bit */

#define VFS_IRWXU			0x01C0	/* user mask */
#define VFS_IRUSR			0x0100	/* read */
#define VFS_IWUSR			0x0080	/* write */
#define VFS_IXUSR			0x0040	/* execute */

#define VFS_IRWXG			0x0038	/* group mask */
#define VFS_IRGRP			0x0020	/* read */
#define VFS_IWGRP			0x0010	/* write */
#define VFS_IXGRP			0x0008	/* execute */

#define VFS_IRWXO			0x0007	/* other mask */
#define VFS_IROTH			0x0004	/* read */
#define VFS_IWOTH			0x0002	/* write */
#define VFS_IXOTH			0x0001	/* execute */

#define VFS_ERR_CONV			0x10000	/* conversion error (only for return code) */

typedef struct {
	uint32 mMode;
	uint32 mUid;
	uint32 mGid;
	uint32 mMajor;
	uint32 mMinor;
	uint32 mAtime;
	uint32 mCtime;
	uint32 mMtime;
	char* mSourcePath;
	TSplitPath* mTargets;
} TSrcInode; 

void TSrcInode_Init(TSrcInode* ce);
TSrcInode* TSrcInode_New(void);
TSrcInode* TSrcInode_New_String(const char* s);
void TSrcInode_Fini(TSrcInode* ce);
void TSrcInode_AddTarget(TSrcInode* ce, const char* s);

extern const char* g_PrefixOfRelatvePath;

#endif /* INCLUDE_SRCINODE_H */

/* END-OF-FILE */
