/*
 * Decompiled with CFR 0.152.
 */
package com.petebevin.markdown.test;

import com.petebevin.markdown.MarkdownProcessor;
import com.petebevin.markdown.test.TestResultPair;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class MarkupFileTester
extends TestCase {
    TestResultPair pair;

    public MarkupFileTester(TestResultPair pair) {
        super(pair.toString());
        this.pair = pair;
    }

    public static Test suite() throws IOException {
        TestSuite suite = new TestSuite("Test files");
        suite.addTest(MarkupFileTester.newSuite("tests/dingus.txt"));
        suite.addTest(MarkupFileTester.newSuite("tests/paragraphs.txt"));
        suite.addTest(MarkupFileTester.newSuite("tests/snippets.txt"));
        suite.addTest(MarkupFileTester.newSuite("tests/lists.txt"));
        return suite;
    }

    public static Test newSuite(String filename) throws IOException {
        String line;
        TestSuite suite = new TestSuite("Markdown file " + filename);
        FileReader file = new FileReader(filename);
        BufferedReader in = new BufferedReader(file);
        StringBuffer test = null;
        StringBuffer result = null;
        Pattern pTest = Pattern.compile("# Test (\\w+) \\((.*)\\)");
        Pattern pResult = Pattern.compile("# Result (\\w+)");
        int lineNumber = 0;
        String testNumber = null;
        String testName = null;
        StringBuffer curbuf = null;
        while ((line = in.readLine()) != null) {
            ++lineNumber;
            Matcher mTest = pTest.matcher(line);
            Matcher mResult = pResult.matcher(line);
            if (mTest.matches()) {
                MarkupFileTester.addTest(suite, test, result, testNumber, testName);
                testNumber = mTest.group(1);
                testName = mTest.group(2);
                test = new StringBuffer();
                result = new StringBuffer();
                curbuf = test;
                continue;
            }
            if (mResult.matches()) {
                if (testNumber == null) {
                    throw new RuntimeException("Test file has result without a test (line " + lineNumber + ")");
                }
                String resultNumber = mResult.group(1);
                if (!testNumber.equals(resultNumber)) {
                    throw new RuntimeException("Result " + resultNumber + " test " + testNumber + " (line " + lineNumber + ")");
                }
                curbuf = result;
                continue;
            }
            curbuf.append(line);
            curbuf.append("\n");
        }
        MarkupFileTester.addTest(suite, test, result, testNumber, testName);
        return suite;
    }

    private static void addTest(TestSuite suite, StringBuffer testbuf, StringBuffer resultbuf, String testNumber, String testName) {
        if (testbuf == null || resultbuf == null) {
            return;
        }
        String test = MarkupFileTester.chomp(testbuf.toString());
        String result = MarkupFileTester.chomp(resultbuf.toString());
        String id = String.valueOf(testNumber) + "(" + testName + ")";
        suite.addTest((Test)new MarkupFileTester(new TestResultPair(id, test, result)));
    }

    private static String chomp(String s) {
        int lastPos = s.length() - 1;
        while (s.charAt(lastPos) == '\n' || s.charAt(lastPos) == '\r') {
            --lastPos;
        }
        return s.substring(0, lastPos + 1);
    }

    public void runTest() {
        MarkdownProcessor markup = new MarkdownProcessor();
        MarkupFileTester.assertEquals((String)this.pair.toString(), (String)this.pair.getResult().trim(), (String)markup.markdown(this.pair.getTest()).trim());
    }
}

